""" The base class for all resource context adapter factories. """


# Enthought library imports.
from enthought.naming.api import Context, ContextAdapterFactory
from enthought.traits.api import Instance


class ResourceContextAdapterFactory(ContextAdapterFactory):
    """ The base class for all resource context adapter factories. """

    #### 'ResourceContextAdapterFactory' interface ############################
    
    # The resource type that we are the context adapter for.
    resource_type = Instance('enthought.envisage.resource.ResourceType')

    ###########################################################################
    # Protected 'AdapterFactory' interface.
    ###########################################################################

    def _can_adapt(self, adaptee, target_class, *args, **kw):
        """ Returns True if the factory can produce an appropriate adapter. """

        can_adapt = target_class is Context \
                    and adaptee is not None \
                    and self.resource_type.is_type_for(adaptee)

        return can_adapt

#### EOF ######################################################################
