""" The resource type for Python floats. """


# Enthought library imports.
from enthought.envisage.resource import ObjectResourceType
from enthought.traits.api import Float

# Local imports.
from float_node_type import FloatNodeType


class FloatResourceType(ObjectResourceType):
    """ The resource type for Python floats. """

    #### 'ResourceType' interface #############################################

    # A trait that describes the kind of domain object that the type
    # represents.
    type = Float

    ###########################################################################
    # 'ResourceType' interface.
    ###########################################################################

    #### Initializers #########################################################

    def _node_type_default(self):
        """ Initializes the node type. """

        return FloatNodeType(resource_type=self)

##### EOF #####################################################################
