#-----------------------------------------------------------------------------
#
#  Copyright (c) 2006 by Enthought, Inc.
#  All rights reserved.
#
#  Author: Janet Swisher <swisher@enthought.com>
#
#-----------------------------------------------------------------------------

"""
A resource representing an action to create a resource.

"""


# Enthought library imports
from enthought.envisage.resource.action_resource import ActionResource
from enthought.pyface.api import ImageResource


class CreateActionResource(ActionResource):
    """
    A resource representing an action to create a resource.

    """

    #### public 'ActionResource' interface ###################################

    # The image used to represent nodes of this type.
    def _image_default( self ):
        return ImageResource('create_action')


#### EOF #####################################################################

