#-------------------------------------------------------------------------------
#  
#  Extension points for the repository plugin.  
#  
#  Written by: David C. Morrill
#  
#  Date: 04/04/2006
#  
#  (c) Copyright 2006 by Enthought, Inc.
#  
#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
#  Imports:  
#-------------------------------------------------------------------------------

from enthought.traits.api \
    import Str
    
from enthought.envisage \
    import ExtensionPoint

#-------------------------------------------------------------------------------
#  'RepositoryRootFactory' extension point class:  
#-------------------------------------------------------------------------------

class RepositoryRootFactory ( ExtensionPoint ):
    """ The definition of a RepositoryRoot factory.
    """

    # The name of the class that implements the 'ResourceRootFactory' interface:
    class_name = Str
    
    # The id of the Repository service this item applies to:
    id = Str( 'enthought.envisage.repository.IRepository' )
    
#-------------------------------------------------------------------------------
#  'ExportableObject' extension point class:  
#-------------------------------------------------------------------------------
    
class ExportableObject ( ExtensionPoint ):
    """ The definition of an exportable object.
    """
    
    # The name of the object class that can be exported:
    class_name = Str
    
    # The id of the resource type associated with the class:
    id = Str
    
    # The label used to describe the object when it is being exported:
    label = Str

