""" Functions to create a simple test project. """


# Standard library imports.
import os

# Enthought library imports.
from enthought.io import File


def create_project(name, workspace):
    """ Creates a project in the specified workspace root. """

    # Create an empty project.
    project = workspace.create_project(name)
    
    #### A sub-folder containing 2 Python scripts #############################
    
    scripts = project.create_folder('scripts')
    
    foo = File(os.path.join(scripts.path, 'foo.py'))
    scripts.bind('foo.py', foo)
    
    f = file(foo.path, 'w')
    f.write('print "foo!"\n')
    f.close()

    bar = File(os.path.join(scripts.path, 'bar.py'))
    scripts.bind('bar.py', bar)

    f = file(bar.path, 'w')
    f.write('print "bar!"\n')
    f.close()

    return project

##### EOF #####################################################################
