/*!***************************************************************************

  module      : IspcCGenHFile.cpp

  -------------------------------------------------------------------------

  responsible : FerdiF

  special area: IDL to Code Generator   
  description : Generate header file out of generated XML file
				
  
  last changed: 2000-03-08  11:22
  see also    : 

  -------------------------------------------------------------------------

  copyright:    Copyright by SAP AG, 2000



    ========== licence begin LGPL
    Copyright (C) 2000 SAP AG

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    ========== licence end

*****************************************************************************/


#include <ctype.h>
#if defined(_WIN32) && (_MSC_VER >= 1300)
#include <fstream>
#define endl std::endl
#else
#include <fstream.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <iostream.h>
#endif

#include "idl/xml2ispc/IspcCGenHFile.h"
#include "idl/xml2ispc/IspcErrorHandling.h" /* PTS 1131325, PG */
#ifndef ISPCIDL2CODE_H
#include "idl/xml2ispc/IspcIdl2Code.h"
#endif

/*----------------------------------------------------------------------*/
/* class IspcCGenHFile                                                  */
/*----------------------------------------------------------------------*/

IspcCGenHFile::IspcCGenHFile() {
  m_is_within_import  = '\0';
  m_is_within_include = '\0';
  m_is_within_struct  = 0;
  m_is_within_enum    = 0;     /* PTS 1131325, PG */
  m_is_livecachetypes = 0;     /* PTS 1131325, PG */
  m_gen_def_constr    = 0;     /* PTS 1131325, PG */
  m_gen_tab_handle    = false; /* PTS 1131325, PG */
  m_features_76       = false; /* PTS 1131325, PG */
  m_typedef_check     = false; /* PTS 1131325, PG */
};

/*----------------------------------------------------------------------*/

IspcCGenHFile::~IspcCGenHFile() {
  m_out_h << endl; /* PTS 1110140 */
  m_out_h.close();
  m_out_c << endl; /* PTS 1110140 */
  m_out_c.close();
};

/*----------------------------------------------------------------------*/

int IspcCGenHFile::Init( char* cFilename, bool features_76, bool typedef_check ) {
  m_is_within_import  = '\0';
  m_is_within_include = '\0';
  m_is_within_struct  = 0;
  m_is_livecachetypes = !strncmp( cFilename, "OMS_LiveCacheTypes" , 18 );
  m_features_76       = features_76;                      /* PTS 1131325, PG */
  m_typedef_check     = ( features_76 && typedef_check ); /* PTS 1131325, PG */
  strcpy(&m_filename[0], cFilename);
  char* pc = strrchr(&m_filename[0],'.');
  if ( pc ) {
    *pc = '\0';
  }
  if (m_features_76) { /* PTS 1131325, PG */
    int len = strlen(&m_filename[0]) - 5;
    if (0 == strncmp( &m_filename[len], "__mgd", 5 )) {
      m_filename[len] = '\0';
    }
  }
#if defined(_WIN32)
  pc = strrchr(m_filename,'\\'); 
#else
  pc = strrchr(m_filename,'/'); 
#endif
  if ( pc )
    strcpy(m_name, pc + 1);
  else
    strcpy(m_name,&m_filename[0]);


  m_out_h.open(strcat(&m_filename[0],".h"));
  if ( m_out_h.fail() )
    return 0;
  strcpy(&m_filename[0],m_name);
  m_out_c.open(strcat(&m_filename[0],"_i.c"));
  if ( m_out_c.fail() )
    return 0;

  /* PTS 1131325, PG */
  if (!m_is_livecachetypes) {
    m_out_h << "#ifndef __" << &m_name[0] << "_h__"          << endl;
    m_out_h << "#define __" << &m_name[0] << "_h__"          << endl;
    m_out_h                                                  << endl;
    m_out_h << "#include \"oaidl.h\" /* no check */"         << endl; /* PTS 1112974 */
    m_out_h                                                  << endl;
    m_out_h << "#ifndef __I" << &m_name[0] << "_FWD_DEFINED__"                   << endl;
    m_out_h << "#define __I" << &m_name[0] << "_FWD_DEFINED__"                   << endl;
    m_out_h << "typedef struct I" << &m_name[0] << " I" << &m_name[0] << ";"  << endl; /* PTS XXXXXX */
    m_out_h << "#endif  /* __I" << &m_name[0] << "_FWD_DEFINED__ */"             << endl;
    m_out_h                                                                      << endl;
    m_out_h << "#ifndef __" << &m_name[0] << "_FWD_DEFINED__"                    << endl;
    m_out_h << "#define __" << &m_name[0] << "_FWD_DEFINED__"                    << endl;
    m_out_h                                                  << endl;
    m_out_h << "#ifdef __cplusplus"                          << endl;
    m_out_h << "typedef class " << &m_name[0] << " " << &m_name[0] << ";"  << endl;
    m_out_h << "#else"                                       << endl;
    m_out_h << "typedef struct " << &m_name[0] << " " << &m_name[0] << ";" << endl;
    m_out_h << "#endif   /* __cplusplus */"                  << endl;
    m_out_h                                                  << endl;
    m_out_h << "#endif /* __" << &m_name[0] << "_FWD_DEFINED__ */" << endl;
  }
  else {
    m_out_h << endl;
#if defined(_WIN32)
    m_out_h << "#pragma warning( disable: 4049 )  /* more than 64k source lines */" << endl;
    m_out_h << endl;
#endif
    m_out_h << "#ifndef __" << &m_name[0] << "_h__" << endl;
    m_out_h << "#define __" << &m_name[0] << "_h__" << endl;
    m_out_h << endl;
#if defined(_WIN32)
    m_out_h << "#include \"oaidl.h\" /* no check */" << endl;
    m_out_h << endl;
#endif
    m_out_h << "#ifdef __cplusplus" << endl;
    m_out_h << "extern \"C\"{" << endl;
    m_out_h << "#endif" << endl;
    m_out_h << endl;
  }

  m_out_c << "#ifdef __cplusplus" << endl;
  m_out_c << "extern \"C\"{" << endl;
  m_out_c << "#endif" << endl << endl;

  m_out_c << "#ifndef __IID_DEFINED__" << endl;
  m_out_c << "#define __IID_DEFINED__" << endl;
  m_out_c << "typedef struct _IID" << endl;
  m_out_c << "{" << endl;
  m_out_c << "    unsigned long x;" << endl;
  m_out_c << "    unsigned short s1;" << endl;
  m_out_c << "    unsigned short s2;" << endl;
  m_out_c << "    unsigned char  c[8];" << endl;
  m_out_c << "} IID;" << endl;
  m_out_c << "#endif // __IID_DEFINED__" << endl << endl;

  m_out_c << "#ifndef CLSID_DEFINED" << endl;
  m_out_c << "#define CLSID_DEFINED" << endl;
  m_out_c << "typedef IID CLSID;" << endl;
  m_out_c << "#endif // CLSID_DEFINED" << endl << endl;

  return 1;
};

/*----------------------------------------------------------------------*/

void IspcCGenHFile::startElement(int &error, const char *name, const char **atts) { /* PTS 1131325, PG */
  char lbuf[256];
  char lbuf2[256];

  /* PTS 1131325, PG */
  char sbuf[3];   /* only for values "  " and " ," */
  char nbuf[256]; /* for name */
  char tbuf[256]; /* for type */
  char dbuf[256]; /* for dimension */
  const Ispc_InterfaceType * ifType = NULL;
  bool onlyReg = false;

  if ( !m_is_within_import || ( elemImport_ispc == ispc_getElementType(name) ) ||
       ( (elemTypedef_ispc == ispc_getElementType(name)) && m_features_76 ) ) { /* PTS 1131325, PG */
    /* in case of 76 features, also within import mode types have to be registered in m_ift_list */
    if ( (elemTypedef_ispc == ispc_getElementType(name)) && m_features_76 ) {
      if (m_is_within_import) {
        onlyReg = true;
      }
      else {
        onlyReg = false;
      }
    }
    switch (ispc_getElementType(name)) {
    case elemLibrary_ispc:
      if ( attName_ispc == ispc_getAttributeType(atts[0]) ) {
        strcpy(&m_libname[0],atts[1]);
        m_out_h                                                  << endl;
        m_out_h  << "#ifndef __" << &m_libname[0] << "_LIBRARY_DEFINED__" << endl;
        m_out_h  << "#define __" << &m_libname[0] << "_LIBRARY_DEFINED__" << endl;
      }
      break;
    case elemCpp_ispc:
      if ( attString_ispc == ispc_getAttributeType(atts[0]) ) {
        /* +++++ PTS 1109570 +++++ */
        const char* pc1 = atts[1];
        char* pc2 = (char*)strchr( pc1, '\\' );
        
        lbuf[0] = '\0';
        while ( pc2 )
        {
          pc2++;
          if ( *pc2 == '\\' ) {
            *pc2 = '\0';
            strcat( lbuf, pc1 );
            pc1 = ++pc2;
          }
          pc2 = (char*)strchr( pc2, '\\' );
        }
        strcat( lbuf, pc1 );
        /* ----- PTS 1109570 ----- */
        /* strcat( lbuf, atts[1] );  PTS 1109570 */
        m_out_h  << lbuf << endl;
      }
      break;
    case elemPragma_ispc:
      if ( attPack_ispc == ispc_getAttributeType(atts[0])) {
        strcpy(lbuf,atts[1]);
        m_out_h  << endl << "#pragma pack(" << lbuf << ")" << endl;
      }
      break;
    case elemImport_ispc:
      if ( 0 == m_is_within_import ) {
        strcpy(lbuf,atts[1]);
        char* pc = strrchr(lbuf,'.');
        if ( pc ) {
          *pc = '\0';
          strcat(lbuf,".h");
        }
        m_out_h  << endl << "#include \"" << lbuf << "\"  /* no check */" << endl; /* PTS 1112974 */
      }
      m_is_within_import++;
      break;
    case elemConst_ispc:
      if ( attName_ispc == ispc_getAttributeType(atts[0]) ) {
        strcpy(lbuf,atts[1]);

        /* +++++ PTS 1109570 +++++ */
        const char* pc1 = atts[1];
        char* pc2 = (char*)strchr( pc1, '\\' );
        pc1 = atts[5];
        pc2 = (char*)strchr( pc1, '\"' );        
        lbuf2[0] = '\0';
        while ( pc2 && *(pc2+1) )
        {
          *pc2 = '\0';
          strcat( lbuf2, pc1 );
          strcat( lbuf2, "\\\"" );
          pc2++;
          pc1 = pc2;
          pc2 = (char*)strchr( pc1, '\"' );
        }
        strcat( lbuf2, pc1 );
        /* ----- PTS 1109570 ----- */
        /*strcpy(lbuf2,atts[5]); PTS 1109570 */
        if ( attString_ispc == ispc_getAttributeType(atts[4]))
          m_out_h << endl << "#define " << lbuf << " ( \"" << lbuf2 << "\" )" << endl;
        else
          m_out_h << endl << "#define " << lbuf << " ( " << lbuf2 << " )" << endl;
      }
      break;
    case elemTypedef_ispc:
      {
        const char *name_idx = "";
        const char *type_idx = "";
        const char *dim_idx  = "";
        
        for ( int i = 0; atts[i]; i=i+2) {
          XmlAttributeType_Enum_ispc attrtype = ispc_getAttributeType(atts[i]);
          switch ( attrtype ) {
          case attName_ispc: 
            name_idx = atts[i+1]; break;
          case attType_ispc:
            type_idx = atts[i+1]; break;
          case attDimension_ispc:
            dim_idx  = atts[i+1]; break;
          case attUuid_ispc:
          case attString_ispc:
          case attNumber_ispc:
          case attChar_ispc:
          case attPack_ispc:
          case attDirection_ispc:
          case attUnknown_ispc:
          default:
            break;
          }
        }            
        /* PTS 1131325, PG */
        if (m_features_76) {
          if ( ('\0' != *dim_idx) && (m_typedef_check) && (strcmp( name_idx, "OmsVersionId" )) ) {
            Ispc_ErrorMsg( C_DIMENSION_IN_TYPEDEF, type_idx, name_idx );
            if (!error) {
              error = - C_DIMENSION_IN_TYPEDEF;
            }
            break;
          }
          if ( (!m_ift_list.skipTypeReg(name_idx)) && (!m_ift_list.isRegistered(name_idx)) ) {
            ifType = m_ift_list.findType(type_idx);
            if (ifType) {
              m_ift_list.registerType( name_idx, ifType->getDefault() );
            }
            /* 
            else {
              It's either a structure, for which a default construcor should have been generated,
                       or a type not based on an OmsType, what should not be the case.
            }
            */
          }
          if (onlyReg) {
            break;
          }
        }
        m_out_h << endl << "typedef " << type_idx << " " << name_idx;
        if ( strlen(dim_idx) > 0 )
          m_out_h << "[ " << dim_idx << " ]";
        m_out_h << ";" << endl;
      }
      break;
    case elemStruct_ispc:
      m_is_within_struct++;
      if ( attName_ispc == ispc_getAttributeType(atts[0]) ) {
        strcpy(&m_structname[0],atts[1]);
        m_out_h << endl << "typedef struct " << &m_structname[0] << " { " << endl;
        /* PTS 1131325, PG */
        if (m_features_76) {
          if (atts[4]) {
            const char cYes[] = "YES";
            if (attGenDefConstr_ispc == ispc_getAttributeType(atts[4])) {
              if (0 == strcmp( atts[5], cYes )) {
                m_gen_def_constr = 2;
              }
            }
            else if (attGenTabHandle_ispc == ispc_getAttributeType(atts[4])) {
              if (0 == strcmp( atts[5], cYes )) {
                m_gen_tab_handle = true;
              }
            }
            if (atts[6]) {
              if (attGenDefConstr_ispc == ispc_getAttributeType(atts[6])) {
                if (0 == strcmp( atts[7], cYes )) {
                  m_gen_def_constr = 2;
                }
              }
              else if (attGenTabHandle_ispc == ispc_getAttributeType(atts[6])) {
                if (0 == strcmp( atts[7], cYes )) {
                  m_gen_tab_handle = true;
                }
              }
            }
          }
          if ( m_gen_def_constr ) {
            m_out_h << "   inline " << &m_structname[0] << "(); " << endl;
            m_def_constr_head = "inline ";
            m_def_constr_head.append(&m_structname[0]);
            m_def_constr_head.append("::");
            m_def_constr_head.append(&m_structname[0]);
            m_def_constr_head.append("() : ");
            m_def_constr_head.append("\n");
            m_def_constr_body = "\n";
            m_def_constr_body.append("{");
            m_def_constr_body.append("\n");
            m_def_constr_body.append("  int i;");
            m_def_constr_body.append("\n");
          }
        }
        /* PTS 1131520, PG */
        if (m_is_livecachetypes) {
          if (!strcmp( &m_structname[0], "OmsTypeABAPTimeStamp" ) ||
              !strcmp( &m_structname[0], "OmsTypePacked_8_3" )    ||
              !strcmp( &m_structname[0], "OmsTypePacked_15_3" )) {
            m_out_h << "#ifdef __cplusplus" << endl;
            m_out_h << "   inline " << &m_structname[0] << "(); " << endl;
            m_out_h << "#endif" << endl;
          }
        }
      }
      break;
    case elemMember_ispc:
      if ( m_is_within_struct ){
        if ( attType_ispc == ispc_getAttributeType(atts[2])) {
          strcpy(tbuf,atts[3]);
          strcpy(nbuf,atts[1]);
          m_out_h  << "   " << tbuf << " " << nbuf;
          if ( atts[4] && ( attDimension_ispc == ispc_getAttributeType(atts[4]))) {
            strcpy(dbuf,atts[5]);
            m_out_h  << "[ " << dbuf << " ]";
          }
          m_out_h  << ";" << endl;
        }
        /* PTS 1131325, PG */
        if (m_features_76) {
          if ( m_gen_def_constr ) {
            if ( 2 == m_gen_def_constr ) { /* next member to be initialized is the first to be initialized */
              strcpy( sbuf, "  " );
              m_gen_def_constr = 1;
            }
            else {
              strcpy( sbuf, " ," );
            }
            ifType = m_ift_list.findType(tbuf);
            if (ifType) {
              if ( atts[4] && (attDimension_ispc == ispc_getAttributeType(atts[4])) ) {
                m_def_constr_body.append("  for ( i = 0; i < ");
                m_def_constr_body.append(dbuf);
                m_def_constr_body.append("; i++ ) {");
                m_def_constr_body.append("\n");
                m_def_constr_body.append("    ");
                m_def_constr_body.append(nbuf);
                m_def_constr_body.append("[i] = ");
                m_def_constr_body.append(ifType->getDefault());
                m_def_constr_body.append(";");
                m_def_constr_body.append("\n");
                m_def_constr_body.append("  }");
                m_def_constr_body.append("\n");
              }
              else {
                if (0 == strcmp( sbuf, " ,")) {
                  m_def_constr_head.append("\n");
                }
                m_def_constr_head.append(sbuf);
                m_def_constr_head.append(nbuf);
                m_def_constr_head.append("(");
                m_def_constr_head.append(ifType->getDefault());
                m_def_constr_head.append(")");
              }
            }
          }
        }
      }
      else if (m_is_within_enum) {
        if (attValue_ispc == ispc_getAttributeType(atts[2])) {
          strcpy( lbuf, atts[1] );
          strcpy( lbuf2, atts[3] );
          if (2 == m_is_within_enum) {
            m_out_h  << "  " << lbuf << " = " << lbuf2;
            m_is_within_enum = 1;
          }
          else {
            m_out_h << "," << endl;
            m_out_h  << "  " << lbuf << " = " << lbuf2;
          }
        }
      }
      break;
    case elemEnum_ispc:
      /* PTS 1131325, PG */
      m_is_within_enum = 2;
      if (attName_ispc == ispc_getAttributeType(atts[0])) {
        strcpy( &m_enumname[0], atts[1] );
        m_out_h << endl << "typedef enum { " << endl;
      }
      break;
    case elemInclude_ispc:
      m_is_within_include++;
      break;
    case elemInterface_ispc:
      if ( attName_ispc == ispc_getAttributeType(atts[0]) ) {
        strcpy(&m_interfacename[0],atts[1]);
        
        const char *pc = atts[3];
        int i = 0;
        for ( ; *pc != '\0'; pc++ ) {
          if ( *pc != ' ' ) {
            m_iid[i] = *pc;
            i++;
          }
        }
        m_iid[i] = 0;

        //strcpy(&m_iid[0],atts[3]);
        m_out_h  << endl << "#ifndef __" << &m_interfacename[0] << "_INTERFACE_DEFINED__" << endl;
        m_out_h  << "#define __" << &m_interfacename[0] << "_INTERFACE_DEFINED__" << endl;
        m_out_h  << endl << "EXTERN_C const IID IID_" << &m_interfacename[0] << ";" << endl;
        m_out_h  << endl << "MIDL_INTERFACE(\"" << &m_iid[0] << "\")" << endl;
        m_out_h  << &m_interfacename[0] << " : public IUnknown {" << endl;
        m_out_h  << "public:" << endl << endl;
        m_out_c << "const IID IID_" << &m_interfacename[0] << " = {0x";

        for ( i=0; i < 8; i++ )  
          m_out_c  << m_iid[i];
        m_out_c  << ", 0x";
        for ( i=9; i < 13; i++ )  
          m_out_c  << m_iid[i];
        m_out_c  << ", 0x";
        for ( i=14; i < 18; i++ )  
          m_out_c  << m_iid[i];
        m_out_c  << ", {";
        for ( i=19; i < 23; i=i+2 )  
          m_out_c  << "0x" << m_iid[i] << m_iid[i+1] << ", ";
        for ( i=24; i < 34; i=i+2 )  
          m_out_c  << "0x" << m_iid[i] << m_iid[i+1] << ", ";
        m_out_c  << "0x" << m_iid[34] << m_iid[35] << "}};" << endl << endl;

      }
      break;
    case elemIdl_ispc:
      m_methode_param = 0;
      if ( attName_ispc == ispc_getAttributeType(atts[0]) ) {
        strcpy(lbuf,atts[1]);
        m_out_h  << endl << "    virtual HRESULT STDMETHODCALLTYPE " << lbuf << "(";
        break;
    case elemParam_ispc:
      {
        const char * name_idx = "";
        const char * type_idx = "";
        const char * direction_idx = "";
        unsigned int i;

        for ( i = 0; atts[i]; i=i+2) {
          XmlAttributeType_Enum_ispc attrtype = ispc_getAttributeType(atts[i]);
          switch ( attrtype ) {
          case attName_ispc: 
            name_idx = atts[i+1]; break;
          case attType_ispc:
            type_idx = atts[i+1]; break;
          case attDimension_ispc:
          case attString_ispc:
          case attNumber_ispc:
          case attChar_ispc:
          case attPack_ispc:
          case attDirection_ispc:
            direction_idx = atts[i+1]; break;
          case attUnknown_ispc:
          default:
            break;
          }
        }      
        
        if ( m_methode_param ) m_out_h << ",";
        m_methode_param++;
        m_out_h  << endl;
        strcpy(lbuf,type_idx);
        if ( !strcmp("bool",lbuf) ||
          !strcmp("bool*",lbuf)) {
          for (i = 0; i < strlen(lbuf); i++) lbuf[i] = toupper( lbuf[i] );         
        }

        if ( !strcmp("char",lbuf) ||
          !strcmp("char*",lbuf)) {
#if defined(_WIN32)
          m_out_h  << "      /* " << direction_idx << " */ unsigned " << lbuf  << " " << name_idx ;
#else
          m_out_h  << "      /* " << direction_idx << " */ signed " << lbuf  << " " << name_idx ;
#endif
        }
        else
          m_out_h  << "      /* " << direction_idx << " */ " << lbuf  << " " << name_idx ;
      }
      break;
    case elemCoClass_ispc:
      int i;
      m_out_h  << "};" << endl;
      m_out_h  << "#endif /* __" << &m_interfacename[0] << "_INTERFACE_DEFINED__ */" << endl;

      if ( attName_ispc == ispc_getAttributeType(atts[0]) ) {
        strcpy(lbuf,atts[1]);
      };
      if (attUuid_ispc == ispc_getAttributeType(atts[2])) {
        const char *pcAtts = atts[3];
        i = 0;
        for ( ; *pcAtts != '\0'; pcAtts++ ) {
          if ( *pcAtts != ' ' ) {
            lbuf2[i] = *pcAtts;
            i++;
          }
        }
        lbuf2[i] = 0;
      };
      m_out_h  << endl << "EXTERN_C const CLSID CLSID_" << lbuf << ";" << endl;
      m_out_h  << "class DECLSPEC_UUID(\"" << lbuf2 << "\") " << lbuf << ";" << endl;
      
      m_out_c << "const CLSID CLSID_" << lbuf << " = {0x";
      for ( i=0; i < 8; i++ )  
        m_out_c  << lbuf2[i];
      m_out_c  << ", 0x";
      for ( i=9; i < 13; i++ )  
        m_out_c  << lbuf2[i];
      m_out_c  << ", 0x";
      for ( i=14; i < 18; i++ )  
        m_out_c  << lbuf2[i];
      m_out_c  << ", {";
      for ( i=19; i < 23; i=i+2 )  
        m_out_c  << "0x" << lbuf2[i] << lbuf2[i+1] << ", ";
      for ( i=24; i < 34; i=i+2 )  
        m_out_c  << "0x" << lbuf2[i] << lbuf2[i+1] << ", ";
      m_out_c  << "0x" << lbuf2[34] << lbuf2[35] << "}};" << endl << endl;

      break;
    case elemUnknown_ispc:
      break;
    default:
      break;
      }
    }
  }
};

/*----------------------------------------------------------------------*/

void IspcCGenHFile::endElement(const char *name) {
  if ( m_is_within_import ) {
    switch (ispc_getElementType(name)) {
    case elemImport_ispc:
      m_is_within_import--;
      break;
    default:
      break;
    }
  }
  else
  {
    switch (ispc_getElementType(name)) {
    case elemIdl2Xml_ispc:
      if (m_is_livecachetypes) {
        m_out_h << endl;
        m_out_h << "#ifdef __cplusplus" << endl;
        m_out_h << "}" << endl;
        m_out_h << "#endif" << endl;
        m_out_h << endl;
      }
      m_out_h  << "#endif" << endl;
      m_out_c << "#ifdef __cplusplus" << endl;
      m_out_c << "}" << endl;
      m_out_c << "#endif" << endl;
      break;
    case elemLibrary_ispc:
      m_out_h  << endl << "#endif /* __" << &m_libname[0] << "_LIBRARY_DEFINED__ */" << endl;
      break;
    case elemCpp_ispc:
      break;
    case elemPragma_ispc:
      break;
    case elemInclude_ispc:
      m_is_within_include--;
      break;
    case elemConst_ispc:
      break;
    case elemTypedef_ispc:
      break;
    case elemStruct_ispc:
      m_is_within_struct--;
      m_out_h << "} " << &m_structname[0] << ";" << endl;
      /* PTS 1131325, PG */
      if (m_features_76) {
        if (m_gen_def_constr) {
          m_def_constr_body.append("}");
          m_def_constr_body.append("\n");
          m_out_h << endl;
          m_out_h << m_def_constr_head.data();
          m_out_h << m_def_constr_body.data();
          m_def_constr_head.erase();
          m_def_constr_body.erase();
        }
        m_gen_def_constr = 0;
        if (m_gen_tab_handle) {
          m_out_h << endl;
          m_out_h << "typedef struct " << &m_structname[0] << "TabHandle" << " {" << endl;
          m_out_h << "   " << &m_structname[0] << "* RowDef;" << endl;
          m_out_h << "   " << "OmsTypeABAPTabHandle Handle;" << endl;
          m_out_h << "} " << &m_structname[0] << "TabHandle;" << endl;
        }
        m_gen_tab_handle = false; 
      }
      /* PTS 1131520, PG */
      if (m_is_livecachetypes) {
        int isATS     = !strcmp( &m_structname[0], "OmsTypeABAPTimeStamp" ),
            isSPacked = !strcmp( &m_structname[0], "OmsTypePacked_8_3" ),
            isLPacked = !strcmp( &m_structname[0], "OmsTypePacked_15_3" );
        if ( isATS || isSPacked || isLPacked ) {
          m_out_h << endl;
          m_out_h << "#ifdef __cplusplus" << endl;
          m_out_h << "inline " << &m_structname[0] << "::" << &m_structname[0] << "() {" << endl;
          m_out_h << "  for ( int i = 0; i < ";
          if ( isATS || isSPacked ) {
            m_out_h << "7";
          }
          else {
            m_out_h << "14";
          }
          m_out_h << "; i++ ) {" << endl;
          if (isATS) {
            m_out_h << "    m_timeStamp";
          }
          else {
            m_out_h << "    m_packed";
          }
          m_out_h << "[i] = 0x00;" << endl;
          m_out_h << "  }" << endl;
          if (isATS) {
            m_out_h << "  m_timeStamp[7]";
          }
          else if (isSPacked) {
            m_out_h << "  m_packed[7]";
          }
          else {
            m_out_h << "  m_packed[14]";
          }
          m_out_h << " = 0x0c;" << endl;
          m_out_h << "}" << endl;
          m_out_h << "#endif" << endl;
        }
      }
      break;
    case elemMember_ispc:
      break;
    case elemEnum_ispc:
      /* PTS 1131325, PG */
      m_out_h << endl << "} " << &m_enumname[0] << ";" << endl;
      m_is_within_enum = 0;
      break;
    case elemInterface_ispc:
      break;
    case elemIdl_ispc:
       m_out_h  << "   ) = 0;" << endl;
       break;
    case elemCoClass_ispc:
      break;
    case elemUnknown_ispc:
      break;
    default:
      break;
    }
  }
};

