'\" t
.\" Manual page created with latex2man on Mon Mar 31 14:18:03 PST 2003
.\" NOTE: This file is generated, DO NOT EDIT.
.de Vb
.ft CW
.nf
..
.de Ve
.ft R

.fi
..
.TH "UNW\\_SET\\_CACHING\\_POLICY" "3" "31 March 2003" "Programming Library " "Programming Library "
.SH NAME
unw_set_caching_policy
\-\- set unwind caching policy 
.PP
.SH SYNOPSIS

.PP
#include <libunwind.h>
.br
.PP
int
unw_set_caching_policy(unw_addr_space_t
as,
unw_caching_policy_t
policy);
.br
.PP
.SH DESCRIPTION

.PP
The unw_set_caching_policy()
routine sets the caching policy 
of address space as
to the policy specified by argument 
policy\&.
The policy
argument can take one of three 
possible values: 
.TP
UNW_CACHE_NONE
 Turns off caching completely. This 
also implicitly flushes the contents of all caches as if 
unw_flush_cache()
had been called. 
.TP
UNW_CACHE_GLOBAL
 Enables caching using a global cache 
that is shared by all threads. If global caching is unavailable or 
unsupported, libunwind
may fall back on using a per\-thread 
cache, as if UNW_CACHE_PER_THREAD
had been specified. 
.TP
UNW_CACHE_PER_THREAD
 Enables caching using 
thread\-local caches. If a thread\-local caching are unavailable or 
unsupported, libunwind
may fall back on using a global cache, 
as if UNW_CACHE_GLOBAL
had been specified. 
.PP
If caching is enabled, an application must be prepared to make 
appropriate calls to unw_flush_cache()
whenever the target 
changes in a way that could affect the validity of cached information. 
For example, after unloading (removing) a shared library, 
unw_flush_cache()
would have to be called (at least) for the 
address\-range that was covered by the shared library. 
.PP
For address spaces created via unw_create_addr_space(3),
caching is turned off by default. For the local address space 
unw_local_addr_space,
caching is turned on by default. 
.PP
.SH RETURN VALUE

.PP
On successful completion, unw_set_caching_policy()
returns 0. 
Otherwise the negative value of one of the error\-codes below is 
returned. 
.PP
.SH THREAD AND SIGNAL SAFETY

.PP
unw_set_caching_policy()
is thread\-safe but \fInot\fP
safe 
to use from a signal handler. 
.PP
.SH ERRORS

.PP
.TP
UNW_ENOMEM
 The desired caching policy could not be 
established because the application is out of memory. 
.PP
.SH SEE ALSO

.PP
libunwind(3),
unw_create_addr_space(3),
unw_flush_cache(3)
.PP
.SH AUTHOR

.PP
David Mosberger\-Tang
.br 
Hewlett\-Packard Labs
.br 
Palo\-Alto, CA 94304
.br 
Email: \fBdavidm@hpl.hp.com\fP
.br
WWW: \fBhttp://www.hpl.hp.com/research/linux/libunwind/\fP\&.
.\" NOTE: This file is generated, DO NOT EDIT.
