/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "mas/mas_api_internal.h"

#define DEFAULT_PACKAGE_SIZE 1024

/** LOCAL PROTOTYPES *****************************************************/


/** EXPORTED FUNCTIONS ***************************************************/

int32
mas_mix_attenuate_linear( mas_device_t device, mas_port_t port, double multiplier )
{
    struct mas_package pkg;
    char buffer[128];

    masc_setup_package( &pkg, buffer, sizeof buffer, MASC_PACKAGE_STATIC );
    masc_push_int32( &pkg, port->portnum );
    masc_push_uint16( &pkg, (int16)(128*multiplier) );
    masc_finalize_package( &pkg );
    mas_set( device, "multiplier", &pkg );
    masc_strike_package( &pkg );
    
    return 0;
}

int32
mas_mix_attenuate_db( mas_device_t device, mas_port_t port, double mdb )
{
    struct mas_package pkg;
    char buffer[128];

    masc_setup_package( &pkg, buffer, sizeof buffer, MASC_PACKAGE_STATIC );
    masc_push_int32( &pkg, port->portnum );
    masc_push_int16( &pkg, (int16)(mdb) );
    masc_finalize_package( &pkg );
    mas_set( device, "gain_db", &pkg );
    masc_strike_package( &pkg );
    
    return 0;
}

int32
mas_mix_set_portname( mas_device_t device, mas_port_t port, const char *new_name )
{
    struct mas_event   event;
    struct mas_package predpack;
    char buffer[1024];

    /* make an event */
    masc_setup_event( &event );
    event.action_name = "mas_mix_set_portname";
    event.device_instance = device->device_instance;

    /* stuff the predicate package */
    masc_setup_package( &predpack, buffer, sizeof buffer, MASC_PACKAGE_STATIC );
    masc_push_int32( &predpack, port->portnum );
    masc_push_string( &predpack, new_name );
    masc_finalize_package( &predpack );
    event.predicate = predpack.contents;
    event.predicate_length = predpack.size;
    
    /* send it to the server */
    mas_send_event( &event, device->control_channel );
    masc_strike_package( &predpack );

    return 0;
}
