/*  The Blue Mango Quest
 *  Copyright (c) Clment 'phneutre' Bourdarias (code)
 *                   email: phneutre@users.sourceforge.net
 *                Guillaume 'GuBuG' Burlet (graphics)
 *                   email: gubug@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _MENUS_H
#define _MENUS_H

#define N_SKIRMISH_MENU_TEX 4
#define N_SKIRMISH_MENU_DYN_TEX 10

#define N_MAIN_MENU_TEX 4
#define N_MAIN_MENU_DYN_TEX 2

#define N_CREDITS_MENU_TEX 4

#define N_OPTIONS_MENU_TEX 4
#define N_OPTIONS_MENU_DYN_TEX 9

#define N_CAMPAIGN_MENU_TEX 4

#define SK_LIST_BUILTINS 0
#define SK_LIST_CUSTOMS 1
#define SK_LIST_MAX_ITEMS 13

struct map_list_item_t
{
  int slot;
  int map_size;
  int map_world;
  int map_time_limit;
  int map_num_huts;
  int map_num_shmolluxes;
  int map_num_lives;
  int map_winning_square;

  GLuint minimap;
  char is_minimap_loaded;

  char *text;
};

struct map_list_t
{
  int pos_x;
  int pos_y;

  int selected_slot;
  int selected_item;

  int num_items_total;
  int num_items_drawn;
  int max_items;

  map_list_item_t *items;
};

struct menu_common_t
{
  font_t tgaFont;
  GLuint t_cursor;
  GLuint t_cursor_mask;
  int mouse_x;
  int mouse_y;
  char is_button_down;
  char lock_mouse;
};

struct main_menu_t
{
  GLfloat mat_amb_diff[4];
  GLuint tex_menu[N_MAIN_MENU_TEX];
  GLuint tex_dyn_menu[N_MAIN_MENU_DYN_TEX];
  int loop_end;
};

struct credits_menu_t
{
  GLfloat mat_amb_diff[4];
  GLuint tex_menu[N_CREDITS_MENU_TEX];
//  GLuint tex_dyn_menu[N_CREDITS_MENU_DYN_TEX];
};

struct campaign_menu_t
{
  GLfloat mat_amb_diff[4];
  GLuint tex_menu[N_CAMPAIGN_MENU_TEX];
  int loop_end;
//  GLuint tex_dyn_menu[N_CAMPAIGN_MENU_DYN_TEX];
};

struct options_menu_t
{
  GLfloat mat_amb_diff[4];
  GLuint tex_menu[N_OPTIONS_MENU_TEX];
  GLuint tex_dyn_menu[N_OPTIONS_MENU_DYN_TEX];

  char need_draw_apply;
  char need_draw_back;

  options_t options_buffer;

  char option_modified;
};

struct skirmish_menu_t
{
  GLfloat mat_amb_diff[4];

  GLuint tex_menu[N_SKIRMISH_MENU_TEX];
  GLuint tex_dyn_menu[N_SKIRMISH_MENU_DYN_TEX];

  int active_list;
  char need_draw_up;
  char need_draw_down;
  char need_draw_launch;
  char need_draw_back;
  int loop_end;
};

struct ingame_menu_t
{
  GLuint tex_menu;
  GLuint tex_menu_mask;
  GLuint tex_menu_arrow;
  
  int selected_submenu;
  int old_selected_submenu;
};


/* functions for skirmish menu */
void draw_cursor();

/* MAIN MENU */
void load_menu_main();
void main_menu_loop();
void cleanup_menu_main();
void draw_main_menu_static();
void draw_main_menu_mouseover();
void draw_main_menu();

void analyze_main_menu_hoover();
void analyze_main_menu_buttondown(int *loop_flag);

/* SKIRMISH MENU */
void load_menu_skirmish();
void cleanup_menu_skirmish();

void skirmish_menu_loop();
void draw_skirmish_menu();
void draw_skirmish_mouse_over();

void analyze_skirmish_menu_buttondown(int *loop_flag);
void analyze_skirmish_menu_hoover();
void analyze_skirmish_bouttondown_on_map();
void draw_skirmish_menu_maps();

void menu_skirmish_down_arrow_pressed();
void menu_skirmish_up_arrow_pressed();

void draw_skirmish_menu_selected_map_infos();
void draw_skirmish_menu_selected_map_minimap();

void draw_skirmish_launch_active();
void draw_skirmish_back_active();
void draw_skirmish_custompanel_active();
void draw_skirmish_uparrow_active();
void draw_skirmish_downarrow_active();

void sk_reset_draw_needs();
void load_minimap_for_menu(int type, map_list_item_t *map_desc);
void menu_skirmish_launch_pressed(int type, map_list_item_t *map_desc);

/* CREDITS MENU */
void load_menu_credits();
void cleanup_menu_credits();
void draw_credits_menu_static();
void draw_credits_menu();
void credits_menu_loop();
void draw_credits_menu_text();

/* OPTIONS MENU */
void load_menu_options();
void cleanup_menu_options();
void draw_options_menu_static();
void draw_options_menu();
void options_menu_loop(char is_in_game);
void analyze_options_menu_hoover();
void analyze_options_menu_buttondown(int *loop_flag);

void draw_options_menu_mouseover();
void draw_options_apply_active();
void draw_options_back_active();
void options_reset_draw_needs();

void options_menu_apply();
void options_menu_read_options();

void options_menu_draw_dynamic_options();
void options_menu_draw_audio();
void options_menu_draw_video();
void options_menu_draw_mouse();
void options_menu_draw_gameplay();

/* CAMPAIGN MENU */
void load_menu_campaign();
void cleanup_menu_campaign();
void draw_campaign_menu_static();
void draw_campaign_menu();
void campaign_menu_loop();

/* INGAME_MENU */
void load_menu_ingame();
void draw_ingame_menu();
void analyze_ingame_menu_buttondown(int *loop_flag);
void ingame_menu_loop();
void cleanup_menu_ingame();
void draw_ingame_menu_static();
void draw_ingame_menu_mouseover();
void analyze_ingame_menu_hoover();
void draw_ingame_menu_big_arrow();
void analyze_ingame_menu_hoover();

#endif
