/*  The Blue Mango Quest
 *  Copyright (c) Clment 'phneutre' Bourdarias (code)
 *                   email: phneutre@users.sourceforge.net
 *                Guillaume 'GuBuG' Burlet (graphics)
 *                   email: gubug@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef WIN32
#include <windows.h>
#endif

#include <GL/gl.h>
#include <GL/glu.h>
#include <stdio.h>
#include "geom_bonus.h"

// 14 Verticies
// 26 Texture Coordinates
// 25 Normals
// 24 Triangles

static char DS_face_indicies[24][9] = {
  {0, 5, 6, 0, 1, 2, 0, 1, 2}, {5, 1, 9, 1, 3, 4, 1, 3, 4}, {5, 9, 6, 1, 4, 2,
                                                             1, 4, 2},
  {6, 9, 2, 2, 4, 5, 2, 4, 5}, {0, 6, 7, 6, 7, 8, 6, 2, 7}, {6, 2, 10, 7, 9,
                                                             10, 2, 5, 8},
  {6, 10, 7, 7, 10, 8, 2, 8, 7}, {7, 10, 3, 8, 10, 11, 7, 8, 9}, {0, 7, 8, 12,
                                                                  12, 13, 10,
                                                                  11, 12},
  {7, 3, 11, 14, 14, 15, 11, 13, 14}, {7, 11, 8, 16, 15, 13, 11, 14, 12},
  {8, 11, 4, 13, 15, 17, 12, 14, 15}, {0, 8, 5, 18, 19, 20, 16, 12, 1}, {8, 4,
                                                                         12,
                                                                         19,
                                                                         21,
                                                                         22,
                                                                         12,
                                                                         15,
                                                                         17},
  {8, 12, 5, 19, 22, 20, 12, 17, 1}, {5, 12, 1, 20, 22, 23, 1, 17, 3}, {9, 1,
                                                                        13,
                                                                        24,
                                                                        24,
                                                                        24, 4,
                                                                        3,
                                                                        18},
  {2, 9, 13, 24, 24, 24, 5, 4, 19}, {10, 2, 13, 24, 24, 24, 8, 5, 20}, {3, 10,
                                                                        13,
                                                                        24,
                                                                        24,
                                                                        24, 9,
                                                                        8,
                                                                        21},
  {11, 3, 13, 24, 24, 24, 14, 13, 22}, {4, 11, 13, 24, 24, 24, 15, 14, 23},
  {12, 4, 13, 24, 24, 24, 17, 15, 24}, {1, 12, 13, 24, 24, 24, 3, 17, 25}
};

static GLfloat DS_vertices[14][3] = {
  {0.0f, -1.09141e-08f, 0.0875f}, {0.175f, -1.09141e-08f, -0.0875f}, {0.0f,
                                                                      0.175f,
                                                                      -0.0875f},
  {-0.175f, -1.09141e-08f, -0.0875f}, {0.0f, -0.175f, -0.0875f}, {0.123744f,
                                                                  -1.09141e-08f,
                                                                  0.0362437f},
  {0.0f, 0.123744f, 0.0362437f}, {-0.123744f, -1.09141e-08f, 0.0362437f},
    {0.0f, -0.123744f, 0.0362437f},
  {0.123744f, 0.123744f, -0.0875f}, {-0.123744f, 0.123744f, -0.0875f},
    {-0.123744f, -0.123744f, -0.0875f},
  {0.123744f, -0.123744f, -0.0875f}, {0.0f, -1.09141e-08f, -0.0875f}
};

/*static GLfloat DS_vertices [14][3] = {
{0.0f,-1.24733e-08f,0.1f},{0.2f,-1.24733e-08f,-0.1f},{0.0f,0.2f,-0.1f},
{-0.2f,-1.24733e-08f,-0.1f},{0.0f,-0.2f,-0.1f},{0.141421f,-1.24733e-08f,0.0414214f},
{0.0f,0.141421f,0.0414214f},{-0.141421f,-1.24733e-08f,0.0414214f},{0.0f,-0.141421f,0.0414214f},
{0.141421f,0.141421f,-0.1f},{-0.141421f,0.141421f,-0.1f},{-0.141421f,-0.141421f,-0.1f},
{0.141421f,-0.141421f,-0.1f},{0.0f,-1.24733e-08f,-0.1f}
};*/

static GLfloat DS_normals[25][3] = {
  {0.357407f, 0.357407f, 0.862856f}, {0.630353f, 0.453112f, 0.630353f},
    {0.453112f, 0.630353f, 0.630353f},
  {0.862856f, 0.357407f, 0.357407f}, {0.630353f, 0.630353f, 0.453112f},
    {0.357407f, 0.862856f, 0.357407f},
  {-0.357407f, 0.357407f, 0.862856f}, {-0.453112f, 0.630353f, 0.630353f},
    {-0.630353f, 0.453112f, 0.630353f},
  {-0.357407f, 0.862856f, 0.357407f}, {-0.630353f, 0.630353f, 0.453112f},
    {-0.862856f, 0.357407f, 0.357407f},
  {-0.357407f, -0.357407f, 0.862856f}, {-0.453112f, -0.630353f, 0.630353f},
    {-0.862856f, -0.357407f, 0.357407f},
  {-0.630353f, -0.630353f, 0.453112f}, {-0.57735f, -0.57735f, 0.57735f},
    {-0.357407f, -0.862856f, 0.357407f},
  {0.357407f, -0.357407f, 0.862856f}, {0.453112f, -0.630353f, 0.630353f},
    {0.630353f, -0.453112f, 0.630353f},
  {0.357407f, -0.862856f, 0.357407f}, {0.630353f, -0.630353f, 0.453112f},
    {0.862856f, -0.357407f, 0.357407f},
  {0.0f, 0.0f, -1.0f}
};
static GLfloat DS_textures[26][2] = {
  {0.625f, 1.0f}, {0.5f, 0.75f}, {0.75f, 0.75f},
  {0.5f, 0.5f}, {0.625f, 0.5f}, {0.75f, 0.5f},
  {0.875f, 1.0f}, {1.0f, 0.75f}, {0.875f, 0.5f},
  {1.0f, 0.5f}, {0.125f, 1.0f}, {0.0f, 0.75f},
  {0.25f, 0.75f}, {0.0f, 0.5f}, {0.125f, 0.5f},
  {0.25f, 0.5f}, {0.375f, 1.0f}, {0.375f, 0.5f},
  {0.5625f, 0.5f}, {0.6875f, 0.5f}, {0.8125f, 0.5f},
  {0.9375f, 0.5f}, {0.0625f, 0.5f}, {0.1875f, 0.5f},
  {0.3125f, 0.5f}, {0.4375f, 0.5f}
};

GLint genListeDemiSphere()
{
  unsigned int i;
  int j;

  GLint lid = 0;

  lid = glGenLists(1);

  glNewList(lid, GL_COMPILE);

  glBegin(GL_TRIANGLES);
  for (i = 0; i < sizeof(DS_face_indicies) / sizeof(DS_face_indicies[0]); i++)
  {

    for (j = 0; j < 3; j++)
    {
      int vi = DS_face_indicies[i][j];
      int ni = DS_face_indicies[i][j + 3]; // Normal index
      int ti = DS_face_indicies[i][j + 6]; // Texture index

      glNormal3f(DS_normals[ni][0], DS_normals[ni][1], DS_normals[ni][2]);
      glTexCoord2f(DS_textures[ti][0], DS_textures[ti][1]);
      glVertex3f(DS_vertices[vi][0], DS_vertices[vi][1], DS_vertices[vi][2]);
    }
  }
  glEnd();

  glEndList();
  return lid;
};
