/*
                           Manual Page File IO
 */

#ifndef MPFIO_H
#define MPFIO_H


/*
 *	Header:
 */
typedef struct {

	/* All loaded data format is in plain text */

	char		*title;

	/* Misc data */
	char		**line;
	int		total_lines;

} mp_header_struct;
#define MP_HEADER(p)		((mp_header_struct *)(p))


/*
 *	Section:
 */
typedef struct {

	/* All loaded data format is in plain text */
	char		*section;

	/* Contents */
	char		**line;
	int		total_lines;

} mp_section_struct;
#define MP_SECTION(p)		((mp_section_struct *)(p))


extern int MPLoad(
        const char *filename, const char *data,
        mp_header_struct **mp_header_rtn,
        mp_section_struct ***mp_section_rtn, int *mp_total_sections_rtn,
        void *client_data, int (*progress_cb)(long, long, void *)
);
extern int MPSave(
        const char *filename, char **data_rtn,
        mp_header_struct *mp_header,
        mp_section_struct **mp_section, int mp_total_sections,
        void *client_data, int (*progress_cb)(long, long, void *)   
);

extern void MPDeleteHeader(mp_header_struct *mp_header);
extern void MPDeleteAllSections(
	mp_section_struct **mp_section,
	int mp_total_sections
);


#endif	/* MPFIO_H */
