/*
                                Prompt Dialog
 */

#ifndef PDIALOG_H
#define PDIALOG_H

#include <sys/types.h>

#include <gtk/gtk.h>

#ifndef gbool
# define gbool	guchar
#endif


/*
 *	Response codes:
 */
#define PDIALOG_RESPONSE_NOT_AVAILABLE	-1
#define PDIALOG_RESPONSE_CANCEL		0
#define PDIALOG_RESPONSE_SUBMIT 	1
#define PDIALOG_RESPONSE_HELP		2


/*
  *	Prompt icon codes, specifies the icon displayed next to
 *	the prompts:
 */
#define PDIALOG_ICON_INFO	0
#define PDIALOG_ICON_WARNING    1
#define PDIALOG_ICON_ERROR	2
#define PDIALOG_ICON_QUESTION	3


/*
 *	Button display flags:
 */
#define PDIALOG_BTNFLAG_SUBMIT	(1 << 1)
#define PDIALOG_BTNFLAG_CANCEL	(1 << 2)
#define PDIALOG_BTNFLAG_HELP	(1 << 3)


extern gint PDialogInit(void);

extern gbool PDialogIsQuery(void);
extern void PDialogBreakQuery(void);

extern void PDialogAddPrompt(
	const u_int8_t **icon_data,	/* Can be NULL. */
        const gchar *label,		/* Can be NULL. */
        const gchar *value		/* Can be NULL. */
);
extern void PDialogAddPromptWithBrowse(
	const u_int8_t **icon_data,	/* Can be NULL. */
	const gchar *label,		/* Can be NULL. */
	const gchar *value,		/* Can be NULL. */
	gpointer client_data,		/* Can be NULL. */
	gchar *(*browse_cb)(gpointer, gpointer, gint)	/* Can be NULL. */
);
extern void PDialogSetPromptValue(
	gint prompt_num,
	const u_int8_t **icon_data,
	const gchar *label,
	const gchar *value
);
extern gchar *PDialogGetPromptValue(gint prompt_num);
extern void PDialogDeleteAllPrompts(void);

extern gchar **PDialogGetResponse(
	const gchar *title,
	const gchar *message,
	const gchar *explaination,
	gint icon_code,
	const gchar *submit_label,
	const gchar *cancel_label,
	guint show_buttons,	/* Any of PDIALOG_BTNFLAG_*. */
	guint default_button,	/* One of PDIALOG_BTNFLAG_*. */
	gint *nvalues
);

extern void PDialogSetSize(gint width, gint height);

extern void PDialogMap(void);
extern void PDialogUnmap(void);

extern void PDialogShutdown(void);


#endif	/* PDIALOG_H */
