/*
            Manual Page Editor: Editor Find In Pages Dialog

	Dialog for searching for a given string through all loaded
	pages on its associated editor.
 */

#ifndef EDITORFIP_H
#define EDITORFIP_H

#include <sys/types.h>
#include <gtk/gtk.h>

#ifndef gbool
# define gbool	guchar
#endif


/*
 *	Item data structure for results_clist:
 */
typedef struct {

	void *editor_fip_ptr;	/* Pointer back to Find In Pages dialog. */
	GtkCList *clist;	/* Pointer back to clist of this item. */

	/* Pointer to the matched branch node on the layout_ctree on
	 * editor that was searched through.
	 */
	GtkCTreeNode *found_branch;

	/* This will be used for matching branch data on the editor
	 * when the user wants to `go to' the matched result. This is
	 * better since the found_branch may get deleted and matching
	 * by the branch's data seems to work out better.
	 */
	void *branch_data;

	/* Matched text position (usually for GtkEntry or
	 * GtkEditable/GtkText widgets. Can be -1 to indicate neither.
	 */
	int text_sel_start, text_sel_end;

	/* Matched line number (not very useful), can be -1 for n/a. */
	int line_num;

} editor_fip_item_struct;

/*
 *	Find In Pages dialog structure:
 */
typedef struct {

	gbool initialized;
	gbool map_state;
	gbool processing;

	void *core_ptr;
	void *editor_ptr;

	GtkWidget *toplevel;
	GtkWidget *main_vbox;

	GtkWidget *find_combo;

	/* Buttons on right column. */
	GtkWidget	*find_btn,
			*clear_btn,
			*stop_btn,
			*close_btn;

	int stop_find_count;

	/* Search options. */
	GtkWidget	*match_all_radio,
			*match_any_radio,
			*match_phrase_radio;
	GtkWidget *case_sensitive_toggle;	/* Case sensitive if togged. */

	/* Search results put into this clist, it has 4 columns which
	 * are for; excerpt, type, name (header or section's name), and
	 * manual page name.
	 */
	GtkWidget *results_clist;
	int selected_result;			/* Can be -1. */
	GtkWidget *results_menu;

	/* Important menu items on results menu. */
	GtkWidget	*goto_mi;

	/* Goto selected result button. */
	GtkWidget *goto_btn;

	GtkWidget	*status_bar_dock,
			*status_bar_toplevel,
			*status_bar_progress,
			*status_bar_label;

	gfloat status_bar_progress_pos_last;

} editor_fip_struct;


extern int EditorFIPAddItem(
        editor_fip_struct *fip,
        const char *excerpt,
	int line_num,
        const char *name,
        const char *manual_page,
        GtkCTreeNode *found_branch,
	void *branch_data,
        int text_sel_start, int text_sel_end
);
extern void EditorFIPItemDelete(editor_fip_item_struct *item_ptr);

extern void EditorFIPSetBusy(editor_fip_struct *fip);
extern void EditorFIPSetReady(editor_fip_struct *fip);

extern editor_fip_struct *EditorFIPNew(void *core_ptr, void *editor_ptr);
extern void EditorFIPUpdateMenus(editor_fip_struct *fip);
extern void EditorFIPSetStatusMessage(
	editor_fip_struct *fip, const char *mesg
);
extern void EditorFIPSetStatusProgress(
	editor_fip_struct *fip, gfloat percent
);
extern void EditorFIPReset(editor_fip_struct *fip, gbool need_unmap);
extern void EditorFIPMap(editor_fip_struct *fip);
extern void EditorFIPUnmap(editor_fip_struct *fip);
extern void EditorFIPDelete(editor_fip_struct *fip);






#endif	/* EDITORFIP_H */
