/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file SampleContourMethodAttributes.h
    \brief Definition of SampleContourMethod Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Mon Mar  5 17:12:43 2012
*/
   

#ifndef SampleContourMethodAttributes_H
#define SampleContourMethodAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"



namespace magics {

class XmlNode;



class SampleContourMethodAttributes 
{
public:
//  --  constructor
    SampleContourMethodAttributes();
    
//  --  destructor
    virtual ~SampleContourMethodAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const SampleContourMethodAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief X sampling interval used in 'sample' method (takes every nth point)
    \param x Setting contour_sample_x_interval - default=2
*/
	void setX(int x) 
		{ x_ =  x; } 
	int getX() const 
		{ return x_; } 
        
/*!
    Magics Information:
    \brief Y sampling interval used in 'sample' method (takes every nth point)
    \param y Setting contour_sample_y_interval - default=2
*/
	void setY(int y) 
		{ y_ =  y; } 
	int getY() const 
		{ return y_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	int x_;
	int y_;

private:
  
	friend ostream& operator<<(ostream& s,const SampleContourMethodAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
