/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file PolyShadingTechnique.h
    \brief Definition of the Template class PolyShadingTechnique.
    
    Magics Team - ECMWF 2004
    
    Started: Wed 18-Aug-2004
    
    Changes:
    
*/

#ifndef PolyShadingTechnique_H
#define PolyShadingTechnique_H

#include "magics.h"

#include "ShadingTechnique.h"
#include "PolyShadingTechniqueAttributes.h"
#include "ColourTechnique.h"
#include "DotPolyShadingMethod.h"
#include "HatchPolyShadingMethod.h"



namespace magics {
    
class LevelSelection;

template <class P>
class PolyShadingTechnique: public ShadingTechnique<P>, public PolyShadingTechniqueAttributes<P> {

public:
	PolyShadingTechnique() { }
	virtual ~PolyShadingTechnique() {}
    
    void set(const map<string, string>& map) { PolyShadingTechniqueAttributes<P>::set(map); }
    void set(const XmlNode& node) { PolyShadingTechniqueAttributes<P>::set(node); }
    bool accept(const string& node) { return PolyShadingTechniqueAttributes<P>::accept(node); }
   
    virtual ShadingTechnique<P>* clone() const { return new PolyShadingTechnique<P>(); }
    
    bool shadingMode() { return true; }

    void operator()(Polyline* poly, const ColourTechnique& technique) const {
    	 (*this->method_)(*poly, poly->front().value(), technique);
    }
/*
==== YOURS //cgs_metview/mv4_dev/src/visualisers/PolyShadingTechnique.h
    virtual void operator()(MatrixHandler<P>&, BasicGraphicsObjectContainer&) {}
<<<<
*/
    
    virtual void visit(LegendVisitor& legend, const ColourTechnique& colour) { 
        (*this->method_).visit(legend, colour); 
    }   
    
 
    virtual bool prepare(const LevelSelection& levels, const ColourTechnique&) {  
        (*this->method_).prepare(levels);
        // True if the shading technique needs the isolines to be calculated... 
        return true; 
    }   

protected:
     //! Method to print string about this class on to a stream of type ostream (virtual).
	 virtual void print(ostream&) const {}
     
     
private:
    //! Copy constructor - No copy allowed
	PolyShadingTechnique(const PolyShadingTechnique<P>&);
    //! Overloaded << operator to copy - No copy allowed
	PolyShadingTechnique& operator=(const PolyShadingTechnique<P>&);

// -- Friends
    //! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const PolyShadingTechnique<P>& p)
		{ p.print(s); return s; }

};
static SimpleObjectMaker<PolyShadingMethod<GeoPoint> > fill_area_shading("area_fill");
static SimpleObjectMaker<DotPolyShadingMethod<GeoPoint>, PolyShadingMethod<GeoPoint> > dot_area_shading("dot");
static SimpleObjectMaker<HatchPolyShadingMethod<GeoPoint>, PolyShadingMethod<GeoPoint> > hash_area_shading("hatch");

} // namespace magics



#endif
