/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file Axis.cc
    \brief Implementation of the Template class Axis.
    
    Magics Team - ECMWF 2004
    
    Started: Fri 7-May-2004
    
    Changes:
    
*/

#include "Axis.h"
#include "MagLog.h"
#include "Factory.h"
#include "Layout.h"

#include "Polyline.h"
#include "Text.h"
#include "Layer.h"
#include "SceneVisitor.h"

using namespace magics;

Axis::Axis() 
{
}

Axis::~Axis() 
{
}

/*!
 Class information are given to the output-stream.
*/		
void Axis::print(ostream& out)  const
{
	out << "Axis[";
	AxisAttributes::print(out);
	out << "]";
}

VerticalAxis::VerticalAxis()
{
	if ( !magCompare(position_, "left") && !magCompare(position_, "right"))
			position_ = "left";
}

HorizontalAxis::HorizontalAxis()
{
	if ( !magCompare(position_, "bottom") && !magCompare(position_, "top"))
		position_ = "bottom";
}



void Axis::ticks(double min, double max, vector<double>& ticks)
{
        const double step = (max - min)/10.;
        const double log = log10(step);
        const double istep = pow(10., int(log));	
        const double inc = ceil(step/istep)*istep;
        double first = floor(min/inc)*inc;

        if (first > min) first -= inc;
                
        for (double val = first; val <= max; val += inc) {
            ticks.push_back(val);                
        }
        ticks.push_back(ticks.back() + inc);
}

void Axis::visit(SceneLayer& layer, vector<LayoutVisitor*>& visitors)
{
   	// First we create the layer!
   	// and push It to the parent layer! 
   	StaticLayer* axis = new NoDataLayer(this);
   	axis->id(iconName_);	
   	axis->name(iconName_);
   	layer.add(axis);
   	
   	for  (vector<LayoutVisitor*>::iterator visitor = visitors.begin(); visitor != visitors.end(); ++visitor) {
   		axis->set(*visitor);
   		(*visitor)->visit(*this);
   	}
}
