/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file MatrixTestDecoder.h
    \brief Implementation of the Template class MatrixTestDecoder.
    
    Magics Team - ECMWF 2004
    
    Started: Thu 25-Mar-2004
    
    Changes:
    
*/



#include "MatrixTestDecoder.h"
#include "Factory.h"
#include <limits>

using namespace magics;

MatrixTestDecoder::MatrixTestDecoder()
{
	
	ifstream f("/home/graphics/cgs/public/map.txt");
	assert(f);
	int rows, columns;
	double lon, lat, inclon, inclat;
	f >> rows >> columns;
	f >> lat >> lon >> inclat >> inclon;
	matrix_.set(rows, columns);
	double missing = -std::numeric_limits<double>::max();
     
	matrix_.missing(missing);
	
	char c;
    while (! f.eof() )
    {
      f.get(c);      
   
      if (isdigit(c) )   
      	matrix_.push_back(atoi(&c));
      if (c == '.') 
      	matrix_.push_back(missing);
         
    }
    f.close();
    
    
  
	
	
    for (int i = 0; i < columns; i++) {
           matrix_.columnsAxis().push_back(lon);
           lon+=inclon;
    }
    
    for (int i = 0; i < rows; i++) {
    	matrix_.rowsAxis().push_back(lat);
    	lat+=inclat;
    }

   
    matrix_.setMapsAxis();

    
   
}



MatrixTestDecoder::~MatrixTestDecoder() 
{
}

/*!
 Class information are given to the output-stream.
*/		
void MatrixTestDecoder::print(ostream& out)  const
{
	out << "MatrixTestDecoder[";
	
	out << "]";
}


