/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file MapGenDecoder.cc
    \brief Implementation of the Template class MapGenDecoder.
    
    Magics Team - ECMWF 2005
    
    Started: Mon 12-Dec-2005
    
    Changes:
    
*/



#include "MapGenDecoder.h"
#include "CustomisedPoint.h"

using namespace magics;

template <class P>
MapGenDecoder<P>::MapGenDecoder() 
{
}

template <class P>
MapGenDecoder<P>::~MapGenDecoder() 
{
}

/*!
 Class information are given to the output-stream.
*/	
template <class P>	
void MapGenDecoder<P>::print(ostream& out)  const
{
	out << "MapGenDecoder[";
	out << "]";
}

template <class P>
void MapGenDecoder<P>::decode() 
{
	if ( !this->empty() ) return;
	try {
		char line[1024];
		ifstream in(path_.c_str());
		float lat, lon;
		int i = 0;
		while ( in.good() )
		{
			in.getline(line, 1024);
            
            string test(line);
            
			if ( test.empty() ) 
                continue;
			if ( strncmp(line,"# -b", 4) == 0 ) 
			   push_back(new PointsList<P>());
			else {
				sscanf(line, "%f %f", &lon, &lat);
				
				this->back()->push_back(P(lon, lat, i++));	
                
			}						
		}
	
		in.close();
	}
	catch (...)
	{
		Log::error() << "MapGen file : can not open " << path_ << endl;
	}
	Log::dev() << "Map gen file--->" << this->size() << endl; 
}

template <class P>
void MapGenDecoder<P>::customisedPoints(const std::set<string>&, magics::CustomisedPointsList& out)
{
	PointsHandler<P>& list = points();
	
	list.setToFirst();
	int i = 0;
     while (list.more()) {        
          P point = list.current();
          CustomisedPoint* cpoint = new CustomisedPoint();
		    	(*cpoint)["x"] = point.x();
		    	(*cpoint)["y"] = point.y();
		    	(*cpoint)["value"] = i++;
		    	(*cpoint)["x_lower"] = 0;
		    	(*cpoint)["y_lower"] = 0;
		    	(*cpoint)["x_upper"] = point.x();
		    	(*cpoint)["y_upper"] = point.y();
		    	out.push_back(cpoint);
          list.advance();
      
    }  	
		
}
