/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file InputMatrix.h
    \brief Implementation of the Template class InputMatrix.
    
    Magics Team - ECMWF 2005
    
    Started: Fri 16-Sep-2005
    
    Changes:
    
*/




using namespace magics;

template <class P>
InputMatrix<P>::InputMatrix()
{
	filter(field_);
	filter(u_component_);
	filter(v_component_);
	filter(wind_speed_);
	filter(wind_direction_);
	if ( !field_.empty()) 
		(*organization_).interpret(field_, *this); 
	if ( !u_component_.empty()) 
		(*organization_).interpret(u_component_, *this); 
	if ( !v_component_.empty()) 
		(*organization_).interpret(v_component_, *this);	
	if ( !wind_speed_.empty()) 
		(*organization_).interpret(wind_speed_, *this);	
	if ( !wind_direction_.empty()) 
			(*organization_).interpret(wind_direction_, *this);	
}


template <class P>
InputMatrix<P>::~InputMatrix() 
{
	
}

/*!
 Class information are given to the output-stream.
*/		
template <class P>
void InputMatrix<P>::print(ostream& out)  const
{
	out << "InputMatrix[";
	out << field_;
	out << "]";
}
template <class P>
MatrixHandler<P>& InputMatrix<P>::matrix() 
{
	if (simple_field_) 
		(*organization_).interpret(field_, *this); 
	this->matrixHandlers_.push_back(new MatrixHandler<P>(field_));         
	return *(this->matrixHandlers_.back()); 
}


template <class P>
void InputMatrix<P>::filter(Matrix& data)
{
	for ( unsigned int i = 0; i < data.size(); i++ )
		if ( data[i] <= suppress_below_ || data[i] >= suppress_above_ ) 
			data[i] = data.missing();
}
template <class P>
MatrixHandler<P>& InputMatrix<P>::xComponent() 
{
	if ( u_component_.empty() ) {
		// We calculate the u_component_ using the speed and direction...
		u_component_ = wind_speed_;
		vector<double>::const_iterator speed = wind_speed_.begin();
		vector<double>::const_iterator angle = wind_direction_.begin();
		u_component_.clear();
	
		while ( speed != wind_speed_.end() && angle != wind_direction_.end() ) {
			if ( *speed == wind_speed_.missing() || *angle == wind_direction_.missing() ) 
					  u_component_.push_back(wind_direction_.missing());
		    else {
				       	double a = 90 - (*angle); 
				       	u_component_.push_back(*speed * -cos(a/180*3.14));
				       }
		     speed++;
			 angle++;
		}	
	}
	this->matrixHandlers_.push_back(new MatrixHandler<P>(u_component_));         
	return *(this->matrixHandlers_.back()); 
}
template <class P>
MatrixHandler<P>& InputMatrix<P>::yComponent()
{
	if ( v_component_.empty() ) {
		// We calculate the u_component_ using the speed and direction...
		v_component_ = wind_direction_;
		vector<double>::const_iterator speed = wind_speed_.begin();
		vector<double>::const_iterator angle = wind_direction_.begin();
		v_component_.clear();		
		while ( speed != wind_speed_.end() && angle != wind_direction_.end() ) {
			   if ( *speed == wind_speed_.missing() || *angle == wind_direction_.missing() ) 
				   v_component_.push_back(wind_direction_.missing());			   
		       else {
		       	 double a = 90 - (*angle); 
		       	 v_component_.push_back(*speed * -sin(a/180*3.14));
		       }
		      
		       speed++;
		       angle++;
			}	
	}
	Data<P>::matrixHandlers_.push_back(new MatrixHandler<P>(v_component_));         
	return *(this->matrixHandlers_.back()); 
}

