/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file CustomisedPoint.h
    \brief Definition of the Template class CustomisedPoint.
    
    Magics Team - ECMWF 2005
    
    Started: Thu 19-May-2005
    
    Changes:
    
*/

#ifndef CustomisedPoint_H
#define CustomisedPoint_H

#include "magics.h"
#include "VectorOfPointers.h"

namespace magics {

class CustomisedPoint : public map<string, double> {

public:
	CustomisedPoint() {}
	CustomisedPoint(double lon, double lat, string ident) :
		latitude_(lat), longitude_(lon), identifier_(ident) {}
	virtual ~CustomisedPoint() {}
	
	double latitude() const { return latitude_; }
	void latitude(double latitude) { latitude_ = latitude; }
	
	double longitude() const { return longitude_; }
	void longitude(double longitude) { longitude_ = longitude; }
	
	string identifier() const { return identifier_; }
	void identifier(string identifier) { identifier_ = identifier; }

protected:
     //! Method to print string about this class on to a stream of type ostream (virtual).
	 virtual void print(ostream& out) const
	 { 
	 	out << "CustomisedPoint[";
	 	out << "latitude=" << latitude_;
	 	out << ", longitude=" << longitude_;
	 	out << ", identifier=" << identifier_;
	 	for ( const_iterator value = begin(); value != end(); ++ value) 
	 		out << ", " << value->first << "=" << value->second;
	 	out << "]";
	 }  
	 double latitude_;
	 double longitude_;
	 string   identifier_;

private:
    //! Copy constructor - No copy allowed
	CustomisedPoint(const CustomisedPoint&);
    //! Overloaded << operator to copy - No copy allowed
	CustomisedPoint& operator=(const CustomisedPoint&);

// -- Friends
    //! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const CustomisedPoint& p)
		{ p.print(s); return s; }

};


typedef  VectorOfPointers< vector<CustomisedPoint*> > CustomisedPointsList;  

} // namespace magics
#endif
