/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file VisualAction.h
    \brief Implementation of the Template class ActionNode.
    
    Magics Team - ECMWF 2007
    
    Started: Tue 6-Mar-2007
    
    Changes:
    
*/ 


#include "LegendVisitor.h"
#include "Timer.h"
#include "TextVisitor.h"
#include "SceneVisitor.h"
#include "AnimationRules.h"
#include "Layer.h"

using namespace magics;

template <class P>
VisualAction<P>::VisualAction() : data_(0)
{
}

template <class P>
VisualAction<P>::~VisualAction() 
{
	if (data_) delete data_;
	
}

/*!
 Class information are given to the output-stream.
*/	
template <class P>	
void VisualAction<P>::print(ostream& out)  const
{
	out << "ActionNode<P>";
}

template <class P>	
void VisualAction<P>::getReady()
{
	Log::dev() << "ActionNode<P>::getReady()\n";
	
}

template <class P>	
void VisualAction<P>::visit(DrawingVisitor& drawing)
{


	if ( !data_ || visdefs_.empty() ) {
		Log::warning() << " No proper action  defined " << endl;
		return;
	}
	data_->getReady(drawing.transformation());
	
	for ( typename vector<Visdef<P>* >::iterator visdef = visdefs_.begin(); visdef != visdefs_.end(); ++visdef) {
		Timer timer("plotting", "time spent in plotting");
		
		Layer* layer = LayerManager::layer(data_->layerId()); 
		data_->visit(*layer);
		
		drawing.push_back(layer);
		(*visdef)->visit(*layer);
		(**visdef)(*data_, *layer); // Now the visualObject ahs the responsability to reproject!
		
	}
	
}

template <class P>	
void VisualAction<P>::visit(MetaDataVisitor& meta)
{
	
	if ( data_ ) data_->visit(meta);
	for ( typename vector<Visdef<P>* >::iterator visdef = visdefs_.begin(); visdef != visdefs_.end(); ++visdef)
		(**visdef).visit(meta);
	
	
}

template <class P>	
void VisualAction<P>::visit(MagnifierVisitor& visitor) {
	if ( data_ ) data_->visit(visitor);
}

template <class P>	
void VisualAction<P>::visit(Transformation& transformation)
{
	if ( !data_ || visdefs_.empty() ) {
		Log::warning() << " No proper action  defined " << endl;
		return;
	}
	data_->visit(transformation);	
	for ( typename vector<Visdef<P>* >::iterator visdef = visdefs_.begin(); visdef != visdefs_.end(); ++visdef)
		(**visdef).visit(transformation, *data_);
}
 
 
template <class P>	
void VisualAction<P>::visit(LegendVisitor& legend)
{
	bool needEmpty = false;
	for ( typename vector<Visdef<P>* >::iterator visdef = visdefs_.begin(); visdef != visdefs_.end(); ++visdef) {
		if ( needEmpty ) 
			legend.add(new EmptyEntry() );
		else 
			needEmpty = true;
		(**visdef).visit(legend);
	}
	data_->visit(legend);
		
}

template <class P>	 
void VisualAction<P>::visit(TextVisitor& title)
{
	if ( data_ ) data_->visit(title);
}

template <class P>	 
void VisualAction<P>::visit(AnimationRules& rules)
{
	if ( data_ ) data_->visit(rules);
}

template <class P>	 
void VisualAction<P>::visit(AnimationStep& step)
{
	if ( data_ ) data_->visit(step);
}

template <class P>	
VisualAnimation<P>::VisualAnimation():loop_(0)
{
	
}
template <class P>	
VisualAnimation<P>::~VisualAnimation()
{
	
}

template <class P>
void VisualAnimation<P>::prepare() 
{
	if ( !this->empty() )
		return;
	
	loop_->setToFirst();
	while ( loop_->hasMore() ) {
			Log::dev() << "New Frame" << endl;
		
			VisualAction<P>* action = new VisualAction<P>();
			action->data(loop_->current());
			for ( typename vector<Visdef<P>* >::iterator visdef = this->visdefs_.begin(); visdef != this->visdefs_.end(); ++visdef) {
		        Timer timer("plotting", "time spent in plotting");
				action->visdef(*visdef);
				
			}
			loop_->next();
			vector<BasicSceneObject*>::push_back(action);
	}

}
template <class P>	
void VisualAnimation<P>::visit(DrawingVisitor& list)
{
	prepare();	
	list.push_back(new StepRenderer());
}
template <class P>	
void VisualAnimation<P>::visit(LegendVisitor& legend)
{
	prepare();
	BasicGraphicsObject* step = new StepRenderer();
	dynamic_cast<BasicGraphicsObjectContainer*>(&legend)->push_back(step);
}
template <class P>	
void VisualAnimation<P>::visit(TextVisitor& text)
{
	prepare();
	BasicGraphicsObject* step = new StepRenderer();
	dynamic_cast<BasicGraphicsObjectContainer*>(&text)->push_back(step);
	
}

template <class P>	
void VisualAnimation<P>::visit(MetaDataVisitor&)
{
	
}

template <class P>	
void VisualAnimation<P>::visit(AnimationRules& rules)
{
	prepare();
	for ( iterator entry = this->begin(); entry != this->end(); ++entry)
		(*entry)->visit(rules);
	rules.add(*this);

}


template <class P>	
void VisualAnimation<P>::visit(Transformation&)
{
	
}
