/* libwpg
 * Copyright (C) 2006 Ariya Hidayat (ariya@kde.org)
 * Copyright (C) 2004 Marc Oude Kotte (marc@solcon.nl)
 * Copyright (C) 2005 Fridrich Strba (fridrich.strba@bluewin.ch)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the 
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, 
 * Boston, MA  02111-1301 USA
 *
 * For further information visit http://libwpg.sourceforge.net
 */

/* "This product is not manufactured, approved, or supported by
 * Corel Corporation or Corel Corporation Limited."
 */

#ifndef __WPGXPARSER_H__
#define __WPGXPARSER_H__

#include "WPGPaintInterface.h"
#include <libwpd-stream/WPXStream.h>
#include <libwpd/libwpd.h>
#include "WPGColor.h"

#include <map>

class WPGXParser
{
public:
	WPGXParser(WPXInputStream *input, libwpg::WPGPaintInterface* painter);
	WPGXParser(const WPGXParser& parser);
	virtual ~WPGXParser() {};
	virtual bool parse() = 0;
	
	unsigned char readU8();
	unsigned short readU16();  
	unsigned int readU32();  
	short readS16();  
	int readS32();  
	unsigned int readVariableLengthInteger();
	WPGXParser& operator=(const WPGXParser& parser);

protected:
	WPXInputStream* m_input;
	libwpg::WPGPaintInterface* m_painter;
	std::map<int,libwpg::WPGColor> m_colorPalette;
};

class WPGTextDataHandler : public ::WPXDocumentInterface
{
public:
	WPGTextDataHandler(libwpg::WPGPaintInterface* painter) :
		m_painter(painter),
		m_x(0.0),
		m_y(0.0),
		m_width(0.0),
		m_height(0.0),
		m_fontName("Times New Roman"),
		m_fontSize(12.0),
		m_paragraphStyle(),
		m_textStyle() {}
		
	~WPGTextDataHandler() {}
 	void setDocumentMetaData(const WPXPropertyList & /* propList */) {}

 	void startDocument() {}
 	void endDocument() {}

 	void startSubDocument() {}
 	void endSubDocument();

 	void definePageStyle(const WPXPropertyList & /* propList */) {}
 	void openPageSpan(const WPXPropertyList & /* propList */) {}
 	void closePageSpan() {}
 	void openHeader(const WPXPropertyList & /* propList */) {}
 	void closeHeader() {}
 	void openFooter(const WPXPropertyList & /* propList */) {}
 	void closeFooter() {}

 	void defineParagraphStyle(const WPXPropertyList & /* propList */, const WPXPropertyListVector & /* tabStops */) {}
 	void openParagraph(const WPXPropertyList &propList, const WPXPropertyListVector &tabStops);
 	void closeParagraph();

 	void defineCharacterStyle(const WPXPropertyList & /* propList */) {}
 	void openSpan(const WPXPropertyList &propList);
 	void closeSpan();

 	void defineSectionStyle(const WPXPropertyList & /* propList */, const WPXPropertyListVector & /* columns */) {}
 	void openSection(const WPXPropertyList & /* propList */, const WPXPropertyListVector & /* columns */) {}
 	void closeSection() {}

 	void insertTab();
 	void insertSpace();
 	void insertText(const WPXString &text);
 	void insertLineBreak();
	void insertField(const WPXString & /* type */, const WPXPropertyList & /* propList */) {}

 	void defineOrderedListLevel(const WPXPropertyList & /* propList */) {}
 	void defineUnorderedListLevel(const WPXPropertyList & /* propList */) {}
 	void openOrderedListLevel(const WPXPropertyList & /* propList */) {}
 	void openUnorderedListLevel(const WPXPropertyList & /* propList */) {}
 	void closeOrderedListLevel() {}
 	void closeUnorderedListLevel() {}
 	void openListElement(const WPXPropertyList &propList, const WPXPropertyListVector &tabStops);
 	void closeListElement();

 	void openFootnote(const WPXPropertyList & /* propList */) {}
 	void closeFootnote() {}
 	void openEndnote(const WPXPropertyList & /* propList */) {}
 	void closeEndnote() {}
 	void openComment(const WPXPropertyList & /* propList */) {}
 	void closeComment() {}
 	void openTextBox(const WPXPropertyList & /* propList */) {}
 	void closeTextBox() {}

 	void openTable(const WPXPropertyList & /* propList */, const WPXPropertyListVector & /* columns */) {}
 	void openTableRow(const WPXPropertyList & /* propList */) {}
 	void closeTableRow() {}
 	void openTableCell(const WPXPropertyList & /* propList */) {}
 	void closeTableCell() {}
 	void insertCoveredTableCell(const WPXPropertyList & /* propList */) {}
 	void closeTable() {}

 	void openFrame(const WPXPropertyList & /* propList */) {}
 	void closeFrame() {}
	
 	void insertBinaryObject(const WPXPropertyList & /* propList */, const WPXBinaryData & /* data */) {}
 	void insertEquation(const WPXPropertyList & /* propList */, const WPXString & /* data */) {}

private:
	libwpg::WPGPaintInterface *m_painter;
	double m_x, m_y, m_width, m_height;
	::WPXString m_fontName;
	double m_fontSize;
	::WPXPropertyList m_paragraphStyle, m_textStyle;
};


#endif // __WPGXPARSER_H__
