#
# file assertions
#

module RUNIT

  module Assert

    def assert_same_file( from, to )
      setup_assert
      unless File.read(from) == File.read(to) then
        raise_assertion_error "file #{from} != #{to}"
      end
    end

    def assert_file_exist( file )
      setup_assert
      unless File.exist? file then
        raise_assertion_error "file not exist: #{file}"
      end
    end

    def assert_file_not_exist( file )
      setup_assert
      if File.exist? file then
        raise_assertion_error "file not exist: #{file}"
      end
    end

    def assert_is_directory( file )
      setup_assert
      unless File.directory? file then
        raise_assertion_error "is not directory: #{file}"
      end
    end

  end

end
