/************************************************************************************
TerraLib - a library for developing GIS applications.
Copyright  2001-2004 INPE and Tecgraf/PUC-Rio.

This code is part of the TerraLib library.
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

You should have received a copy of the GNU Lesser General Public
License along with this library.

The authors reassure the license terms regarding the warranties.
They specifically disclaim any warranties, including, but not limited to,
the implied warranties of merchantability and fitness for a particular purpose.
The library provided hereunder is on an "as is" basis, and the authors have no
obligation to provide maintenance, support, updates, enhancements, or modifications.
In no event shall INPE and Tecgraf / PUC-Rio be held liable to any party for direct,
indirect, special, incidental, or consequential damages arising out of the use
of this library and its documentation.
*************************************************************************************/

/*! \file TeFragmentation.h
    This file contains Algorithms for Topological Operations.
*/

/**
  *@author Gilberto Ribeiro de Queiroz
  */

#ifndef  __TERRALIB_INTERNAL_FRAGMENTATION_H
#define  __TERRALIB_INTERNAL_FRAGMENTATION_H

#include "TeGeometry.h"
#include "TeIntersector.h"

/** @defgroup FragmentAlgorithms Algorithms that performs fragmentation of lines
 *  TerraLib fragmentation algorithms.
 *  @{
 */
/*! \fn TeLineSet TeFragmentLine(const TeLineSet& redLineSet, const TeLineSet& blueLineSet, TeINTERSECTOR2::TeReportVector& report)
    \brief Fragments the red lines according to blues and report, this rotine tries to join fragments.
	\param redLineSet  The lines to fragment.
	\param blueLineSet The blues one used as reference
	\param report      The intersection points.
*/
void TeFragmentBoundary(const TeLineSet& lines, TeINTERSECTOR2::TeVectorBoundaryIP& ips, TeLineSet& boundaryFragments, TeLineSet& fragments);

/** @} */ // end of group  FragmentAlgorithms

#endif	// __TERRALIB_INTERNAL_FRAGMENTATION_H
