//***********************************************************************
//      TerraLib is a GIS Classes and Functions Library that 
//      strongly explores Spatial Database Technologies 
//
//      Copyright  2002 INPE and Tecgraf/PUC-Rio. 
//
//      This library is free software; you can redistribute it 
//      and/or modify it under the terms of the GNU Lesser General 
//      Public License as published by the Free Software Foundation
//      version 2.1.(http://www.opensource.org/licenses/lgpl-license.php)
//
//      
//
//      Send questions or suggestions about the TerraLib Project 
//      to terralib@dpi.inpe.br .
//**************************************************************************//
/*! \file TePlotTheme.h
    This file contains support to plot a view on a canvas
*/
#ifndef TEPLOTVIEW_H
#define TEPLOTVIEW_H
#include <TeView.h>
#include <TePlotTheme.h>
#include <TeDatabase.h>

template<class Portal, class Canvas>
void TePlotView (Portal *portal, TeView *view, Canvas *canvas)
{
	if (view->themes().size() == 0)
		portal->loadView (*view);

	for (int i=0 ; i < view->themes().size() ; i++)
	{
		TeThemeApplication *theme = (TeTheme*)view->get(i);
		if (theme->visible ())
			TePlotTheme (portal, theme, canvas);
	}
}

#endif

