/* classifier.cc
 */
#include "osl/move_classifier/classifier.h"
#include "osl/move_classifier/safeMove.h"
#include "osl/move_classifier/check_.h"
#include "osl/move_classifier/moveAdaptor.h"

bool osl::move_classifier::
Classifier::isSafeMove(const NumEffectState& state, Move move)
{
    return ConditionAdaptor<SafeMove>::isMember(state, move);
}

bool osl::move_classifier::
Classifier::isCheck(const NumEffectState& state, Move move)
{
    return PlayerMoveAdaptor<Check>::isMember(state, move);
}

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
