/***************************************************************************
  $RCSfile: plugin.h,v $
  -------------------
  cvs         : $Id: plugin.h,v 1.8 2003/05/19 16:09:07 cstim Exp $
  begin       : Mon Apr 14 2003
  copyright   : (C) 2003 by Martin Preuss
  email       : martin@libchipcard.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

/** @file plugin.h Definition of the base class for a plugin. */

#ifndef PLUGIN_H
#define PLUGIN_H

#ifdef __cplusplus
#include <string>
using namespace std;


namespace HBCI {


/**
 * @brief This is the base class for a plugin.
 *
 * @author Martin Preuss<martin@libchipcard.de>
 * @see @ref pluginpage
 */
class Plugin {
public:
  typedef enum {
    PluginTypeUnknown=0,
    PluginTypeMedium
  } PluginType;

  Plugin();
  virtual ~Plugin();

  /** Returns the name of the given plugin. FIXME: It is still not yet
      decided whether this has any relation to the filename of the
      plugin. */
  virtual string name() const =0;
  /** Returns the human-readable description of this plugin. */
  virtual string description() const =0;
  virtual unsigned int vmajor() const =0;
  virtual unsigned int vminor() const =0;
  /**
   * Returns the type of this plugin.
   */
  virtual PluginType pluginType() const=0;
};


};
typedef HBCI::Plugin HBCI_Plugin;
extern "C" {
#else /* __cplusplus */
  typedef struct HBCI_Plugin HBCI_Plugin;
#endif /* __cplusplus */
  /** @name HBCI_Plugin
   *
   * Wrappers for HBCI::Plugin */
  /*@{*/
  /** Returns the name of the given plugin. 
   *
   * Note: The returned string will be owned by the caller and has to
   * be free()'d be the caller when no longer needed! */
  extern char *HBCI_Plugin_name(const HBCI_Plugin *p);

  /** Returns the human-readable description of the given plugin. 
   *
   * Note: The returned string will be owned by the caller and has to
   * be free()'d be the caller when no longer needed! */
  extern char *HBCI_Plugin_description(const HBCI_Plugin *p);

  extern unsigned int HBCI_Plugin_vmajor(const HBCI_Plugin *p);
  extern unsigned int HBCI_Plugin_vminor(const HBCI_Plugin *p);
  /**
   * Returns the type of this plugin.
   */
  extern int HBCI_Plugin_pluginType(const HBCI_Plugin *p);
  /*@}*/

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif

