/*
  hbciinteractorcb.cpp
  (C) 2002 by Christian Stimming <stimming@tuhh.de>

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "interactorcb.h"


namespace HBCI {

InteractorCB::InteractorCB(VoidFuncTyp destrCB,
			   InputPinFuncTyp msgInputPinCB,
			   InputUserFuncTyp msgInsertMediumOrAbortCB,
			   InputUserFuncTyp msgInsertCorrectMediumOrAbortCB,
			   LoggingFuncTyp msgStateResponseCB,
			   BoolFuncTyp keepAliveCB,
			   VoidUserFuncTyp msgStartInputPinViaKeypadCB,
			   VoidUserFuncTyp msgFinishedInputPinViaKeypadCB,
			   void *user_data) :
 _destrCB(destrCB),
 _msgInputPinCB(msgInputPinCB),
 _msgInsertMediumOrAbortCB(msgInsertMediumOrAbortCB),
 _msgInsertCorrectMediumOrAbortCB(msgInsertCorrectMediumOrAbortCB),
 _msgStateResponseCB(msgStateResponseCB),
 _keepAliveCB(keepAliveCB),
 _msgStartInputPinViaKeypadCB(msgStartInputPinViaKeypadCB),
 _msgFinishedInputPinViaKeypadCB(msgFinishedInputPinViaKeypadCB),
 _user_data(user_data)
{
}


InteractorCB::~InteractorCB()
{
    if (_destrCB)
	(*_destrCB)(_user_data);
}


bool InteractorCB::msgInputPin(Pointer<User> user,
                                 string &pin,
                                 int minsize,
                                 bool newPin)
{
    if (_msgInputPinCB)
	{
	    char* newstring = 0l;
	    bool ret = (*_msgInputPinCB)((user.isValid() ? user.ptr() : 0),
					 &newstring,
					 minsize,
					 newPin,
					 _user_data);
	    if (newstring != 0) 
		{
		    pin = newstring;
		    // overwrite the local buffer with zeros
		    memset(newstring, 0, strlen(newstring));
		    free(newstring);
		}
	    return ret;
	} else {
	    return Interactor::msgInputPin(user, pin, minsize, newPin);
	};
}


bool InteractorCB::msgInsertMediumOrAbort(Pointer<User> user,
                                          MediumType t)
{
    if (_msgInsertMediumOrAbortCB)
	{
	    return (*_msgInsertMediumOrAbortCB)(user.isValid() ? 
						user.ptr() : 0,
						t,
						_user_data);
	} else {
	    return Interactor::msgInsertMediumOrAbort(user, t);
	};
}


bool InteractorCB::msgInsertCorrectMediumOrAbort(Pointer<User> user,
                                                 MediumType t)
{
    if (_msgInsertCorrectMediumOrAbortCB)
    {
	return (*_msgInsertCorrectMediumOrAbortCB)(user.isValid() ?
						   user.ptr() : 0,
						   t,
						   _user_data);
    } else {
        return Interactor::msgInsertCorrectMediumOrAbort(user, t);
	};
}


void InteractorCB::msgStateResponse(const string& msg)
{
    if (_msgStateResponseCB)
	{
	    return (*_msgStateResponseCB)(msg.c_str(), _user_data);
	} else {
	    return Interactor::msgStateResponse(msg);
	};
}


bool InteractorCB::keepAlive(){
    if (_keepAliveCB)
	{
	    return _keepAliveCB(_user_data); // syntax also ok but not so obvious
	} else {
	    return Interactor::keepAlive();
	};
}

void InteractorCB::msgStartInputPinViaKeypad(Pointer<User> user){
    if (_msgStartInputPinViaKeypadCB)
	{
	    (*_msgStartInputPinViaKeypadCB)(user.isValid() ? user.ptr() : 0,
					    _user_data);
	} else {
	    Interactor::msgStartInputPinViaKeypad(user);
	};
}


void InteractorCB::msgFinishedInputPinViaKeypad(Pointer<User> user){
    if (_msgFinishedInputPinViaKeypadCB)
	{
	    (*_msgFinishedInputPinViaKeypadCB)(user.isValid() ? user.ptr() : 0,
					       _user_data);
	} else {
	    Interactor::msgFinishedInputPinViaKeypad(user);
	};
}


} // namespace  HBCI

HBCI_InteractorCB* HBCI_InteractorCB_new2(
    VoidFuncTyp destrCB,
    InputPinFuncTyp msgInputPinCB,
    InputUserFuncTyp msgInsertMediumOrAbortCB,
    InputUserFuncTyp msgInsertCorrectMediumOrAbortCB,
    LoggingFuncTyp msgStateResponseCB,
    BoolFuncTyp keepAliveCB,
    VoidUserFuncTyp msgStartInputPinViaKeypadCB, 
    VoidUserFuncTyp msgFinishedInputPinViaKeypadCB,
    void *user_data)
{
    return new HBCI_InteractorCB(destrCB,
				 msgInputPinCB,
				 msgInsertMediumOrAbortCB,
				 msgInsertCorrectMediumOrAbortCB,
				 msgStateResponseCB,
				 keepAliveCB,
				 msgStartInputPinViaKeypadCB,
				 msgFinishedInputPinViaKeypadCB,
				 user_data);
}

HBCI_InteractorCB* HBCI_InteractorCB_new(
    VoidFuncTyp destrCB,
    InputPinFuncTyp msgInputPinCB,
    InputUserFuncTyp msgInsertMediumOrAbortCB,
    InputUserFuncTyp msgInsertCorrectMediumOrAbortCB,
    LoggingFuncTyp msgStateResponseCB,
    BoolFuncTyp keepAliveCB,
    void *user_data)
{
    return new HBCI_InteractorCB(destrCB,
				 msgInputPinCB,
				 msgInsertMediumOrAbortCB,
				 msgInsertCorrectMediumOrAbortCB,
				 msgStateResponseCB,
				 keepAliveCB,
				 NULL,
				 NULL,
				 user_data);
}

HBCI_Interactor* HBCI_InteractorCB_Interactor(HBCI_InteractorCB* h)
{
    return h;
}

