/***************************************************************************
 $RCSfile: bpdjob.cpp,v $
                             -------------------
    cvs         : $Id: bpdjob.cpp,v 1.4 2003/04/25 01:45:54 aquamaniac Exp $
    begin       : Sat Jun 08 2002
    copyright   : (C) 2001 by Martin Preuss
    email       : openhbci@aquamaniac.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef __declspec
# if BUILDING_DLL
#  define DLLIMPORT __declspec (dllexport)
# else /* Not BUILDING_DLL */
#  define DLLIMPORT __declspec (dllimport)
# endif /* Not BUILDING_DLL */
#else
# define DLLIMPORT
#endif

#include "assert.h"
#include <string>
#include "hbcistring.h"
#include "bpdjob.h"


namespace HBCI {


bpdJob::bpdJob()
:_segmentVersion(0)
,_jobsPerMessage(0)
,_minSigCount(0)
{
}


bpdJob::~bpdJob(){
}


string bpdJob::dumpToString() const {
    return
        "Segment:   " + _segmentCode                            + "\n" +
        "Name:      " + String::hbciSegmentName(_segmentCode.c_str())   + "\n" +
        "Version:   " + String::num2string(_segmentVersion) + "\n" +
        "Jobs/Msg:  " + String::num2string(_jobsPerMessage) + "\n" +
        "Min.Sig.:  " + String::num2string(_minSigCount)    + "\n" +
        "Parameter: " + _parameter                              + "\n";
}



} // namespace HBCI


const char*HBCI_bpdJob_segmentCode(const HBCI_bpdJob *j)
{
    assert(j);
    return j->segmentCode().c_str();
}
int HBCI_bpdJob_jobsPerMessage(const HBCI_bpdJob *j)
{
    assert(j);
    return j->jobsPerMessage();
}
int HBCI_bpdJob_segmentVersion(const HBCI_bpdJob *j)
{
    assert(j);
    return j->segmentVersion();
}
const char *HBCI_bpdJob_parameter (const HBCI_bpdJob *j)
{
    assert(j);
    return j->parameter().c_str();
}
