#!/bin/sh

VERSION=$2
TAR=../libgoogle-collections-java_$VERSION.orig.tar.gz
DIR=libgoogle-collections-java-$VERSION

# ugly hack because upstream didn't tag 1.0 release
# and there is not any tarball at project website
if [ "$VERSION" == "1.0" ]; then export REV="129"; fi

svn export -r$REV http://google-collections.googlecode.com/svn/trunk/ $DIR
tar -c -z -f $TAR --exclude '*/javadoc/*' --exclude '*/lib/*' $DIR
rm -rf $DIR

# New version, uses the zip file downloaded from the project site. 
# To use for version 1.x onwards

#TAG=$(echo "$VERSION" | sed 's,~\(alpha\|beta\),-\1-,' | sed 's/~rc/-rc/')
#
#wget http://google-collections.googlecode.com/files/google-collect-$TAG.zip google-collect-$TAG.zip
#unzip google-collect-$TAG.zip -d tmp
#mkdir -p $DIR
#mv tmp/google-collect-$TAG/javadoc $DIR
#mkdir -p $DIR/src/main/java
#unzip tmp/google-collect-$TAG/src-$TAG.zip -d $DIR/src/main/java
#mkdir -p $DIR/src/main/resources/
#mv $DIR/src/main/java/META-INF $DIR/src/main/resources/  
#rm -rf *.zip
#rm -rf tmp
#tar -c -z -f $TAR $DIR/
#rm -rf $DIR

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $TAR $origDir
  echo "moved $TAR to $origDir"
fi
