/* treeset.c generated by valac, the Vala compiler
 * generated from treeset.vala, do not modify */

/* treeset.vala
 *
 * Copyright (C) 2009  Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Maciej Piechotka <uzytkownik2@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>


#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_ABSTRACT_COLLECTION (gee_abstract_collection_get_type ())
#define GEE_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection))
#define GEE_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))
#define GEE_IS_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_IS_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_ABSTRACT_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))

typedef struct _GeeAbstractCollection GeeAbstractCollection;
typedef struct _GeeAbstractCollectionClass GeeAbstractCollectionClass;
typedef struct _GeeAbstractCollectionPrivate GeeAbstractCollectionPrivate;

#define GEE_TYPE_SET (gee_set_get_type ())
#define GEE_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_SET, GeeSet))
#define GEE_IS_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_SET))
#define GEE_SET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_SET, GeeSetIface))

typedef struct _GeeSet GeeSet;
typedef struct _GeeSetIface GeeSetIface;

#define GEE_TYPE_ABSTRACT_SET (gee_abstract_set_get_type ())
#define GEE_ABSTRACT_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_SET, GeeAbstractSet))
#define GEE_ABSTRACT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_SET, GeeAbstractSetClass))
#define GEE_IS_ABSTRACT_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_SET))
#define GEE_IS_ABSTRACT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_SET))
#define GEE_ABSTRACT_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_SET, GeeAbstractSetClass))

typedef struct _GeeAbstractSet GeeAbstractSet;
typedef struct _GeeAbstractSetClass GeeAbstractSetClass;
typedef struct _GeeAbstractSetPrivate GeeAbstractSetPrivate;

#define GEE_TYPE_SORTED_SET (gee_sorted_set_get_type ())
#define GEE_SORTED_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_SORTED_SET, GeeSortedSet))
#define GEE_IS_SORTED_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_SORTED_SET))
#define GEE_SORTED_SET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_SORTED_SET, GeeSortedSetIface))

typedef struct _GeeSortedSet GeeSortedSet;
typedef struct _GeeSortedSetIface GeeSortedSetIface;

#define GEE_TYPE_BIDIR_ITERATOR (gee_bidir_iterator_get_type ())
#define GEE_BIDIR_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_BIDIR_ITERATOR, GeeBidirIterator))
#define GEE_IS_BIDIR_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_BIDIR_ITERATOR))
#define GEE_BIDIR_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_BIDIR_ITERATOR, GeeBidirIteratorIface))

typedef struct _GeeBidirIterator GeeBidirIterator;
typedef struct _GeeBidirIteratorIface GeeBidirIteratorIface;

#define GEE_TYPE_TREE_SET (gee_tree_set_get_type ())
#define GEE_TREE_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TREE_SET, GeeTreeSet))
#define GEE_TREE_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_TREE_SET, GeeTreeSetClass))
#define GEE_IS_TREE_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TREE_SET))
#define GEE_IS_TREE_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_TREE_SET))
#define GEE_TREE_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_TREE_SET, GeeTreeSetClass))

typedef struct _GeeTreeSet GeeTreeSet;
typedef struct _GeeTreeSetClass GeeTreeSetClass;
typedef struct _GeeTreeSetPrivate GeeTreeSetPrivate;
typedef struct _GeeTreeSetNode GeeTreeSetNode;

#define GEE_TREE_SET_TYPE_RANGE_TYPE (gee_tree_set_range_type_get_type ())
#define _gee_tree_set_node_free0(var) ((var == NULL) ? NULL : (var = (gee_tree_set_node_free (var), NULL)))

#define GEE_TREE_SET_NODE_TYPE_COLOR (gee_tree_set_node_color_get_type ())

#define GEE_TREE_SET_TYPE_ITERATOR (gee_tree_set_iterator_get_type ())
#define GEE_TREE_SET_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TREE_SET_TYPE_ITERATOR, GeeTreeSetIterator))
#define GEE_TREE_SET_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TREE_SET_TYPE_ITERATOR, GeeTreeSetIteratorClass))
#define GEE_TREE_SET_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TREE_SET_TYPE_ITERATOR))
#define GEE_TREE_SET_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TREE_SET_TYPE_ITERATOR))
#define GEE_TREE_SET_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TREE_SET_TYPE_ITERATOR, GeeTreeSetIteratorClass))

typedef struct _GeeTreeSetIterator GeeTreeSetIterator;
typedef struct _GeeTreeSetIteratorClass GeeTreeSetIteratorClass;

#define GEE_TREE_SET_TYPE_SUB_SET (gee_tree_set_sub_set_get_type ())
#define GEE_TREE_SET_SUB_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TREE_SET_TYPE_SUB_SET, GeeTreeSetSubSet))
#define GEE_TREE_SET_SUB_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TREE_SET_TYPE_SUB_SET, GeeTreeSetSubSetClass))
#define GEE_TREE_SET_IS_SUB_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TREE_SET_TYPE_SUB_SET))
#define GEE_TREE_SET_IS_SUB_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TREE_SET_TYPE_SUB_SET))
#define GEE_TREE_SET_SUB_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TREE_SET_TYPE_SUB_SET, GeeTreeSetSubSetClass))

typedef struct _GeeTreeSetSubSet GeeTreeSetSubSet;
typedef struct _GeeTreeSetSubSetClass GeeTreeSetSubSetClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _GeeTreeSetIteratorPrivate GeeTreeSetIteratorPrivate;
typedef struct _GeeTreeSetSubSetPrivate GeeTreeSetSubSetPrivate;

#define GEE_TREE_SET_TYPE_RANGE (gee_tree_set_range_get_type ())
typedef struct _GeeTreeSetRange GeeTreeSetRange;

#define GEE_TREE_SET_TYPE_SUB_ITERATOR (gee_tree_set_sub_iterator_get_type ())
#define GEE_TREE_SET_SUB_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TREE_SET_TYPE_SUB_ITERATOR, GeeTreeSetSubIterator))
#define GEE_TREE_SET_SUB_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TREE_SET_TYPE_SUB_ITERATOR, GeeTreeSetSubIteratorClass))
#define GEE_TREE_SET_IS_SUB_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TREE_SET_TYPE_SUB_ITERATOR))
#define GEE_TREE_SET_IS_SUB_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TREE_SET_TYPE_SUB_ITERATOR))
#define GEE_TREE_SET_SUB_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TREE_SET_TYPE_SUB_ITERATOR, GeeTreeSetSubIteratorClass))

typedef struct _GeeTreeSetSubIterator GeeTreeSetSubIterator;
typedef struct _GeeTreeSetSubIteratorClass GeeTreeSetSubIteratorClass;
typedef struct _GeeTreeSetSubIteratorPrivate GeeTreeSetSubIteratorPrivate;

struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gboolean (*first) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GeeIterator* (*iterator) (GeeIterable* self);
	GType (*get_element_type) (GeeIterable* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, int* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
	GeeCollection* (*get_read_only_view) (GeeCollection* self);
};

struct _GeeAbstractCollection {
	GObject parent_instance;
	GeeAbstractCollectionPrivate * priv;
};

struct _GeeAbstractCollectionClass {
	GObjectClass parent_class;
	gboolean (*contains) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*add) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*remove) (GeeAbstractCollection* self, gconstpointer item);
	void (*clear) (GeeAbstractCollection* self);
	gpointer* (*to_array) (GeeAbstractCollection* self, int* result_length1);
	gboolean (*add_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeAbstractCollection* self, GeeCollection* collection);
	GeeIterator* (*iterator) (GeeAbstractCollection* self);
	gint (*get_size) (GeeAbstractCollection* self);
	gboolean (*get_is_empty) (GeeAbstractCollection* self);
	GeeCollection* (*get_read_only_view) (GeeAbstractCollection* self);
};

struct _GeeSetIface {
	GTypeInterface parent_iface;
	GeeSet* (*get_read_only_view) (GeeSet* self);
};

struct _GeeAbstractSet {
	GeeAbstractCollection parent_instance;
	GeeAbstractSetPrivate * priv;
};

struct _GeeAbstractSetClass {
	GeeAbstractCollectionClass parent_class;
	GeeSet* (*get_read_only_view) (GeeAbstractSet* self);
};

struct _GeeBidirIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*previous) (GeeBidirIterator* self);
	gboolean (*has_previous) (GeeBidirIterator* self);
	gboolean (*last) (GeeBidirIterator* self);
};

struct _GeeSortedSetIface {
	GTypeInterface parent_iface;
	gpointer (*first) (GeeSortedSet* self);
	gpointer (*last) (GeeSortedSet* self);
	GeeBidirIterator* (*bidir_iterator) (GeeSortedSet* self);
	GeeBidirIterator* (*iterator_at) (GeeSortedSet* self, gconstpointer element);
	gpointer (*lower) (GeeSortedSet* self, gconstpointer element);
	gpointer (*higher) (GeeSortedSet* self, gconstpointer element);
	gpointer (*floor) (GeeSortedSet* self, gconstpointer element);
	gpointer (*ceil) (GeeSortedSet* self, gconstpointer element);
	GeeSortedSet* (*head_set) (GeeSortedSet* self, gconstpointer before);
	GeeSortedSet* (*tail_set) (GeeSortedSet* self, gconstpointer after);
	GeeSortedSet* (*sub_set) (GeeSortedSet* self, gconstpointer from, gconstpointer to);
};

struct _GeeTreeSet {
	GeeAbstractSet parent_instance;
	GeeTreeSetPrivate * priv;
};

struct _GeeTreeSetClass {
	GeeAbstractSetClass parent_class;
};

struct _GeeTreeSetPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GCompareFunc _compare_func;
	gint _size;
	GeeTreeSetNode* root;
	GeeTreeSetNode* _first;
	GeeTreeSetNode* _last;
	gint stamp;
};

typedef enum  {
	GEE_TREE_SET_RANGE_TYPE_HEAD,
	GEE_TREE_SET_RANGE_TYPE_TAIL,
	GEE_TREE_SET_RANGE_TYPE_EMPTY,
	GEE_TREE_SET_RANGE_TYPE_BOUNDED
} GeeTreeSetRangeType;

typedef enum  {
	GEE_TREE_SET_NODE_COLOR_RED,
	GEE_TREE_SET_NODE_COLOR_BLACK
} GeeTreeSetNodeColor;

struct _GeeTreeSetNode {
	gpointer key;
	GeeTreeSetNodeColor color;
	GeeTreeSetNode* left;
	GeeTreeSetNode* right;
	GeeTreeSetNode* prev;
	GeeTreeSetNode* next;
};

struct _GeeTreeSetIterator {
	GObject parent_instance;
	GeeTreeSetIteratorPrivate * priv;
};

struct _GeeTreeSetIteratorClass {
	GObjectClass parent_class;
};

struct _GeeTreeSetIteratorPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeTreeSet* _set;
	gint stamp;
	GeeTreeSetNode* current;
	GeeTreeSetNode* _next;
	GeeTreeSetNode* _prev;
	gboolean started;
};

struct _GeeTreeSetSubSet {
	GeeAbstractSet parent_instance;
	GeeTreeSetSubSetPrivate * priv;
};

struct _GeeTreeSetSubSetClass {
	GeeAbstractSetClass parent_class;
};

struct _GeeTreeSetRange {
	GeeTreeSet* set;
	gpointer after;
	gpointer before;
	GeeTreeSetRangeType type;
};

struct _GeeTreeSetSubSetPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeTreeSet* set;
	GeeTreeSetRange range;
};

struct _GeeTreeSetSubIterator {
	GObject parent_instance;
	GeeTreeSetSubIteratorPrivate * priv;
};

struct _GeeTreeSetSubIteratorClass {
	GObjectClass parent_class;
};

struct _GeeTreeSetSubIteratorPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeTreeSet* set;
	GeeTreeSetRange range;
	GeeTreeSetIterator* iterator;
};


static gpointer gee_tree_set_iterator_parent_class = NULL;
static GeeIteratorIface* gee_tree_set_iterator_gee_iterator_parent_iface = NULL;
static GeeBidirIteratorIface* gee_tree_set_iterator_gee_bidir_iterator_parent_iface = NULL;
static gpointer gee_tree_set_sub_set_parent_class = NULL;
static GeeSortedSetIface* gee_tree_set_sub_set_gee_sorted_set_parent_iface = NULL;
static gpointer gee_tree_set_sub_iterator_parent_class = NULL;
static GeeIteratorIface* gee_tree_set_sub_iterator_gee_iterator_parent_iface = NULL;
static GeeBidirIteratorIface* gee_tree_set_sub_iterator_gee_bidir_iterator_parent_iface = NULL;
static gpointer gee_tree_set_parent_class = NULL;
static GeeSortedSetIface* gee_tree_set_gee_sorted_set_parent_iface = NULL;

GType gee_iterator_get_type (void) G_GNUC_CONST;
GType gee_iterable_get_type (void) G_GNUC_CONST;
GType gee_collection_get_type (void) G_GNUC_CONST;
GType gee_abstract_collection_get_type (void) G_GNUC_CONST;
GType gee_set_get_type (void) G_GNUC_CONST;
GType gee_abstract_set_get_type (void) G_GNUC_CONST;
GType gee_bidir_iterator_get_type (void) G_GNUC_CONST;
GType gee_sorted_set_get_type (void) G_GNUC_CONST;
GType gee_tree_set_get_type (void) G_GNUC_CONST;
static void gee_tree_set_node_free (GeeTreeSetNode* self);
#define GEE_TREE_SET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TYPE_TREE_SET, GeeTreeSetPrivate))
enum  {
	GEE_TREE_SET_DUMMY_PROPERTY,
	GEE_TREE_SET_SIZE,
	GEE_TREE_SET_COMPARE_FUNC,
	GEE_TREE_SET_G_TYPE,
	GEE_TREE_SET_G_DUP_FUNC,
	GEE_TREE_SET_G_DESTROY_FUNC
};
static GType gee_tree_set_range_type_get_type (void) G_GNUC_UNUSED;
GeeAbstractSet* gee_abstract_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
GCompareFunc gee_functions_get_compare_func_for (GType t);
static void gee_tree_set_set_compare_func (GeeTreeSet* self, GCompareFunc value);
GeeTreeSet* gee_tree_set_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GCompareFunc compare_func);
GeeTreeSet* gee_tree_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GCompareFunc compare_func);
GCompareFunc gee_tree_set_get_compare_func (GeeTreeSet* self);
GType gee_tree_set_node_color_get_type (void) G_GNUC_CONST;
static gboolean gee_tree_set_real_contains (GeeAbstractCollection* base, gconstpointer item);
static inline void gee_tree_set_rotate_right (GeeTreeSet* self, GeeTreeSetNode** root);
static inline void gee_tree_set_rotate_left (GeeTreeSet* self, GeeTreeSetNode** root);
static inline gboolean gee_tree_set_is_red (GeeTreeSet* self, GeeTreeSetNode* n);
static inline gboolean gee_tree_set_is_black (GeeTreeSet* self, GeeTreeSetNode* n);
static void gee_tree_set_node_flip (GeeTreeSetNode* self);
static inline void gee_tree_set_fix_up (GeeTreeSet* self, GeeTreeSetNode** node);
static GeeTreeSetNode* gee_tree_set_node_new (gpointer node, GeeTreeSetNode* prev, GeeTreeSetNode* next);
static GeeTreeSetNode* gee_tree_set_node_new (gpointer node, GeeTreeSetNode* prev, GeeTreeSetNode* next);
static gboolean gee_tree_set_add_to_node (GeeTreeSet* self, GeeTreeSetNode** node, gpointer item, GeeTreeSetNode* prev, GeeTreeSetNode* next);
static gboolean gee_tree_set_real_add (GeeAbstractCollection* base, gconstpointer item);
static inline void gee_tree_set_move_red_left (GeeTreeSet* self, GeeTreeSetNode** root);
static inline void gee_tree_set_move_red_right (GeeTreeSet* self, GeeTreeSetNode** root);
static inline void gee_tree_set_fix_removal (GeeTreeSet* self, GeeTreeSetNode** node, gpointer* key);
static void gee_tree_set_remove_minimal (GeeTreeSet* self, GeeTreeSetNode** node, gpointer* key);
static gboolean gee_tree_set_remove_from_node (GeeTreeSet* self, GeeTreeSetNode** node, gconstpointer item, GeeTreeSetNode** prev, GeeTreeSetNode** next);
static gboolean gee_tree_set_real_remove (GeeAbstractCollection* base, gconstpointer item);
static void gee_tree_set_real_clear (GeeAbstractCollection* base);
static GeeTreeSetIterator* gee_tree_set_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set);
static GeeTreeSetIterator* gee_tree_set_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set);
static GType gee_tree_set_iterator_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GeeIterator* gee_tree_set_real_iterator (GeeAbstractCollection* base);
static GeeBidirIterator* gee_tree_set_real_bidir_iterator (GeeSortedSet* base);
static inline gpointer gee_tree_set_lift_null_get (GeeTreeSet* self, GeeTreeSetNode* node);
static gpointer gee_tree_set_real_first (GeeSortedSet* base);
static gpointer gee_tree_set_real_last (GeeSortedSet* base);
static GeeTreeSetSubSet* gee_tree_set_sub_set_new_head (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer before);
static GeeTreeSetSubSet* gee_tree_set_sub_set_construct_head (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer before);
static GType gee_tree_set_sub_set_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GeeSortedSet* gee_tree_set_real_head_set (GeeSortedSet* base, gconstpointer before);
static GeeTreeSetSubSet* gee_tree_set_sub_set_new_tail (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer after);
static GeeTreeSetSubSet* gee_tree_set_sub_set_construct_tail (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer after);
static GeeSortedSet* gee_tree_set_real_tail_set (GeeSortedSet* base, gconstpointer after);
static GeeTreeSetSubSet* gee_tree_set_sub_set_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer after, gconstpointer before);
static GeeTreeSetSubSet* gee_tree_set_sub_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer after, gconstpointer before);
static GeeSortedSet* gee_tree_set_real_sub_set (GeeSortedSet* base, gconstpointer after, gconstpointer before);
static inline GeeTreeSetNode* gee_tree_set_find_node (GeeTreeSet* self, gconstpointer item);
static GeeTreeSetIterator* gee_tree_set_iterator_new_pointing (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetNode* current);
static GeeTreeSetIterator* gee_tree_set_iterator_construct_pointing (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetNode* current);
static GeeBidirIterator* gee_tree_set_real_iterator_at (GeeSortedSet* base, gconstpointer item);
static inline GeeTreeSetNode* gee_tree_set_find_nearest (GeeTreeSet* self, gconstpointer item);
static inline GeeTreeSetNode* gee_tree_set_find_lower (GeeTreeSet* self, gconstpointer item);
static inline GeeTreeSetNode* gee_tree_set_find_higher (GeeTreeSet* self, gconstpointer item);
static inline GeeTreeSetNode* gee_tree_set_find_floor (GeeTreeSet* self, gconstpointer item);
static inline GeeTreeSetNode* gee_tree_set_find_ceil (GeeTreeSet* self, gconstpointer item);
static gpointer gee_tree_set_real_lower (GeeSortedSet* base, gconstpointer item);
static gpointer gee_tree_set_real_higher (GeeSortedSet* base, gconstpointer item);
static gpointer gee_tree_set_real_floor (GeeSortedSet* base, gconstpointer item);
static gpointer gee_tree_set_real_ceil (GeeSortedSet* base, gconstpointer item);
static inline gpointer gee_tree_set_min (GeeTreeSet* self, gconstpointer a, gconstpointer b);
static inline gpointer gee_tree_set_max (GeeTreeSet* self, gconstpointer a, gconstpointer b);
static GeeTreeSetNodeColor gee_tree_set_node_color_flip (GeeTreeSetNodeColor self);
static void gee_tree_set_node_instance_init (GeeTreeSetNode * self);
#define GEE_TREE_SET_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TREE_SET_TYPE_ITERATOR, GeeTreeSetIteratorPrivate))
enum  {
	GEE_TREE_SET_ITERATOR_DUMMY_PROPERTY,
	GEE_TREE_SET_ITERATOR_G_TYPE,
	GEE_TREE_SET_ITERATOR_G_DUP_FUNC,
	GEE_TREE_SET_ITERATOR_G_DESTROY_FUNC
};
static gboolean gee_tree_set_iterator_real_next (GeeIterator* base);
static gboolean gee_tree_set_iterator_real_has_next (GeeIterator* base);
static gboolean gee_tree_set_iterator_real_first (GeeIterator* base);
static gboolean gee_tree_set_iterator_real_previous (GeeBidirIterator* base);
static gboolean gee_tree_set_iterator_real_has_previous (GeeBidirIterator* base);
static gboolean gee_tree_set_iterator_real_last (GeeBidirIterator* base);
static gpointer gee_tree_set_iterator_real_get (GeeIterator* base);
static void gee_tree_set_iterator_real_remove (GeeIterator* base);
static gboolean gee_tree_set_iterator_safe_next_get (GeeTreeSetIterator* self, gpointer* val);
static gboolean gee_tree_set_iterator_safe_previous_get (GeeTreeSetIterator* self, gpointer* val);
static void gee_tree_set_iterator_finalize (GObject* obj);
static void gee_tree_set_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gee_tree_set_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static GType gee_tree_set_range_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GeeTreeSetRange* gee_tree_set_range_dup (const GeeTreeSetRange* self);
static void gee_tree_set_range_free (GeeTreeSetRange* self);
static void gee_tree_set_range_copy (const GeeTreeSetRange* self, GeeTreeSetRange* dest);
static void gee_tree_set_range_destroy (GeeTreeSetRange* self);
#define GEE_TREE_SET_SUB_SET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TREE_SET_TYPE_SUB_SET, GeeTreeSetSubSetPrivate))
enum  {
	GEE_TREE_SET_SUB_SET_DUMMY_PROPERTY,
	GEE_TREE_SET_SUB_SET_SIZE,
	GEE_TREE_SET_SUB_SET_IS_EMPTY,
	GEE_TREE_SET_SUB_SET_G_TYPE,
	GEE_TREE_SET_SUB_SET_G_DUP_FUNC,
	GEE_TREE_SET_SUB_SET_G_DESTROY_FUNC
};
static void gee_tree_set_range_init (GeeTreeSetRange *self, GeeTreeSet* set, gconstpointer after, gconstpointer before);
static void gee_tree_set_range_init_head (GeeTreeSetRange *self, GeeTreeSet* set, gconstpointer before);
static void gee_tree_set_range_init_tail (GeeTreeSetRange *self, GeeTreeSet* set, gconstpointer after);
static GeeTreeSetSubSet* gee_tree_set_sub_set_new_from_range (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetRange* range);
static GeeTreeSetSubSet* gee_tree_set_sub_set_construct_from_range (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetRange* range);
static gboolean gee_tree_set_range_in_range (GeeTreeSetRange *self, gconstpointer item);
gboolean gee_abstract_collection_contains (GeeAbstractCollection* self, gconstpointer item);
static gboolean gee_tree_set_sub_set_real_contains (GeeAbstractCollection* base, gconstpointer item);
gboolean gee_abstract_collection_add (GeeAbstractCollection* self, gconstpointer item);
static gboolean gee_tree_set_sub_set_real_add (GeeAbstractCollection* base, gconstpointer item);
gboolean gee_abstract_collection_remove (GeeAbstractCollection* self, gconstpointer item);
static gboolean gee_tree_set_sub_set_real_remove (GeeAbstractCollection* base, gconstpointer item);
GeeIterator* gee_abstract_collection_iterator (GeeAbstractCollection* self);
gboolean gee_iterator_next (GeeIterator* self);
void gee_iterator_remove (GeeIterator* self);
static void gee_tree_set_sub_set_real_clear (GeeAbstractCollection* base);
static GeeTreeSetSubIterator* gee_tree_set_sub_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetRange* range);
static GeeTreeSetSubIterator* gee_tree_set_sub_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetRange* range);
static GType gee_tree_set_sub_iterator_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GeeIterator* gee_tree_set_sub_set_real_iterator (GeeAbstractCollection* base);
static GeeBidirIterator* gee_tree_set_sub_set_real_bidir_iterator (GeeSortedSet* base);
static GeeTreeSetNode* gee_tree_set_range_first (GeeTreeSetRange *self);
static gpointer gee_tree_set_sub_set_real_first (GeeSortedSet* base);
static GeeTreeSetNode* gee_tree_set_range_last (GeeTreeSetRange *self);
static gpointer gee_tree_set_sub_set_real_last (GeeSortedSet* base);
static void gee_tree_set_range_cut_tail (GeeTreeSetRange *self, gconstpointer before, GeeTreeSetRange* result);
static GeeSortedSet* gee_tree_set_sub_set_real_head_set (GeeSortedSet* base, gconstpointer before);
static void gee_tree_set_range_cut_head (GeeTreeSetRange *self, gconstpointer after, GeeTreeSetRange* result);
static GeeSortedSet* gee_tree_set_sub_set_real_tail_set (GeeSortedSet* base, gconstpointer after);
static void gee_tree_set_range_cut (GeeTreeSetRange *self, gconstpointer after, gconstpointer before, GeeTreeSetRange* result);
static GeeSortedSet* gee_tree_set_sub_set_real_sub_set (GeeSortedSet* base, gconstpointer after, gconstpointer before);
static GeeTreeSetSubIterator* gee_tree_set_sub_iterator_new_pointing (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetRange* range, GeeTreeSetNode* node);
static GeeTreeSetSubIterator* gee_tree_set_sub_iterator_construct_pointing (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetRange* range, GeeTreeSetNode* node);
static GeeBidirIterator* gee_tree_set_sub_set_real_iterator_at (GeeSortedSet* base, gconstpointer item);
static gint gee_tree_set_range_compare_range (GeeTreeSetRange *self, gconstpointer item);
gpointer gee_sorted_set_last (GeeSortedSet* self);
gpointer gee_sorted_set_lower (GeeSortedSet* self, gconstpointer element);
static gpointer gee_tree_set_sub_set_real_lower (GeeSortedSet* base, gconstpointer item);
gpointer gee_sorted_set_first (GeeSortedSet* self);
gpointer gee_sorted_set_higher (GeeSortedSet* self, gconstpointer element);
static gpointer gee_tree_set_sub_set_real_higher (GeeSortedSet* base, gconstpointer item);
gpointer gee_sorted_set_floor (GeeSortedSet* self, gconstpointer element);
static gpointer gee_tree_set_sub_set_real_floor (GeeSortedSet* base, gconstpointer item);
gpointer gee_sorted_set_ceil (GeeSortedSet* self, gconstpointer element);
static gpointer gee_tree_set_sub_set_real_ceil (GeeSortedSet* base, gconstpointer item);
static gboolean gee_tree_set_range_empty_subset (GeeTreeSetRange *self);
static void gee_tree_set_sub_set_finalize (GObject* obj);
gint gee_abstract_collection_get_size (GeeAbstractCollection* self);
gboolean gee_abstract_collection_get_is_empty (GeeAbstractCollection* self);
static void gee_tree_set_sub_set_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gee_tree_set_sub_set_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define GEE_TREE_SET_SUB_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TREE_SET_TYPE_SUB_ITERATOR, GeeTreeSetSubIteratorPrivate))
enum  {
	GEE_TREE_SET_SUB_ITERATOR_DUMMY_PROPERTY,
	GEE_TREE_SET_SUB_ITERATOR_G_TYPE,
	GEE_TREE_SET_SUB_ITERATOR_G_DUP_FUNC,
	GEE_TREE_SET_SUB_ITERATOR_G_DESTROY_FUNC
};
gboolean gee_iterator_first (GeeIterator* self);
static gboolean gee_tree_set_sub_iterator_real_next (GeeIterator* base);
static gboolean gee_tree_set_sub_iterator_real_has_next (GeeIterator* base);
static gboolean gee_tree_set_sub_iterator_real_first (GeeIterator* base);
gboolean gee_bidir_iterator_previous (GeeBidirIterator* self);
static gboolean gee_tree_set_sub_iterator_real_previous (GeeBidirIterator* base);
static gboolean gee_tree_set_sub_iterator_real_has_previous (GeeBidirIterator* base);
static gboolean gee_tree_set_sub_iterator_real_last (GeeBidirIterator* base);
gpointer gee_iterator_get (GeeIterator* self);
static gpointer gee_tree_set_sub_iterator_real_get (GeeIterator* base);
static void gee_tree_set_sub_iterator_real_remove (GeeIterator* base);
static void gee_tree_set_sub_iterator_finalize (GObject* obj);
static void gee_tree_set_sub_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gee_tree_set_sub_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void gee_tree_set_finalize (GObject* obj);
static void gee_tree_set_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gee_tree_set_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



static GType gee_tree_set_range_type_get_type (void) {
	static volatile gsize gee_tree_set_range_type_type_id__volatile = 0;
	if (g_once_init_enter (&gee_tree_set_range_type_type_id__volatile)) {
		static const GEnumValue values[] = {{GEE_TREE_SET_RANGE_TYPE_HEAD, "GEE_TREE_SET_RANGE_TYPE_HEAD", "head"}, {GEE_TREE_SET_RANGE_TYPE_TAIL, "GEE_TREE_SET_RANGE_TYPE_TAIL", "tail"}, {GEE_TREE_SET_RANGE_TYPE_EMPTY, "GEE_TREE_SET_RANGE_TYPE_EMPTY", "empty"}, {GEE_TREE_SET_RANGE_TYPE_BOUNDED, "GEE_TREE_SET_RANGE_TYPE_BOUNDED", "bounded"}, {0, NULL, NULL}};
		GType gee_tree_set_range_type_type_id;
		gee_tree_set_range_type_type_id = g_enum_register_static ("GeeTreeSetRangeType", values);
		g_once_init_leave (&gee_tree_set_range_type_type_id__volatile, gee_tree_set_range_type_type_id);
	}
	return gee_tree_set_range_type_type_id__volatile;
}


/**
 * Constructs a new, empty tree set sorted according to the specified
 * comparator function.
 *
 * If not provided, the function parameter is requested to the
 * {@link Functions} function factory methods.
 *
 * @param compare_func an optional element comparator function
 */
#line 59 "treeset.vala"
GeeTreeSet* gee_tree_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GCompareFunc compare_func) {
#line 578 "treeset.c"
	GeeTreeSet * self;
#line 59 "treeset.vala"
	self = (GeeTreeSet*) gee_abstract_set_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
#line 59 "treeset.vala"
	self->priv->g_type = g_type;
#line 59 "treeset.vala"
	self->priv->g_dup_func = g_dup_func;
#line 59 "treeset.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 60 "treeset.vala"
	if (compare_func == NULL) {
#line 61 "treeset.vala"
		compare_func = gee_functions_get_compare_func_for (g_type);
#line 592 "treeset.c"
	}
#line 63 "treeset.vala"
	gee_tree_set_set_compare_func (self, compare_func);
#line 596 "treeset.c"
	return self;
}


#line 59 "treeset.vala"
GeeTreeSet* gee_tree_set_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GCompareFunc compare_func) {
#line 59 "treeset.vala"
	return gee_tree_set_construct (GEE_TYPE_TREE_SET, g_type, g_dup_func, g_destroy_func, compare_func);
#line 605 "treeset.c"
}


/**
 * {@inheritDoc}
 */
#line 69 "treeset.vala"
static gboolean gee_tree_set_real_contains (GeeAbstractCollection* base, gconstpointer item) {
#line 614 "treeset.c"
	GeeTreeSet * self;
	gboolean result = FALSE;
	GeeTreeSetNode* cur;
	self = (GeeTreeSet*) base;
#line 70 "treeset.vala"
	cur = self->priv->root;
#line 71 "treeset.vala"
	while (TRUE) {
#line 623 "treeset.c"
		gint res;
#line 71 "treeset.vala"
		if (!(cur != NULL)) {
#line 71 "treeset.vala"
			break;
#line 629 "treeset.c"
		}
#line 72 "treeset.vala"
		res = gee_tree_set_get_compare_func (self) (item, cur->key);
#line 73 "treeset.vala"
		if (res == 0) {
#line 635 "treeset.c"
			result = TRUE;
#line 74 "treeset.vala"
			return result;
#line 639 "treeset.c"
		} else {
#line 75 "treeset.vala"
			if (res < 0) {
#line 76 "treeset.vala"
				cur = cur->left;
#line 645 "treeset.c"
			} else {
#line 78 "treeset.vala"
				cur = cur->right;
#line 649 "treeset.c"
			}
		}
	}
	result = FALSE;
#line 81 "treeset.vala"
	return result;
#line 656 "treeset.c"
}


#line 84 "treeset.vala"
static inline void gee_tree_set_rotate_right (GeeTreeSet* self, GeeTreeSetNode** root) {
#line 662 "treeset.c"
	GeeTreeSetNode* _tmp0_;
	GeeTreeSetNode* pivot;
	GeeTreeSetNode* _tmp2_;
	GeeTreeSetNode* _tmp1_;
	GeeTreeSetNode* _tmp4_;
	GeeTreeSetNode* _tmp3_;
	GeeTreeSetNode* _tmp6_;
	GeeTreeSetNode* _tmp5_;
#line 84 "treeset.vala"
	g_return_if_fail (self != NULL);
#line 84 "treeset.vala"
	g_return_if_fail (root != NULL);
#line 85 "treeset.vala"
	pivot = (_tmp0_ = (*root)->left, (*root)->left = NULL, _tmp0_);
#line 86 "treeset.vala"
	pivot->color = (*root)->color;
#line 87 "treeset.vala"
	(*root)->color = GEE_TREE_SET_NODE_COLOR_RED;
#line 88 "treeset.vala"
	(*root)->left = (_tmp2_ = (_tmp1_ = pivot->right, pivot->right = NULL, _tmp1_), _gee_tree_set_node_free0 ((*root)->left), _tmp2_);
#line 89 "treeset.vala"
	pivot->right = (_tmp4_ = (_tmp3_ = *root, *root = NULL, _tmp3_), _gee_tree_set_node_free0 (pivot->right), _tmp4_);
#line 90 "treeset.vala"
	*root = (_tmp6_ = (_tmp5_ = pivot, pivot = NULL, _tmp5_), _gee_tree_set_node_free0 (*root), _tmp6_);
#line 687 "treeset.c"
	_gee_tree_set_node_free0 (pivot);
}


#line 96 "treeset.vala"
static inline void gee_tree_set_rotate_left (GeeTreeSet* self, GeeTreeSetNode** root) {
#line 694 "treeset.c"
	GeeTreeSetNode* _tmp0_;
	GeeTreeSetNode* pivot;
	GeeTreeSetNode* _tmp2_;
	GeeTreeSetNode* _tmp1_;
	GeeTreeSetNode* _tmp4_;
	GeeTreeSetNode* _tmp3_;
	GeeTreeSetNode* _tmp6_;
	GeeTreeSetNode* _tmp5_;
#line 96 "treeset.vala"
	g_return_if_fail (self != NULL);
#line 96 "treeset.vala"
	g_return_if_fail (root != NULL);
#line 97 "treeset.vala"
	pivot = (_tmp0_ = (*root)->right, (*root)->right = NULL, _tmp0_);
#line 98 "treeset.vala"
	pivot->color = (*root)->color;
#line 99 "treeset.vala"
	(*root)->color = GEE_TREE_SET_NODE_COLOR_RED;
#line 100 "treeset.vala"
	(*root)->right = (_tmp2_ = (_tmp1_ = pivot->left, pivot->left = NULL, _tmp1_), _gee_tree_set_node_free0 ((*root)->right), _tmp2_);
#line 101 "treeset.vala"
	pivot->left = (_tmp4_ = (_tmp3_ = *root, *root = NULL, _tmp3_), _gee_tree_set_node_free0 (pivot->left), _tmp4_);
#line 102 "treeset.vala"
	*root = (_tmp6_ = (_tmp5_ = pivot, pivot = NULL, _tmp5_), _gee_tree_set_node_free0 (*root), _tmp6_);
#line 719 "treeset.c"
	_gee_tree_set_node_free0 (pivot);
}


#line 108 "treeset.vala"
static inline gboolean gee_tree_set_is_red (GeeTreeSet* self, GeeTreeSetNode* n) {
#line 726 "treeset.c"
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 108 "treeset.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 109 "treeset.vala"
	if (n != NULL) {
#line 109 "treeset.vala"
		_tmp0_ = n->color == GEE_TREE_SET_NODE_COLOR_RED;
#line 735 "treeset.c"
	} else {
#line 109 "treeset.vala"
		_tmp0_ = FALSE;
#line 739 "treeset.c"
	}
	result = _tmp0_;
#line 109 "treeset.vala"
	return result;
#line 744 "treeset.c"
}


#line 112 "treeset.vala"
static inline gboolean gee_tree_set_is_black (GeeTreeSet* self, GeeTreeSetNode* n) {
#line 750 "treeset.c"
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 112 "treeset.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 113 "treeset.vala"
	if (n == NULL) {
#line 113 "treeset.vala"
		_tmp0_ = TRUE;
#line 759 "treeset.c"
	} else {
#line 113 "treeset.vala"
		_tmp0_ = n->color == GEE_TREE_SET_NODE_COLOR_BLACK;
#line 763 "treeset.c"
	}
	result = _tmp0_;
#line 113 "treeset.vala"
	return result;
#line 768 "treeset.c"
}


#line 116 "treeset.vala"
static inline void gee_tree_set_fix_up (GeeTreeSet* self, GeeTreeSetNode** node) {
#line 774 "treeset.c"
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 116 "treeset.vala"
	g_return_if_fail (self != NULL);
#line 116 "treeset.vala"
	g_return_if_fail (node != NULL);
#line 120 "treeset.vala"
	if (gee_tree_set_is_black (self, (*node)->left)) {
#line 120 "treeset.vala"
		_tmp0_ = gee_tree_set_is_red (self, (*node)->right);
#line 786 "treeset.c"
	} else {
#line 120 "treeset.vala"
		_tmp0_ = FALSE;
#line 790 "treeset.c"
	}
#line 120 "treeset.vala"
	if (_tmp0_) {
#line 121 "treeset.vala"
		gee_tree_set_rotate_left (self, node);
#line 796 "treeset.c"
	}
#line 123 "treeset.vala"
	if (gee_tree_set_is_red (self, (*node)->left)) {
#line 123 "treeset.vala"
		_tmp1_ = gee_tree_set_is_red (self, (*node)->left->left);
#line 802 "treeset.c"
	} else {
#line 123 "treeset.vala"
		_tmp1_ = FALSE;
#line 806 "treeset.c"
	}
#line 123 "treeset.vala"
	if (_tmp1_) {
#line 124 "treeset.vala"
		gee_tree_set_rotate_right (self, node);
#line 812 "treeset.c"
	}
#line 126 "treeset.vala"
	if (gee_tree_set_is_red (self, (*node)->left)) {
#line 126 "treeset.vala"
		_tmp2_ = gee_tree_set_is_red (self, (*node)->right);
#line 818 "treeset.c"
	} else {
#line 126 "treeset.vala"
		_tmp2_ = FALSE;
#line 822 "treeset.c"
	}
#line 126 "treeset.vala"
	if (_tmp2_) {
#line 127 "treeset.vala"
		gee_tree_set_node_flip (*node);
#line 828 "treeset.c"
	}
}


#line 134 "treeset.vala"
static gboolean gee_tree_set_add_to_node (GeeTreeSet* self, GeeTreeSetNode** node, gpointer item, GeeTreeSetNode* prev, GeeTreeSetNode* next) {
#line 835 "treeset.c"
	gboolean result = FALSE;
	gint cmp;
#line 134 "treeset.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 139 "treeset.vala"
	if ((*node) == NULL) {
#line 842 "treeset.c"
		GeeTreeSetNode* _tmp1_;
		gpointer _tmp0_;
#line 140 "treeset.vala"
		*node = (_tmp1_ = gee_tree_set_node_new ((_tmp0_ = item, item = NULL, _tmp0_), prev, next), _gee_tree_set_node_free0 (*node), _tmp1_);
#line 141 "treeset.vala"
		if (prev == NULL) {
#line 142 "treeset.vala"
			self->priv->_first = *node;
#line 851 "treeset.c"
		}
#line 144 "treeset.vala"
		if (next == NULL) {
#line 145 "treeset.vala"
			self->priv->_last = *node;
#line 857 "treeset.c"
		}
#line 147 "treeset.vala"
		self->priv->_size++;
#line 861 "treeset.c"
		result = TRUE;
		((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
#line 148 "treeset.vala"
		return result;
#line 866 "treeset.c"
	}
#line 151 "treeset.vala"
	cmp = gee_tree_set_get_compare_func (self) (item, (*node)->key);
#line 152 "treeset.vala"
	if (cmp == 0) {
#line 153 "treeset.vala"
		gee_tree_set_fix_up (self, node);
#line 874 "treeset.c"
		result = FALSE;
		((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
#line 154 "treeset.vala"
		return result;
#line 879 "treeset.c"
	} else {
#line 155 "treeset.vala"
		if (cmp < 0) {
#line 883 "treeset.c"
			gconstpointer _tmp2_;
			gboolean r;
#line 156 "treeset.vala"
			r = gee_tree_set_add_to_node (self, &(*node)->left, (_tmp2_ = item, ((_tmp2_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp2_) : self->priv->g_dup_func ((gpointer) _tmp2_)), (*node)->prev, *node);
#line 157 "treeset.vala"
			gee_tree_set_fix_up (self, node);
#line 890 "treeset.c"
			result = r;
			((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
#line 158 "treeset.vala"
			return result;
#line 895 "treeset.c"
		} else {
			gconstpointer _tmp3_;
			gboolean r;
#line 160 "treeset.vala"
			r = gee_tree_set_add_to_node (self, &(*node)->right, (_tmp3_ = item, ((_tmp3_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp3_) : self->priv->g_dup_func ((gpointer) _tmp3_)), *node, (*node)->next);
#line 161 "treeset.vala"
			gee_tree_set_fix_up (self, node);
#line 903 "treeset.c"
			result = r;
			((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
#line 162 "treeset.vala"
			return result;
#line 908 "treeset.c"
		}
	}
	((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
}


/**
 * {@inheritDoc}
 *
 * If the element already exists in the set it will not be added twice.
 */
#line 171 "treeset.vala"
static gboolean gee_tree_set_real_add (GeeAbstractCollection* base, gconstpointer item) {
#line 922 "treeset.c"
	GeeTreeSet * self;
	gboolean result = FALSE;
	gconstpointer _tmp0_;
	gboolean r;
	self = (GeeTreeSet*) base;
#line 175 "treeset.vala"
	r = gee_tree_set_add_to_node (self, &self->priv->root, (_tmp0_ = item, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_)), NULL, NULL);
#line 176 "treeset.vala"
	self->priv->root->color = GEE_TREE_SET_NODE_COLOR_BLACK;
#line 180 "treeset.vala"
	self->priv->stamp++;
#line 934 "treeset.c"
	result = r;
#line 181 "treeset.vala"
	return result;
#line 938 "treeset.c"
}


#line 184 "treeset.vala"
static inline void gee_tree_set_move_red_left (GeeTreeSet* self, GeeTreeSetNode** root) {
#line 184 "treeset.vala"
	g_return_if_fail (self != NULL);
#line 184 "treeset.vala"
	g_return_if_fail (root != NULL);
#line 188 "treeset.vala"
	gee_tree_set_node_flip (*root);
#line 189 "treeset.vala"
	if (gee_tree_set_is_red (self, (*root)->right->left)) {
#line 190 "treeset.vala"
		gee_tree_set_rotate_right (self, &(*root)->right);
#line 191 "treeset.vala"
		gee_tree_set_rotate_left (self, root);
#line 192 "treeset.vala"
		gee_tree_set_node_flip (*root);
#line 958 "treeset.c"
	}
}


#line 199 "treeset.vala"
static inline void gee_tree_set_move_red_right (GeeTreeSet* self, GeeTreeSetNode** root) {
#line 199 "treeset.vala"
	g_return_if_fail (self != NULL);
#line 199 "treeset.vala"
	g_return_if_fail (root != NULL);
#line 203 "treeset.vala"
	gee_tree_set_node_flip (*root);
#line 204 "treeset.vala"
	if (gee_tree_set_is_red (self, (*root)->left->left)) {
#line 205 "treeset.vala"
		gee_tree_set_rotate_right (self, root);
#line 206 "treeset.vala"
		gee_tree_set_node_flip (*root);
#line 977 "treeset.c"
	}
}


#line 213 "treeset.vala"
static inline void gee_tree_set_fix_removal (GeeTreeSet* self, GeeTreeSetNode** node, gpointer* key) {
#line 984 "treeset.c"
	GeeTreeSetNode* _tmp0_;
	GeeTreeSetNode* n;
	GeeTreeSetNode* _tmp3_;
#line 213 "treeset.vala"
	g_return_if_fail (self != NULL);
#line 213 "treeset.vala"
	g_return_if_fail (node != NULL);
#line 214 "treeset.vala"
	n = (_tmp0_ = *node, *node = NULL, _tmp0_);
#line 215 "treeset.vala"
	if ((key) != NULL) {
#line 996 "treeset.c"
		gpointer _tmp2_;
		gpointer _tmp1_;
#line 216 "treeset.vala"
		*key = (_tmp2_ = (_tmp1_ = n->key, n->key = NULL, _tmp1_), (((*key) == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (*key = (self->priv->g_destroy_func (*key), NULL)), _tmp2_);
#line 1001 "treeset.c"
	}
#line 217 "treeset.vala"
	if (n->prev != NULL) {
#line 218 "treeset.vala"
		n->prev->next = n->next;
#line 1007 "treeset.c"
	} else {
#line 220 "treeset.vala"
		self->priv->_first = n->next;
#line 1011 "treeset.c"
	}
#line 222 "treeset.vala"
	if (n->next != NULL) {
#line 223 "treeset.vala"
		n->next->prev = n->prev;
#line 1017 "treeset.c"
	} else {
#line 225 "treeset.vala"
		self->priv->_last = n->prev;
#line 1021 "treeset.c"
	}
#line 227 "treeset.vala"
	*node = (_tmp3_ = NULL, _gee_tree_set_node_free0 (*node), _tmp3_);
#line 228 "treeset.vala"
	self->priv->_size--;
#line 1027 "treeset.c"
	_gee_tree_set_node_free0 (n);
}


#line 231 "treeset.vala"
static void gee_tree_set_remove_minimal (GeeTreeSet* self, GeeTreeSetNode** node, gpointer* key) {
#line 1034 "treeset.c"
	gboolean _tmp2_ = FALSE;
	gpointer _tmp4_;
	gpointer _tmp3_ = NULL;
#line 231 "treeset.vala"
	g_return_if_fail (self != NULL);
#line 231 "treeset.vala"
	g_return_if_fail (node != NULL);
#line 232 "treeset.vala"
	if ((*node)->left == NULL) {
#line 1044 "treeset.c"
		gpointer _tmp1_;
		gpointer _tmp0_ = NULL;
#line 233 "treeset.vala"
		gee_tree_set_fix_removal (self, node, &_tmp0_);
#line 233 "treeset.vala"
		*key = (_tmp1_ = _tmp0_, (((*key) == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (*key = (self->priv->g_destroy_func (*key), NULL)), _tmp1_);
#line 234 "treeset.vala"
		return;
#line 1053 "treeset.c"
	}
#line 237 "treeset.vala"
	if (gee_tree_set_is_black (self, (*node)->left)) {
#line 237 "treeset.vala"
		_tmp2_ = gee_tree_set_is_black (self, (*node)->left->left);
#line 1059 "treeset.c"
	} else {
#line 237 "treeset.vala"
		_tmp2_ = FALSE;
#line 1063 "treeset.c"
	}
#line 237 "treeset.vala"
	if (_tmp2_) {
#line 238 "treeset.vala"
		gee_tree_set_move_red_left (self, node);
#line 1069 "treeset.c"
	}
#line 241 "treeset.vala"
	gee_tree_set_remove_minimal (self, &(*node)->left, &_tmp3_);
#line 241 "treeset.vala"
	*key = (_tmp4_ = _tmp3_, (((*key) == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (*key = (self->priv->g_destroy_func (*key), NULL)), _tmp4_);
#line 243 "treeset.vala"
	gee_tree_set_fix_up (self, node);
#line 1077 "treeset.c"
}


#line 246 "treeset.vala"
static gboolean gee_tree_set_remove_from_node (GeeTreeSet* self, GeeTreeSetNode** node, gconstpointer item, GeeTreeSetNode** prev, GeeTreeSetNode** next) {
#line 1083 "treeset.c"
	gboolean result = FALSE;
#line 246 "treeset.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1087 "treeset.c"
	if (prev != NULL) {
		*prev = NULL;
	}
	if (next != NULL) {
		*next = NULL;
	}
#line 250 "treeset.vala"
	if ((*node) == NULL) {
#line 1096 "treeset.c"
		result = FALSE;
#line 251 "treeset.vala"
		return result;
#line 1100 "treeset.c"
	} else {
#line 252 "treeset.vala"
		if (gee_tree_set_get_compare_func (self) (item, (*node)->key) < 0) {
#line 1104 "treeset.c"
			GeeTreeSetNode* left;
			gboolean _tmp0_ = FALSE;
			gboolean r;
#line 253 "treeset.vala"
			left = (*node)->left;
#line 254 "treeset.vala"
			if (left == NULL) {
#line 1112 "treeset.c"
				result = FALSE;
#line 255 "treeset.vala"
				return result;
#line 1116 "treeset.c"
			}
#line 257 "treeset.vala"
			if (gee_tree_set_is_black (self, left)) {
#line 257 "treeset.vala"
				_tmp0_ = gee_tree_set_is_black (self, left->left);
#line 1122 "treeset.c"
			} else {
#line 257 "treeset.vala"
				_tmp0_ = FALSE;
#line 1126 "treeset.c"
			}
#line 257 "treeset.vala"
			if (_tmp0_) {
#line 258 "treeset.vala"
				gee_tree_set_move_red_left (self, node);
#line 1132 "treeset.c"
			}
#line 260 "treeset.vala"
			r = gee_tree_set_remove_from_node (self, &(*node)->left, item, prev, next);
#line 261 "treeset.vala"
			gee_tree_set_fix_up (self, node);
#line 1138 "treeset.c"
			result = r;
#line 262 "treeset.vala"
			return result;
#line 1142 "treeset.c"
		} else {
			GeeTreeSetNode* r;
			gboolean _tmp1_ = FALSE;
			gboolean _tmp2_ = FALSE;
			gboolean _tmp3_ = FALSE;
#line 264 "treeset.vala"
			if (gee_tree_set_is_red (self, (*node)->left)) {
#line 265 "treeset.vala"
				gee_tree_set_rotate_right (self, node);
#line 1152 "treeset.c"
			}
#line 268 "treeset.vala"
			r = (*node)->right;
#line 269 "treeset.vala"
			if (gee_tree_set_get_compare_func (self) (item, (*node)->key) == 0) {
#line 269 "treeset.vala"
				_tmp1_ = r == NULL;
#line 1160 "treeset.c"
			} else {
#line 269 "treeset.vala"
				_tmp1_ = FALSE;
#line 1164 "treeset.c"
			}
#line 269 "treeset.vala"
			if (_tmp1_) {
#line 270 "treeset.vala"
				if ((prev) != NULL) {
#line 271 "treeset.vala"
					*prev = (*node)->prev;
#line 1172 "treeset.c"
				}
#line 272 "treeset.vala"
				if ((next) != NULL) {
#line 273 "treeset.vala"
					*next = (*node)->next;
#line 1178 "treeset.c"
				}
#line 274 "treeset.vala"
				gee_tree_set_fix_removal (self, node, NULL);
#line 1182 "treeset.c"
				result = TRUE;
#line 275 "treeset.vala"
				return result;
#line 1186 "treeset.c"
			}
#line 277 "treeset.vala"
			if (gee_tree_set_is_black (self, r)) {
#line 277 "treeset.vala"
				_tmp3_ = r != NULL;
#line 1192 "treeset.c"
			} else {
#line 277 "treeset.vala"
				_tmp3_ = FALSE;
#line 1196 "treeset.c"
			}
#line 277 "treeset.vala"
			if (_tmp3_) {
#line 277 "treeset.vala"
				_tmp2_ = gee_tree_set_is_black (self, r->left);
#line 1202 "treeset.c"
			} else {
#line 277 "treeset.vala"
				_tmp2_ = FALSE;
#line 1206 "treeset.c"
			}
#line 277 "treeset.vala"
			if (_tmp2_) {
#line 278 "treeset.vala"
				gee_tree_set_move_red_right (self, node);
#line 1212 "treeset.c"
			}
#line 280 "treeset.vala"
			if (gee_tree_set_get_compare_func (self) (item, (*node)->key) == 0) {
#line 1216 "treeset.c"
				gpointer _tmp5_;
				gpointer _tmp4_ = NULL;
#line 281 "treeset.vala"
				if ((prev) != NULL) {
#line 282 "treeset.vala"
					*prev = (*node)->prev;
#line 1223 "treeset.c"
				}
#line 283 "treeset.vala"
				if ((next) != NULL) {
#line 284 "treeset.vala"
					*next = *node;
#line 1229 "treeset.c"
				}
#line 285 "treeset.vala"
				gee_tree_set_remove_minimal (self, &(*node)->right, &_tmp4_);
#line 285 "treeset.vala"
				(*node)->key = (_tmp5_ = _tmp4_, (((*node)->key == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : ((*node)->key = (self->priv->g_destroy_func ((*node)->key), NULL)), _tmp5_);
#line 286 "treeset.vala"
				gee_tree_set_fix_up (self, node);
#line 1237 "treeset.c"
				result = TRUE;
#line 287 "treeset.vala"
				return result;
#line 1241 "treeset.c"
			} else {
				gboolean re;
#line 289 "treeset.vala"
				re = gee_tree_set_remove_from_node (self, &(*node)->right, item, prev, next);
#line 290 "treeset.vala"
				gee_tree_set_fix_up (self, node);
#line 1248 "treeset.c"
				result = re;
#line 291 "treeset.vala"
				return result;
#line 1252 "treeset.c"
			}
		}
	}
}


/**
 * {@inheritDoc}
 */
#line 299 "treeset.vala"
static gboolean gee_tree_set_real_remove (GeeAbstractCollection* base, gconstpointer item) {
#line 1264 "treeset.c"
	GeeTreeSet * self;
	gboolean result = FALSE;
	gboolean b;
	self = (GeeTreeSet*) base;
#line 303 "treeset.vala"
	b = gee_tree_set_remove_from_node (self, &self->priv->root, item, NULL, NULL);
#line 304 "treeset.vala"
	if (self->priv->root != NULL) {
#line 305 "treeset.vala"
		self->priv->root->color = GEE_TREE_SET_NODE_COLOR_BLACK;
#line 1275 "treeset.c"
	}
#line 310 "treeset.vala"
	self->priv->stamp++;
#line 1279 "treeset.c"
	result = b;
#line 311 "treeset.vala"
	return result;
#line 1283 "treeset.c"
}


/**
 * {@inheritDoc}
 */
#line 317 "treeset.vala"
static void gee_tree_set_real_clear (GeeAbstractCollection* base) {
#line 1292 "treeset.c"
	GeeTreeSet * self;
	GeeTreeSetNode* _tmp0_;
	self = (GeeTreeSet*) base;
#line 318 "treeset.vala"
	self->priv->_first = self->priv->_last = self->priv->root = (_tmp0_ = NULL, _gee_tree_set_node_free0 (self->priv->root), _tmp0_);
#line 319 "treeset.vala"
	self->priv->_size = 0;
#line 320 "treeset.vala"
	self->priv->stamp++;
#line 1302 "treeset.c"
}


/**
 * {@inheritDoc}
 */
#line 326 "treeset.vala"
static GeeIterator* gee_tree_set_real_iterator (GeeAbstractCollection* base) {
#line 1311 "treeset.c"
	GeeTreeSet * self;
	GeeIterator* result = NULL;
	self = (GeeTreeSet*) base;
	result = (GeeIterator*) gee_tree_set_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self);
#line 327 "treeset.vala"
	return result;
#line 1318 "treeset.c"
}


/**
 * {@inheritDoc}
 */
#line 333 "treeset.vala"
static GeeBidirIterator* gee_tree_set_real_bidir_iterator (GeeSortedSet* base) {
#line 1327 "treeset.c"
	GeeTreeSet * self;
	GeeBidirIterator* result = NULL;
	self = (GeeTreeSet*) base;
	result = (GeeBidirIterator*) gee_tree_set_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self);
#line 334 "treeset.vala"
	return result;
#line 1334 "treeset.c"
}


#line 337 "treeset.vala"
static inline gpointer gee_tree_set_lift_null_get (GeeTreeSet* self, GeeTreeSetNode* node) {
#line 1340 "treeset.c"
	gpointer result = NULL;
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
#line 337 "treeset.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1346 "treeset.c"
	_tmp0_ = NULL;
#line 338 "treeset.vala"
	if (node != NULL) {
#line 338 "treeset.vala"
		_tmp0_ = node->key;
#line 1352 "treeset.c"
	} else {
#line 338 "treeset.vala"
		_tmp0_ = NULL;
#line 1356 "treeset.c"
	}
	result = (_tmp1_ = _tmp0_, ((_tmp1_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp1_) : self->priv->g_dup_func ((gpointer) _tmp1_));
#line 338 "treeset.vala"
	return result;
#line 1361 "treeset.c"
}


/**
 * {@inheritDoc}
 */
#line 344 "treeset.vala"
static gpointer gee_tree_set_real_first (GeeSortedSet* base) {
#line 1370 "treeset.c"
	GeeTreeSet * self;
	gpointer result = NULL;
	gconstpointer _tmp0_;
	self = (GeeTreeSet*) base;
#line 345 "treeset.vala"
	g_assert (self->priv->_first != NULL);
#line 1377 "treeset.c"
	result = (_tmp0_ = self->priv->_first->key, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_));
#line 346 "treeset.vala"
	return result;
#line 1381 "treeset.c"
}


/**
 * {@inheritDoc}
 */
#line 352 "treeset.vala"
static gpointer gee_tree_set_real_last (GeeSortedSet* base) {
#line 1390 "treeset.c"
	GeeTreeSet * self;
	gpointer result = NULL;
	gconstpointer _tmp0_;
	self = (GeeTreeSet*) base;
#line 353 "treeset.vala"
	g_assert (self->priv->_last != NULL);
#line 1397 "treeset.c"
	result = (_tmp0_ = self->priv->_last->key, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_));
#line 354 "treeset.vala"
	return result;
#line 1401 "treeset.c"
}


/**
 * {@inheritDoc}
 */
#line 360 "treeset.vala"
static GeeSortedSet* gee_tree_set_real_head_set (GeeSortedSet* base, gconstpointer before) {
#line 1410 "treeset.c"
	GeeTreeSet * self;
	GeeSortedSet* result = NULL;
	self = (GeeTreeSet*) base;
	result = (GeeSortedSet*) gee_tree_set_sub_set_new_head (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self, before);
#line 361 "treeset.vala"
	return result;
#line 1417 "treeset.c"
}


/**
 * {@inheritDoc}
 */
#line 367 "treeset.vala"
static GeeSortedSet* gee_tree_set_real_tail_set (GeeSortedSet* base, gconstpointer after) {
#line 1426 "treeset.c"
	GeeTreeSet * self;
	GeeSortedSet* result = NULL;
	self = (GeeTreeSet*) base;
	result = (GeeSortedSet*) gee_tree_set_sub_set_new_tail (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self, after);
#line 368 "treeset.vala"
	return result;
#line 1433 "treeset.c"
}


/**
 * {@inheritDoc}
 */
#line 374 "treeset.vala"
static GeeSortedSet* gee_tree_set_real_sub_set (GeeSortedSet* base, gconstpointer after, gconstpointer before) {
#line 1442 "treeset.c"
	GeeTreeSet * self;
	GeeSortedSet* result = NULL;
	self = (GeeTreeSet*) base;
	result = (GeeSortedSet*) gee_tree_set_sub_set_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self, after, before);
#line 375 "treeset.vala"
	return result;
#line 1449 "treeset.c"
}


#line 378 "treeset.vala"
static inline GeeTreeSetNode* gee_tree_set_find_node (GeeTreeSet* self, gconstpointer item) {
#line 1455 "treeset.c"
	GeeTreeSetNode* result = NULL;
	GeeTreeSetNode* cur;
#line 378 "treeset.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 379 "treeset.vala"
	cur = self->priv->root;
#line 380 "treeset.vala"
	while (TRUE) {
#line 1464 "treeset.c"
		gint res;
#line 380 "treeset.vala"
		if (!(cur != NULL)) {
#line 380 "treeset.vala"
			break;
#line 1470 "treeset.c"
		}
#line 381 "treeset.vala"
		res = gee_tree_set_get_compare_func (self) (item, cur->key);
#line 382 "treeset.vala"
		if (res == 0) {
#line 1476 "treeset.c"
			result = cur;
#line 383 "treeset.vala"
			return result;
#line 1480 "treeset.c"
		} else {
#line 384 "treeset.vala"
			if (res < 0) {
#line 385 "treeset.vala"
				cur = cur->left;
#line 1486 "treeset.c"
			} else {
#line 387 "treeset.vala"
				cur = cur->right;
#line 1490 "treeset.c"
			}
		}
	}
	result = NULL;
#line 390 "treeset.vala"
	return result;
#line 1497 "treeset.c"
}


/**
 * {@inheritDoc}
 */
#line 396 "treeset.vala"
static GeeBidirIterator* gee_tree_set_real_iterator_at (GeeSortedSet* base, gconstpointer item) {
#line 1506 "treeset.c"
	GeeTreeSet * self;
	GeeBidirIterator* result = NULL;
	GeeTreeSetNode* node;
	GeeTreeSetIterator* _tmp0_;
	self = (GeeTreeSet*) base;
#line 397 "treeset.vala"
	node = gee_tree_set_find_node (self, item);
#line 1514 "treeset.c"
	_tmp0_ = NULL;
#line 398 "treeset.vala"
	if (node != NULL) {
#line 1518 "treeset.c"
		GeeTreeSetIterator* _tmp1_;
#line 398 "treeset.vala"
		_tmp0_ = (_tmp1_ = gee_tree_set_iterator_new_pointing (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self, node), _g_object_unref0 (_tmp0_), _tmp1_);
#line 1522 "treeset.c"
	} else {
		GeeTreeSetIterator* _tmp2_;
#line 398 "treeset.vala"
		_tmp0_ = (_tmp2_ = NULL, _g_object_unref0 (_tmp0_), _tmp2_);
#line 1527 "treeset.c"
	}
	result = (GeeBidirIterator*) _tmp0_;
#line 398 "treeset.vala"
	return result;
#line 1532 "treeset.c"
}


#line 401 "treeset.vala"
static inline GeeTreeSetNode* gee_tree_set_find_nearest (GeeTreeSet* self, gconstpointer item) {
#line 1538 "treeset.c"
	GeeTreeSetNode* result = NULL;
	GeeTreeSetNode* cur;
#line 401 "treeset.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 402 "treeset.vala"
	cur = self->priv->root;
#line 403 "treeset.vala"
	while (TRUE) {
#line 1547 "treeset.c"
		gint res;
#line 403 "treeset.vala"
		if (!(cur != NULL)) {
#line 403 "treeset.vala"
			break;
#line 1553 "treeset.c"
		}
#line 404 "treeset.vala"
		res = gee_tree_set_get_compare_func (self) (item, cur->key);
#line 405 "treeset.vala"
		if (res == 0) {
#line 1559 "treeset.c"
			result = cur;
#line 406 "treeset.vala"
			return result;
#line 1563 "treeset.c"
		} else {
#line 407 "treeset.vala"
			if (res < 0) {
#line 408 "treeset.vala"
				if (cur->left == NULL) {
#line 1569 "treeset.c"
					result = cur;
#line 409 "treeset.vala"
					return result;
#line 1573 "treeset.c"
				}
#line 410 "treeset.vala"
				cur = cur->left;
#line 1577 "treeset.c"
			} else {
#line 412 "treeset.vala"
				if (cur->right == NULL) {
#line 1581 "treeset.c"
					result = cur;
#line 413 "treeset.vala"
					return result;
#line 1585 "treeset.c"
				}
#line 414 "treeset.vala"
				cur = cur->right;
#line 1589 "treeset.c"
			}
		}
	}
	result = NULL;
#line 417 "treeset.vala"
	return result;
#line 1596 "treeset.c"
}


#line 420 "treeset.vala"
static inline GeeTreeSetNode* gee_tree_set_find_lower (GeeTreeSet* self, gconstpointer item) {
#line 1602 "treeset.c"
	GeeTreeSetNode* result = NULL;
	GeeTreeSetNode* node;
	GeeTreeSetNode* _tmp0_;
#line 420 "treeset.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 421 "treeset.vala"
	node = gee_tree_set_find_nearest (self, item);
#line 422 "treeset.vala"
	if (node == NULL) {
#line 1612 "treeset.c"
		result = NULL;
#line 423 "treeset.vala"
		return result;
#line 1616 "treeset.c"
	}
	_tmp0_ = NULL;
#line 424 "treeset.vala"
	if (gee_tree_set_get_compare_func (self) (item, node->key) <= 0) {
#line 424 "treeset.vala"
		_tmp0_ = node->prev;
#line 1623 "treeset.c"
	} else {
#line 424 "treeset.vala"
		_tmp0_ = node;
#line 1627 "treeset.c"
	}
	result = _tmp0_;
#line 424 "treeset.vala"
	return result;
#line 1632 "treeset.c"
}


#line 427 "treeset.vala"
static inline GeeTreeSetNode* gee_tree_set_find_higher (GeeTreeSet* self, gconstpointer item) {
#line 1638 "treeset.c"
	GeeTreeSetNode* result = NULL;
	GeeTreeSetNode* node;
	GeeTreeSetNode* _tmp0_;
#line 427 "treeset.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 428 "treeset.vala"
	node = gee_tree_set_find_nearest (self, item);
#line 429 "treeset.vala"
	if (node == NULL) {
#line 1648 "treeset.c"
		result = NULL;
#line 430 "treeset.vala"
		return result;
#line 1652 "treeset.c"
	}
	_tmp0_ = NULL;
#line 431 "treeset.vala"
	if (gee_tree_set_get_compare_func (self) (item, node->key) >= 0) {
#line 431 "treeset.vala"
		_tmp0_ = node->next;
#line 1659 "treeset.c"
	} else {
#line 431 "treeset.vala"
		_tmp0_ = node;
#line 1663 "treeset.c"
	}
	result = _tmp0_;
#line 431 "treeset.vala"
	return result;
#line 1668 "treeset.c"
}


#line 434 "treeset.vala"
static inline GeeTreeSetNode* gee_tree_set_find_floor (GeeTreeSet* self, gconstpointer item) {
#line 1674 "treeset.c"
	GeeTreeSetNode* result = NULL;
	GeeTreeSetNode* node;
	GeeTreeSetNode* _tmp0_;
#line 434 "treeset.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 435 "treeset.vala"
	node = gee_tree_set_find_nearest (self, item);
#line 436 "treeset.vala"
	if (node == NULL) {
#line 1684 "treeset.c"
		result = NULL;
#line 437 "treeset.vala"
		return result;
#line 1688 "treeset.c"
	}
	_tmp0_ = NULL;
#line 438 "treeset.vala"
	if (gee_tree_set_get_compare_func (self) (item, node->key) < 0) {
#line 438 "treeset.vala"
		_tmp0_ = node->prev;
#line 1695 "treeset.c"
	} else {
#line 438 "treeset.vala"
		_tmp0_ = node;
#line 1699 "treeset.c"
	}
	result = _tmp0_;
#line 438 "treeset.vala"
	return result;
#line 1704 "treeset.c"
}


#line 441 "treeset.vala"
static inline GeeTreeSetNode* gee_tree_set_find_ceil (GeeTreeSet* self, gconstpointer item) {
#line 1710 "treeset.c"
	GeeTreeSetNode* result = NULL;
	GeeTreeSetNode* node;
	GeeTreeSetNode* _tmp0_;
#line 441 "treeset.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 442 "treeset.vala"
	node = gee_tree_set_find_nearest (self, item);
#line 443 "treeset.vala"
	if (node == NULL) {
#line 1720 "treeset.c"
		result = NULL;
#line 444 "treeset.vala"
		return result;
#line 1724 "treeset.c"
	}
	_tmp0_ = NULL;
#line 445 "treeset.vala"
	if (gee_tree_set_get_compare_func (self) (item, node->key) > 0) {
#line 445 "treeset.vala"
		_tmp0_ = node->next;
#line 1731 "treeset.c"
	} else {
#line 445 "treeset.vala"
		_tmp0_ = node;
#line 1735 "treeset.c"
	}
	result = _tmp0_;
#line 445 "treeset.vala"
	return result;
#line 1740 "treeset.c"
}


/**
 * {@inheritDoc}
 */
#line 451 "treeset.vala"
static gpointer gee_tree_set_real_lower (GeeSortedSet* base, gconstpointer item) {
#line 1749 "treeset.c"
	GeeTreeSet * self;
	gpointer result = NULL;
	self = (GeeTreeSet*) base;
	result = gee_tree_set_lift_null_get (self, gee_tree_set_find_lower (self, item));
#line 452 "treeset.vala"
	return result;
#line 1756 "treeset.c"
}


/**
 * {@inheritDoc}
 */
#line 458 "treeset.vala"
static gpointer gee_tree_set_real_higher (GeeSortedSet* base, gconstpointer item) {
#line 1765 "treeset.c"
	GeeTreeSet * self;
	gpointer result = NULL;
	self = (GeeTreeSet*) base;
	result = gee_tree_set_lift_null_get (self, gee_tree_set_find_higher (self, item));
#line 459 "treeset.vala"
	return result;
#line 1772 "treeset.c"
}


/**
 * {@inheritDoc}
 */
#line 465 "treeset.vala"
static gpointer gee_tree_set_real_floor (GeeSortedSet* base, gconstpointer item) {
#line 1781 "treeset.c"
	GeeTreeSet * self;
	gpointer result = NULL;
	self = (GeeTreeSet*) base;
	result = gee_tree_set_lift_null_get (self, gee_tree_set_find_floor (self, item));
#line 466 "treeset.vala"
	return result;
#line 1788 "treeset.c"
}


/**
 * {@inheritDoc}
 */
#line 472 "treeset.vala"
static gpointer gee_tree_set_real_ceil (GeeSortedSet* base, gconstpointer item) {
#line 1797 "treeset.c"
	GeeTreeSet * self;
	gpointer result = NULL;
	self = (GeeTreeSet*) base;
	result = gee_tree_set_lift_null_get (self, gee_tree_set_find_ceil (self, item));
#line 473 "treeset.vala"
	return result;
#line 1804 "treeset.c"
}


#line 694 "treeset.vala"
static inline gpointer gee_tree_set_min (GeeTreeSet* self, gconstpointer a, gconstpointer b) {
#line 1810 "treeset.c"
	gpointer result = NULL;
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
#line 694 "treeset.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1816 "treeset.c"
	_tmp0_ = NULL;
#line 695 "treeset.vala"
	if (gee_tree_set_get_compare_func (self) (a, b) <= 0) {
#line 695 "treeset.vala"
		_tmp0_ = a;
#line 1822 "treeset.c"
	} else {
#line 695 "treeset.vala"
		_tmp0_ = b;
#line 1826 "treeset.c"
	}
	result = (_tmp1_ = _tmp0_, ((_tmp1_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp1_) : self->priv->g_dup_func ((gpointer) _tmp1_));
#line 695 "treeset.vala"
	return result;
#line 1831 "treeset.c"
}


#line 698 "treeset.vala"
static inline gpointer gee_tree_set_max (GeeTreeSet* self, gconstpointer a, gconstpointer b) {
#line 1837 "treeset.c"
	gpointer result = NULL;
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
#line 698 "treeset.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1843 "treeset.c"
	_tmp0_ = NULL;
#line 699 "treeset.vala"
	if (gee_tree_set_get_compare_func (self) (a, b) > 0) {
#line 699 "treeset.vala"
		_tmp0_ = a;
#line 1849 "treeset.c"
	} else {
#line 699 "treeset.vala"
		_tmp0_ = b;
#line 1853 "treeset.c"
	}
	result = (_tmp1_ = _tmp0_, ((_tmp1_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp1_) : self->priv->g_dup_func ((gpointer) _tmp1_));
#line 699 "treeset.vala"
	return result;
#line 1858 "treeset.c"
}


static gint gee_tree_set_real_get_size (GeeAbstractCollection* base) {
	gint result;
	GeeTreeSet* self;
	self = (GeeTreeSet*) base;
	result = self->priv->_size;
#line 40 "treeset.vala"
	return result;
#line 1869 "treeset.c"
}


GCompareFunc gee_tree_set_get_compare_func (GeeTreeSet* self) {
	GCompareFunc result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_compare_func;
#line 46 "treeset.vala"
	return result;
#line 1879 "treeset.c"
}


static void gee_tree_set_set_compare_func (GeeTreeSet* self, GCompareFunc value) {
	g_return_if_fail (self != NULL);
	self->priv->_compare_func = value;
	g_object_notify ((GObject *) self, "compare-func");
}


#line 518 "treeset.vala"
static GeeTreeSetNodeColor gee_tree_set_node_color_flip (GeeTreeSetNodeColor self) {
#line 1892 "treeset.c"
	GeeTreeSetNodeColor result = 0;
#line 519 "treeset.vala"
	if (self == GEE_TREE_SET_NODE_COLOR_RED) {
#line 1896 "treeset.c"
		result = GEE_TREE_SET_NODE_COLOR_BLACK;
#line 520 "treeset.vala"
		return result;
#line 1900 "treeset.c"
	} else {
		result = GEE_TREE_SET_NODE_COLOR_RED;
#line 522 "treeset.vala"
		return result;
#line 1905 "treeset.c"
	}
}


GType gee_tree_set_node_color_get_type (void) {
	static volatile gsize gee_tree_set_node_color_type_id__volatile = 0;
	if (g_once_init_enter (&gee_tree_set_node_color_type_id__volatile)) {
		static const GEnumValue values[] = {{GEE_TREE_SET_NODE_COLOR_RED, "GEE_TREE_SET_NODE_COLOR_RED", "red"}, {GEE_TREE_SET_NODE_COLOR_BLACK, "GEE_TREE_SET_NODE_COLOR_BLACK", "black"}, {0, NULL, NULL}};
		GType gee_tree_set_node_color_type_id;
		gee_tree_set_node_color_type_id = g_enum_register_static ("GeeTreeSetNodeColor", values);
		g_once_init_leave (&gee_tree_set_node_color_type_id__volatile, gee_tree_set_node_color_type_id);
	}
	return gee_tree_set_node_color_type_id__volatile;
}


#line 527 "treeset.vala"
static GeeTreeSetNode* gee_tree_set_node_new (gpointer node, GeeTreeSetNode* prev, GeeTreeSetNode* next) {
#line 1924 "treeset.c"
	GeeTreeSetNode* self;
	gpointer _tmp0_;
	self = g_slice_new0 (GeeTreeSetNode);
	gee_tree_set_node_instance_init (self);
#line 528 "treeset.vala"
	self->key = (_tmp0_ = node, node = NULL, _tmp0_);
#line 529 "treeset.vala"
	self->color = GEE_TREE_SET_NODE_COLOR_RED;
#line 530 "treeset.vala"
	self->prev = prev;
#line 531 "treeset.vala"
	self->next = next;
#line 532 "treeset.vala"
	if (prev != NULL) {
#line 533 "treeset.vala"
		prev->next = self;
#line 1941 "treeset.c"
	}
#line 535 "treeset.vala"
	if (next != NULL) {
#line 536 "treeset.vala"
		next->prev = self;
#line 1947 "treeset.c"
	}
	return self;
}


#line 540 "treeset.vala"
static void gee_tree_set_node_flip (GeeTreeSetNode* self) {
#line 540 "treeset.vala"
	g_return_if_fail (self != NULL);
#line 541 "treeset.vala"
	self->color = gee_tree_set_node_color_flip (self->color);
#line 542 "treeset.vala"
	if (self->left != NULL) {
#line 543 "treeset.vala"
		self->left->color = gee_tree_set_node_color_flip (self->left->color);
#line 1963 "treeset.c"
	}
#line 545 "treeset.vala"
	if (self->right != NULL) {
#line 546 "treeset.vala"
		self->right->color = gee_tree_set_node_color_flip (self->right->color);
#line 1969 "treeset.c"
	}
}


static void gee_tree_set_node_instance_init (GeeTreeSetNode * self) {
}


static void gee_tree_set_node_free (GeeTreeSetNode* self) {
	_gee_tree_set_node_free0 (self->left);
	_gee_tree_set_node_free0 (self->right);
	g_slice_free (GeeTreeSetNode, self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 564 "treeset.vala"
static GeeTreeSetIterator* gee_tree_set_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set) {
#line 1992 "treeset.c"
	GeeTreeSetIterator * self;
	GeeTreeSet* _tmp0_;
#line 564 "treeset.vala"
	g_return_val_if_fail (set != NULL, NULL);
#line 564 "treeset.vala"
	self = (GeeTreeSetIterator*) g_object_new (object_type, NULL);
#line 564 "treeset.vala"
	self->priv->g_type = g_type;
#line 564 "treeset.vala"
	self->priv->g_dup_func = g_dup_func;
#line 564 "treeset.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 565 "treeset.vala"
	self->priv->_set = (_tmp0_ = _g_object_ref0 (set), _g_object_unref0 (self->priv->_set), _tmp0_);
#line 566 "treeset.vala"
	self->priv->stamp = self->priv->_set->priv->stamp;
#line 2009 "treeset.c"
	return self;
}


#line 564 "treeset.vala"
static GeeTreeSetIterator* gee_tree_set_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set) {
#line 564 "treeset.vala"
	return gee_tree_set_iterator_construct (GEE_TREE_SET_TYPE_ITERATOR, g_type, g_dup_func, g_destroy_func, set);
#line 2018 "treeset.c"
}


#line 569 "treeset.vala"
static GeeTreeSetIterator* gee_tree_set_iterator_construct_pointing (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetNode* current) {
#line 2024 "treeset.c"
	GeeTreeSetIterator * self;
	GeeTreeSet* _tmp0_;
#line 569 "treeset.vala"
	g_return_val_if_fail (set != NULL, NULL);
#line 569 "treeset.vala"
	g_return_val_if_fail (current != NULL, NULL);
#line 569 "treeset.vala"
	self = (GeeTreeSetIterator*) g_object_new (object_type, NULL);
#line 569 "treeset.vala"
	self->priv->g_type = g_type;
#line 569 "treeset.vala"
	self->priv->g_dup_func = g_dup_func;
#line 569 "treeset.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 570 "treeset.vala"
	self->priv->_set = (_tmp0_ = _g_object_ref0 (set), _g_object_unref0 (self->priv->_set), _tmp0_);
#line 571 "treeset.vala"
	self->priv->current = current;
#line 572 "treeset.vala"
	self->priv->stamp = set->priv->stamp;
#line 573 "treeset.vala"
	self->priv->started = TRUE;
#line 2047 "treeset.c"
	return self;
}


#line 569 "treeset.vala"
static GeeTreeSetIterator* gee_tree_set_iterator_new_pointing (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetNode* current) {
#line 569 "treeset.vala"
	return gee_tree_set_iterator_construct_pointing (GEE_TREE_SET_TYPE_ITERATOR, g_type, g_dup_func, g_destroy_func, set, current);
#line 2056 "treeset.c"
}


#line 576 "treeset.vala"
static gboolean gee_tree_set_iterator_real_next (GeeIterator* base) {
#line 2062 "treeset.c"
	GeeTreeSetIterator * self;
	gboolean result = FALSE;
	self = (GeeTreeSetIterator*) base;
#line 577 "treeset.vala"
	g_assert (self->priv->stamp == self->priv->_set->priv->stamp);
#line 578 "treeset.vala"
	if (self->priv->current != NULL) {
#line 579 "treeset.vala"
		if (self->priv->current->next != NULL) {
#line 580 "treeset.vala"
			self->priv->current = self->priv->current->next;
#line 2074 "treeset.c"
			result = TRUE;
#line 581 "treeset.vala"
			return result;
#line 2078 "treeset.c"
		} else {
			result = FALSE;
#line 583 "treeset.vala"
			return result;
#line 2083 "treeset.c"
		}
	} else {
#line 585 "treeset.vala"
		if (!self->priv->started) {
#line 586 "treeset.vala"
			self->priv->current = self->priv->_set->priv->_first;
#line 587 "treeset.vala"
			self->priv->started = TRUE;
#line 2092 "treeset.c"
			result = self->priv->current != NULL;
#line 588 "treeset.vala"
			return result;
#line 2096 "treeset.c"
		} else {
#line 590 "treeset.vala"
			self->priv->current = self->priv->_next;
#line 591 "treeset.vala"
			if (self->priv->current != NULL) {
#line 592 "treeset.vala"
				self->priv->_next = NULL;
#line 593 "treeset.vala"
				self->priv->_prev = NULL;
#line 2106 "treeset.c"
			}
			result = self->priv->current != NULL;
#line 595 "treeset.vala"
			return result;
#line 2111 "treeset.c"
		}
	}
}


#line 599 "treeset.vala"
static gboolean gee_tree_set_iterator_real_has_next (GeeIterator* base) {
#line 2119 "treeset.c"
	GeeTreeSetIterator * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	self = (GeeTreeSetIterator*) base;
#line 600 "treeset.vala"
	g_assert (self->priv->stamp == self->priv->_set->priv->stamp);
#line 601 "treeset.vala"
	if (!self->priv->started) {
#line 601 "treeset.vala"
		_tmp2_ = self->priv->_set->priv->_first != NULL;
#line 2132 "treeset.c"
	} else {
#line 601 "treeset.vala"
		_tmp2_ = FALSE;
#line 2136 "treeset.c"
	}
#line 601 "treeset.vala"
	if (_tmp2_) {
#line 601 "treeset.vala"
		_tmp1_ = TRUE;
#line 2142 "treeset.c"
	} else {
		gboolean _tmp3_ = FALSE;
#line 602 "treeset.vala"
		if (self->priv->current == NULL) {
#line 602 "treeset.vala"
			_tmp3_ = self->priv->_next != NULL;
#line 2149 "treeset.c"
		} else {
#line 602 "treeset.vala"
			_tmp3_ = FALSE;
#line 2153 "treeset.c"
		}
#line 602 "treeset.vala"
		_tmp1_ = _tmp3_;
#line 2157 "treeset.c"
	}
#line 601 "treeset.vala"
	if (_tmp1_) {
#line 601 "treeset.vala"
		_tmp0_ = TRUE;
#line 2163 "treeset.c"
	} else {
		gboolean _tmp4_ = FALSE;
#line 603 "treeset.vala"
		if (self->priv->current != NULL) {
#line 603 "treeset.vala"
			_tmp4_ = self->priv->current->next != NULL;
#line 2170 "treeset.c"
		} else {
#line 603 "treeset.vala"
			_tmp4_ = FALSE;
#line 2174 "treeset.c"
		}
#line 603 "treeset.vala"
		_tmp0_ = _tmp4_;
#line 2178 "treeset.c"
	}
	result = _tmp0_;
#line 601 "treeset.vala"
	return result;
#line 2183 "treeset.c"
}


#line 606 "treeset.vala"
static gboolean gee_tree_set_iterator_real_first (GeeIterator* base) {
#line 2189 "treeset.c"
	GeeTreeSetIterator * self;
	gboolean result = FALSE;
	self = (GeeTreeSetIterator*) base;
#line 607 "treeset.vala"
	g_assert (self->priv->stamp == self->priv->_set->priv->stamp);
#line 608 "treeset.vala"
	self->priv->current = self->priv->_set->priv->_first;
#line 609 "treeset.vala"
	self->priv->_next = NULL;
#line 610 "treeset.vala"
	self->priv->_prev = NULL;
#line 611 "treeset.vala"
	self->priv->started = TRUE;
#line 2203 "treeset.c"
	result = self->priv->current != NULL;
#line 612 "treeset.vala"
	return result;
#line 2207 "treeset.c"
}


#line 615 "treeset.vala"
static gboolean gee_tree_set_iterator_real_previous (GeeBidirIterator* base) {
#line 2213 "treeset.c"
	GeeTreeSetIterator * self;
	gboolean result = FALSE;
	self = (GeeTreeSetIterator*) base;
#line 616 "treeset.vala"
	g_assert (self->priv->stamp == self->priv->_set->priv->stamp);
#line 617 "treeset.vala"
	if (self->priv->current != NULL) {
#line 618 "treeset.vala"
		if (self->priv->current->prev != NULL) {
#line 619 "treeset.vala"
			self->priv->current = self->priv->current->prev;
#line 2225 "treeset.c"
			result = TRUE;
#line 620 "treeset.vala"
			return result;
#line 2229 "treeset.c"
		} else {
			result = FALSE;
#line 622 "treeset.vala"
			return result;
#line 2234 "treeset.c"
		}
	} else {
#line 625 "treeset.vala"
		if (self->priv->_prev != NULL) {
#line 626 "treeset.vala"
			self->priv->current = self->priv->_prev;
#line 627 "treeset.vala"
			self->priv->_next = NULL;
#line 628 "treeset.vala"
			self->priv->_prev = NULL;
#line 2245 "treeset.c"
			result = TRUE;
#line 629 "treeset.vala"
			return result;
#line 2249 "treeset.c"
		} else {
			result = FALSE;
#line 631 "treeset.vala"
			return result;
#line 2254 "treeset.c"
		}
	}
}


#line 636 "treeset.vala"
static gboolean gee_tree_set_iterator_real_has_previous (GeeBidirIterator* base) {
#line 2262 "treeset.c"
	GeeTreeSetIterator * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	self = (GeeTreeSetIterator*) base;
#line 637 "treeset.vala"
	g_assert (self->priv->stamp == self->priv->_set->priv->stamp);
#line 638 "treeset.vala"
	if (self->priv->current == NULL) {
#line 638 "treeset.vala"
		_tmp1_ = self->priv->_prev != NULL;
#line 2274 "treeset.c"
	} else {
#line 638 "treeset.vala"
		_tmp1_ = FALSE;
#line 2278 "treeset.c"
	}
#line 638 "treeset.vala"
	if (_tmp1_) {
#line 638 "treeset.vala"
		_tmp0_ = TRUE;
#line 2284 "treeset.c"
	} else {
		gboolean _tmp2_ = FALSE;
#line 639 "treeset.vala"
		if (self->priv->current != NULL) {
#line 639 "treeset.vala"
			_tmp2_ = self->priv->current->prev != NULL;
#line 2291 "treeset.c"
		} else {
#line 639 "treeset.vala"
			_tmp2_ = FALSE;
#line 2295 "treeset.c"
		}
#line 639 "treeset.vala"
		_tmp0_ = _tmp2_;
#line 2299 "treeset.c"
	}
	result = _tmp0_;
#line 638 "treeset.vala"
	return result;
#line 2304 "treeset.c"
}


#line 642 "treeset.vala"
static gboolean gee_tree_set_iterator_real_last (GeeBidirIterator* base) {
#line 2310 "treeset.c"
	GeeTreeSetIterator * self;
	gboolean result = FALSE;
	self = (GeeTreeSetIterator*) base;
#line 643 "treeset.vala"
	g_assert (self->priv->stamp == self->priv->_set->priv->stamp);
#line 644 "treeset.vala"
	self->priv->current = self->priv->_set->priv->_last;
#line 645 "treeset.vala"
	self->priv->_next = NULL;
#line 646 "treeset.vala"
	self->priv->_prev = NULL;
#line 647 "treeset.vala"
	self->priv->started = TRUE;
#line 2324 "treeset.c"
	result = self->priv->current != NULL;
#line 648 "treeset.vala"
	return result;
#line 2328 "treeset.c"
}


#line 651 "treeset.vala"
static gpointer gee_tree_set_iterator_real_get (GeeIterator* base) {
#line 2334 "treeset.c"
	GeeTreeSetIterator * self;
	gpointer result = NULL;
	gconstpointer _tmp0_;
	self = (GeeTreeSetIterator*) base;
#line 652 "treeset.vala"
	g_assert (self->priv->stamp == self->priv->_set->priv->stamp);
#line 653 "treeset.vala"
	g_assert (self->priv->current != NULL);
#line 2343 "treeset.c"
	result = (_tmp0_ = self->priv->current->key, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_));
#line 654 "treeset.vala"
	return result;
#line 2347 "treeset.c"
}


#line 657 "treeset.vala"
static void gee_tree_set_iterator_real_remove (GeeIterator* base) {
#line 2353 "treeset.c"
	GeeTreeSetIterator * self;
	gboolean success;
	self = (GeeTreeSetIterator*) base;
#line 658 "treeset.vala"
	g_assert (self->priv->stamp == self->priv->_set->priv->stamp);
#line 659 "treeset.vala"
	g_assert (self->priv->current != NULL);
#line 660 "treeset.vala"
	success = gee_tree_set_remove_from_node (self->priv->_set, &self->priv->_set->priv->root, self->priv->current->key, &self->priv->_prev, &self->priv->_next);
#line 661 "treeset.vala"
	g_assert (success);
#line 662 "treeset.vala"
	if (self->priv->_set->priv->root != NULL) {
#line 663 "treeset.vala"
		self->priv->_set->priv->root->color = GEE_TREE_SET_NODE_COLOR_BLACK;
#line 2369 "treeset.c"
	}
#line 664 "treeset.vala"
	self->priv->current = NULL;
#line 665 "treeset.vala"
	g_assert ((self->priv->stamp++) == (self->priv->_set->priv->stamp++));
#line 2375 "treeset.c"
}


#line 668 "treeset.vala"
static gboolean gee_tree_set_iterator_safe_next_get (GeeTreeSetIterator* self, gpointer* val) {
#line 2381 "treeset.c"
	gboolean result = FALSE;
#line 668 "treeset.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 669 "treeset.vala"
	if (self->priv->current != NULL) {
#line 2387 "treeset.c"
		gpointer _tmp0_;
#line 670 "treeset.vala"
		*val = (_tmp0_ = gee_tree_set_lift_null_get (self->priv->_set, self->priv->current->next), (((*val) == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (*val = (self->priv->g_destroy_func (*val), NULL)), _tmp0_);
#line 2391 "treeset.c"
		result = self->priv->current->next != NULL;
#line 671 "treeset.vala"
		return result;
#line 2395 "treeset.c"
	} else {
		gpointer _tmp1_;
#line 673 "treeset.vala"
		*val = (_tmp1_ = gee_tree_set_lift_null_get (self->priv->_set, self->priv->_next), (((*val) == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (*val = (self->priv->g_destroy_func (*val), NULL)), _tmp1_);
#line 2400 "treeset.c"
		result = self->priv->_next != NULL;
#line 674 "treeset.vala"
		return result;
#line 2404 "treeset.c"
	}
}


#line 678 "treeset.vala"
static gboolean gee_tree_set_iterator_safe_previous_get (GeeTreeSetIterator* self, gpointer* val) {
#line 2411 "treeset.c"
	gboolean result = FALSE;
#line 678 "treeset.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 679 "treeset.vala"
	if (self->priv->current != NULL) {
#line 2417 "treeset.c"
		gpointer _tmp0_;
#line 680 "treeset.vala"
		*val = (_tmp0_ = gee_tree_set_lift_null_get (self->priv->_set, self->priv->current->prev), (((*val) == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (*val = (self->priv->g_destroy_func (*val), NULL)), _tmp0_);
#line 2421 "treeset.c"
		result = self->priv->current->prev != NULL;
#line 681 "treeset.vala"
		return result;
#line 2425 "treeset.c"
	} else {
		gpointer _tmp1_;
#line 683 "treeset.vala"
		*val = (_tmp1_ = gee_tree_set_lift_null_get (self->priv->_set, self->priv->_prev), (((*val) == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (*val = (self->priv->g_destroy_func (*val), NULL)), _tmp1_);
#line 2430 "treeset.c"
		result = self->priv->_next != NULL;
#line 684 "treeset.vala"
		return result;
#line 2434 "treeset.c"
	}
}


static void gee_tree_set_iterator_class_init (GeeTreeSetIteratorClass * klass) {
	gee_tree_set_iterator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeTreeSetIteratorPrivate));
	G_OBJECT_CLASS (klass)->get_property = gee_tree_set_iterator_get_property;
	G_OBJECT_CLASS (klass)->set_property = gee_tree_set_iterator_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_tree_set_iterator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_ITERATOR_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_ITERATOR_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_ITERATOR_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void gee_tree_set_iterator_gee_iterator_interface_init (GeeIteratorIface * iface) {
	gee_tree_set_iterator_gee_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = gee_tree_set_iterator_real_next;
	iface->has_next = gee_tree_set_iterator_real_has_next;
	iface->first = gee_tree_set_iterator_real_first;
	iface->get = gee_tree_set_iterator_real_get;
	iface->remove = gee_tree_set_iterator_real_remove;
}


static void gee_tree_set_iterator_gee_bidir_iterator_interface_init (GeeBidirIteratorIface * iface) {
	gee_tree_set_iterator_gee_bidir_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->previous = gee_tree_set_iterator_real_previous;
	iface->has_previous = gee_tree_set_iterator_real_has_previous;
	iface->last = gee_tree_set_iterator_real_last;
}


static void gee_tree_set_iterator_instance_init (GeeTreeSetIterator * self) {
	self->priv = GEE_TREE_SET_ITERATOR_GET_PRIVATE (self);
	self->priv->current = NULL;
	self->priv->_next = NULL;
	self->priv->_prev = NULL;
	self->priv->started = FALSE;
}


static void gee_tree_set_iterator_finalize (GObject* obj) {
	GeeTreeSetIterator * self;
	self = GEE_TREE_SET_ITERATOR (obj);
	_g_object_unref0 (self->priv->_set);
	G_OBJECT_CLASS (gee_tree_set_iterator_parent_class)->finalize (obj);
}


static GType gee_tree_set_iterator_get_type (void) {
	static volatile gsize gee_tree_set_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&gee_tree_set_iterator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeTreeSetIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_tree_set_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeTreeSetIterator), 0, (GInstanceInitFunc) gee_tree_set_iterator_instance_init, NULL };
		static const GInterfaceInfo gee_iterator_info = { (GInterfaceInitFunc) gee_tree_set_iterator_gee_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_bidir_iterator_info = { (GInterfaceInitFunc) gee_tree_set_iterator_gee_bidir_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_tree_set_iterator_type_id;
		gee_tree_set_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeTreeSetIterator", &g_define_type_info, 0);
		g_type_add_interface_static (gee_tree_set_iterator_type_id, GEE_TYPE_ITERATOR, &gee_iterator_info);
		g_type_add_interface_static (gee_tree_set_iterator_type_id, GEE_TYPE_BIDIR_ITERATOR, &gee_bidir_iterator_info);
		g_once_init_leave (&gee_tree_set_iterator_type_id__volatile, gee_tree_set_iterator_type_id);
	}
	return gee_tree_set_iterator_type_id__volatile;
}


static void gee_tree_set_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeTreeSetIterator * self;
	self = GEE_TREE_SET_ITERATOR (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_tree_set_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeTreeSetIterator * self;
	self = GEE_TREE_SET_ITERATOR (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_TREE_SET_ITERATOR_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_TREE_SET_ITERATOR_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_TREE_SET_ITERATOR_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
	}
}


#line 844 "treeset.vala"
static GeeTreeSetSubSet* gee_tree_set_sub_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer after, gconstpointer before) {
#line 2535 "treeset.c"
	GeeTreeSetSubSet * self;
	GeeTreeSet* _tmp0_;
	GeeTreeSetRange _tmp2_;
	GeeTreeSetRange _tmp1_ = {0};
#line 844 "treeset.vala"
	g_return_val_if_fail (set != NULL, NULL);
#line 844 "treeset.vala"
	self = (GeeTreeSetSubSet*) gee_abstract_set_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
#line 844 "treeset.vala"
	self->priv->g_type = g_type;
#line 844 "treeset.vala"
	self->priv->g_dup_func = g_dup_func;
#line 844 "treeset.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 845 "treeset.vala"
	self->priv->set = (_tmp0_ = _g_object_ref0 (set), _g_object_unref0 (self->priv->set), _tmp0_);
#line 846 "treeset.vala"
	self->priv->range = (_tmp2_ = (gee_tree_set_range_init (&_tmp1_, set, after, before), _tmp1_), gee_tree_set_range_destroy (&self->priv->range), _tmp2_);
#line 2554 "treeset.c"
	return self;
}


#line 844 "treeset.vala"
static GeeTreeSetSubSet* gee_tree_set_sub_set_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer after, gconstpointer before) {
#line 844 "treeset.vala"
	return gee_tree_set_sub_set_construct (GEE_TREE_SET_TYPE_SUB_SET, g_type, g_dup_func, g_destroy_func, set, after, before);
#line 2563 "treeset.c"
}


#line 849 "treeset.vala"
static GeeTreeSetSubSet* gee_tree_set_sub_set_construct_head (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer before) {
#line 2569 "treeset.c"
	GeeTreeSetSubSet * self;
	GeeTreeSet* _tmp0_;
	GeeTreeSetRange _tmp2_;
	GeeTreeSetRange _tmp1_ = {0};
#line 849 "treeset.vala"
	g_return_val_if_fail (set != NULL, NULL);
#line 849 "treeset.vala"
	self = (GeeTreeSetSubSet*) gee_abstract_set_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
#line 849 "treeset.vala"
	self->priv->g_type = g_type;
#line 849 "treeset.vala"
	self->priv->g_dup_func = g_dup_func;
#line 849 "treeset.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 850 "treeset.vala"
	self->priv->set = (_tmp0_ = _g_object_ref0 (set), _g_object_unref0 (self->priv->set), _tmp0_);
#line 851 "treeset.vala"
	self->priv->range = (_tmp2_ = (gee_tree_set_range_init_head (&_tmp1_, set, before), _tmp1_), gee_tree_set_range_destroy (&self->priv->range), _tmp2_);
#line 2588 "treeset.c"
	return self;
}


#line 849 "treeset.vala"
static GeeTreeSetSubSet* gee_tree_set_sub_set_new_head (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer before) {
#line 849 "treeset.vala"
	return gee_tree_set_sub_set_construct_head (GEE_TREE_SET_TYPE_SUB_SET, g_type, g_dup_func, g_destroy_func, set, before);
#line 2597 "treeset.c"
}


#line 854 "treeset.vala"
static GeeTreeSetSubSet* gee_tree_set_sub_set_construct_tail (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer after) {
#line 2603 "treeset.c"
	GeeTreeSetSubSet * self;
	GeeTreeSet* _tmp0_;
	GeeTreeSetRange _tmp2_;
	GeeTreeSetRange _tmp1_ = {0};
#line 854 "treeset.vala"
	g_return_val_if_fail (set != NULL, NULL);
#line 854 "treeset.vala"
	self = (GeeTreeSetSubSet*) gee_abstract_set_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
#line 854 "treeset.vala"
	self->priv->g_type = g_type;
#line 854 "treeset.vala"
	self->priv->g_dup_func = g_dup_func;
#line 854 "treeset.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 855 "treeset.vala"
	self->priv->set = (_tmp0_ = _g_object_ref0 (set), _g_object_unref0 (self->priv->set), _tmp0_);
#line 856 "treeset.vala"
	self->priv->range = (_tmp2_ = (gee_tree_set_range_init_tail (&_tmp1_, set, after), _tmp1_), gee_tree_set_range_destroy (&self->priv->range), _tmp2_);
#line 2622 "treeset.c"
	return self;
}


#line 854 "treeset.vala"
static GeeTreeSetSubSet* gee_tree_set_sub_set_new_tail (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer after) {
#line 854 "treeset.vala"
	return gee_tree_set_sub_set_construct_tail (GEE_TREE_SET_TYPE_SUB_SET, g_type, g_dup_func, g_destroy_func, set, after);
#line 2631 "treeset.c"
}


#line 859 "treeset.vala"
static GeeTreeSetSubSet* gee_tree_set_sub_set_construct_from_range (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetRange* range) {
#line 2637 "treeset.c"
	GeeTreeSetSubSet * self;
	GeeTreeSet* _tmp0_;
	GeeTreeSetRange _tmp2_;
	GeeTreeSetRange _tmp1_ = {0};
#line 859 "treeset.vala"
	g_return_val_if_fail (set != NULL, NULL);
#line 859 "treeset.vala"
	self = (GeeTreeSetSubSet*) gee_abstract_set_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
#line 859 "treeset.vala"
	self->priv->g_type = g_type;
#line 859 "treeset.vala"
	self->priv->g_dup_func = g_dup_func;
#line 859 "treeset.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 860 "treeset.vala"
	self->priv->set = (_tmp0_ = _g_object_ref0 (set), _g_object_unref0 (self->priv->set), _tmp0_);
#line 861 "treeset.vala"
	self->priv->range = (_tmp2_ = (gee_tree_set_range_copy (range, &_tmp1_), _tmp1_), gee_tree_set_range_destroy (&self->priv->range), _tmp2_);
#line 2656 "treeset.c"
	return self;
}


#line 859 "treeset.vala"
static GeeTreeSetSubSet* gee_tree_set_sub_set_new_from_range (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetRange* range) {
#line 859 "treeset.vala"
	return gee_tree_set_sub_set_construct_from_range (GEE_TREE_SET_TYPE_SUB_SET, g_type, g_dup_func, g_destroy_func, set, range);
#line 2665 "treeset.c"
}


#line 880 "treeset.vala"
static gboolean gee_tree_set_sub_set_real_contains (GeeAbstractCollection* base, gconstpointer item) {
#line 2671 "treeset.c"
	GeeTreeSetSubSet * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	self = (GeeTreeSetSubSet*) base;
#line 881 "treeset.vala"
	if (gee_tree_set_range_in_range (&self->priv->range, item)) {
#line 881 "treeset.vala"
		_tmp0_ = gee_abstract_collection_contains ((GeeAbstractCollection*) self->priv->set, item);
#line 2680 "treeset.c"
	} else {
#line 881 "treeset.vala"
		_tmp0_ = FALSE;
#line 2684 "treeset.c"
	}
	result = _tmp0_;
#line 881 "treeset.vala"
	return result;
#line 2689 "treeset.c"
}


#line 884 "treeset.vala"
static gboolean gee_tree_set_sub_set_real_add (GeeAbstractCollection* base, gconstpointer item) {
#line 2695 "treeset.c"
	GeeTreeSetSubSet * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	self = (GeeTreeSetSubSet*) base;
#line 885 "treeset.vala"
	if (gee_tree_set_range_in_range (&self->priv->range, item)) {
#line 885 "treeset.vala"
		_tmp0_ = gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->set, item);
#line 2704 "treeset.c"
	} else {
#line 885 "treeset.vala"
		_tmp0_ = FALSE;
#line 2708 "treeset.c"
	}
	result = _tmp0_;
#line 885 "treeset.vala"
	return result;
#line 2713 "treeset.c"
}


#line 888 "treeset.vala"
static gboolean gee_tree_set_sub_set_real_remove (GeeAbstractCollection* base, gconstpointer item) {
#line 2719 "treeset.c"
	GeeTreeSetSubSet * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	self = (GeeTreeSetSubSet*) base;
#line 889 "treeset.vala"
	if (gee_tree_set_range_in_range (&self->priv->range, item)) {
#line 889 "treeset.vala"
		_tmp0_ = gee_abstract_collection_remove ((GeeAbstractCollection*) self->priv->set, item);
#line 2728 "treeset.c"
	} else {
#line 889 "treeset.vala"
		_tmp0_ = FALSE;
#line 2732 "treeset.c"
	}
	result = _tmp0_;
#line 889 "treeset.vala"
	return result;
#line 2737 "treeset.c"
}


#line 892 "treeset.vala"
static void gee_tree_set_sub_set_real_clear (GeeAbstractCollection* base) {
#line 2743 "treeset.c"
	GeeTreeSetSubSet * self;
	GeeIterator* iter;
	self = (GeeTreeSetSubSet*) base;
#line 893 "treeset.vala"
	iter = gee_abstract_collection_iterator ((GeeAbstractCollection*) self);
#line 894 "treeset.vala"
	while (TRUE) {
#line 894 "treeset.vala"
		if (!gee_iterator_next (iter)) {
#line 894 "treeset.vala"
			break;
#line 2755 "treeset.c"
		}
#line 895 "treeset.vala"
		gee_iterator_remove (iter);
#line 2759 "treeset.c"
	}
	_g_object_unref0 (iter);
}


#line 899 "treeset.vala"
static GeeIterator* gee_tree_set_sub_set_real_iterator (GeeAbstractCollection* base) {
#line 2767 "treeset.c"
	GeeTreeSetSubSet * self;
	GeeIterator* result = NULL;
	self = (GeeTreeSetSubSet*) base;
	result = (GeeIterator*) gee_tree_set_sub_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self->priv->set, &self->priv->range);
#line 900 "treeset.vala"
	return result;
#line 2774 "treeset.c"
}


#line 903 "treeset.vala"
static GeeBidirIterator* gee_tree_set_sub_set_real_bidir_iterator (GeeSortedSet* base) {
#line 2780 "treeset.c"
	GeeTreeSetSubSet * self;
	GeeBidirIterator* result = NULL;
	self = (GeeTreeSetSubSet*) base;
	result = (GeeBidirIterator*) gee_tree_set_sub_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self->priv->set, &self->priv->range);
#line 904 "treeset.vala"
	return result;
#line 2787 "treeset.c"
}


#line 907 "treeset.vala"
static gpointer gee_tree_set_sub_set_real_first (GeeSortedSet* base) {
#line 2793 "treeset.c"
	GeeTreeSetSubSet * self;
	gpointer result = NULL;
	GeeTreeSetNode* _first;
	gconstpointer _tmp0_;
	self = (GeeTreeSetSubSet*) base;
#line 908 "treeset.vala"
	_first = gee_tree_set_range_first (&self->priv->range);
#line 909 "treeset.vala"
	g_assert (_first != NULL);
#line 2803 "treeset.c"
	result = (_tmp0_ = _first->key, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_));
#line 910 "treeset.vala"
	return result;
#line 2807 "treeset.c"
}


#line 913 "treeset.vala"
static gpointer gee_tree_set_sub_set_real_last (GeeSortedSet* base) {
#line 2813 "treeset.c"
	GeeTreeSetSubSet * self;
	gpointer result = NULL;
	GeeTreeSetNode* _last;
	gconstpointer _tmp0_;
	self = (GeeTreeSetSubSet*) base;
#line 914 "treeset.vala"
	_last = gee_tree_set_range_last (&self->priv->range);
#line 915 "treeset.vala"
	g_assert (_last != NULL);
#line 2823 "treeset.c"
	result = (_tmp0_ = _last->key, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_));
#line 916 "treeset.vala"
	return result;
#line 2827 "treeset.c"
}


#line 919 "treeset.vala"
static GeeSortedSet* gee_tree_set_sub_set_real_head_set (GeeSortedSet* base, gconstpointer before) {
#line 2833 "treeset.c"
	GeeTreeSetSubSet * self;
	GeeSortedSet* result = NULL;
	GeeTreeSetRange _tmp2_;
	GeeTreeSetRange _tmp1_;
	GeeTreeSetRange _tmp0_ = {0};
	GeeSortedSet* _tmp3_;
	self = (GeeTreeSetSubSet*) base;
	result = (_tmp3_ = (GeeSortedSet*) gee_tree_set_sub_set_new_from_range (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self->priv->set, (_tmp2_ = _tmp1_ = (gee_tree_set_range_cut_tail (&self->priv->range, before, &_tmp0_), _tmp0_), &_tmp2_)), gee_tree_set_range_destroy (&_tmp1_), _tmp3_);
#line 920 "treeset.vala"
	return result;
#line 2844 "treeset.c"
}


#line 923 "treeset.vala"
static GeeSortedSet* gee_tree_set_sub_set_real_tail_set (GeeSortedSet* base, gconstpointer after) {
#line 2850 "treeset.c"
	GeeTreeSetSubSet * self;
	GeeSortedSet* result = NULL;
	GeeTreeSetRange _tmp2_;
	GeeTreeSetRange _tmp1_;
	GeeTreeSetRange _tmp0_ = {0};
	GeeSortedSet* _tmp3_;
	self = (GeeTreeSetSubSet*) base;
	result = (_tmp3_ = (GeeSortedSet*) gee_tree_set_sub_set_new_from_range (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self->priv->set, (_tmp2_ = _tmp1_ = (gee_tree_set_range_cut_head (&self->priv->range, after, &_tmp0_), _tmp0_), &_tmp2_)), gee_tree_set_range_destroy (&_tmp1_), _tmp3_);
#line 924 "treeset.vala"
	return result;
#line 2861 "treeset.c"
}


#line 927 "treeset.vala"
static GeeSortedSet* gee_tree_set_sub_set_real_sub_set (GeeSortedSet* base, gconstpointer after, gconstpointer before) {
#line 2867 "treeset.c"
	GeeTreeSetSubSet * self;
	GeeSortedSet* result = NULL;
	GeeTreeSetRange _tmp2_;
	GeeTreeSetRange _tmp1_;
	GeeTreeSetRange _tmp0_ = {0};
	GeeSortedSet* _tmp3_;
	self = (GeeTreeSetSubSet*) base;
	result = (_tmp3_ = (GeeSortedSet*) gee_tree_set_sub_set_new_from_range (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self->priv->set, (_tmp2_ = _tmp1_ = (gee_tree_set_range_cut (&self->priv->range, after, before, &_tmp0_), _tmp0_), &_tmp2_)), gee_tree_set_range_destroy (&_tmp1_), _tmp3_);
#line 928 "treeset.vala"
	return result;
#line 2878 "treeset.c"
}


#line 931 "treeset.vala"
static GeeBidirIterator* gee_tree_set_sub_set_real_iterator_at (GeeSortedSet* base, gconstpointer item) {
#line 2884 "treeset.c"
	GeeTreeSetSubSet * self;
	GeeBidirIterator* result = NULL;
	GeeTreeSetNode* n;
	self = (GeeTreeSetSubSet*) base;
#line 932 "treeset.vala"
	if (!gee_tree_set_range_in_range (&self->priv->range, item)) {
#line 2891 "treeset.c"
		result = NULL;
#line 933 "treeset.vala"
		return result;
#line 2895 "treeset.c"
	}
#line 934 "treeset.vala"
	n = gee_tree_set_find_node (self->priv->set, item);
#line 935 "treeset.vala"
	if (n == NULL) {
#line 2901 "treeset.c"
		result = NULL;
#line 936 "treeset.vala"
		return result;
#line 2905 "treeset.c"
	}
	result = (GeeBidirIterator*) gee_tree_set_sub_iterator_new_pointing (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self->priv->set, &self->priv->range, n);
#line 937 "treeset.vala"
	return result;
#line 2910 "treeset.c"
}


#line 940 "treeset.vala"
static gpointer gee_tree_set_sub_set_real_lower (GeeSortedSet* base, gconstpointer item) {
#line 2916 "treeset.c"
	GeeTreeSetSubSet * self;
	gpointer result = NULL;
	gint res;
	gpointer l;
	gconstpointer _tmp0_;
	gboolean _tmp1_ = FALSE;
	gconstpointer _tmp2_;
	self = (GeeTreeSetSubSet*) base;
#line 941 "treeset.vala"
	res = gee_tree_set_range_compare_range (&self->priv->range, item);
#line 942 "treeset.vala"
	if (res > 0) {
#line 2929 "treeset.c"
		result = gee_sorted_set_last ((GeeSortedSet*) self);
#line 943 "treeset.vala"
		return result;
#line 2933 "treeset.c"
	}
#line 944 "treeset.vala"
	l = gee_sorted_set_lower ((GeeSortedSet*) self->priv->set, item);
#line 2937 "treeset.c"
	_tmp0_ = NULL;
#line 945 "treeset.vala"
	if (l != NULL) {
#line 945 "treeset.vala"
		_tmp1_ = gee_tree_set_range_in_range (&self->priv->range, l);
#line 2943 "treeset.c"
	} else {
#line 945 "treeset.vala"
		_tmp1_ = FALSE;
#line 2947 "treeset.c"
	}
#line 945 "treeset.vala"
	if (_tmp1_) {
#line 945 "treeset.vala"
		_tmp0_ = l;
#line 2953 "treeset.c"
	} else {
#line 945 "treeset.vala"
		_tmp0_ = NULL;
#line 2957 "treeset.c"
	}
	result = (_tmp2_ = _tmp0_, ((_tmp2_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp2_) : self->priv->g_dup_func ((gpointer) _tmp2_));
	((l == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (l = (self->priv->g_destroy_func (l), NULL));
#line 945 "treeset.vala"
	return result;
#line 2963 "treeset.c"
	((l == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (l = (self->priv->g_destroy_func (l), NULL));
}


#line 948 "treeset.vala"
static gpointer gee_tree_set_sub_set_real_higher (GeeSortedSet* base, gconstpointer item) {
#line 2970 "treeset.c"
	GeeTreeSetSubSet * self;
	gpointer result = NULL;
	gint res;
	gpointer h;
	gconstpointer _tmp0_;
	gboolean _tmp1_ = FALSE;
	gconstpointer _tmp2_;
	self = (GeeTreeSetSubSet*) base;
#line 949 "treeset.vala"
	res = gee_tree_set_range_compare_range (&self->priv->range, item);
#line 950 "treeset.vala"
	if (res < 0) {
#line 2983 "treeset.c"
		result = gee_sorted_set_first ((GeeSortedSet*) self);
#line 951 "treeset.vala"
		return result;
#line 2987 "treeset.c"
	}
#line 952 "treeset.vala"
	h = gee_sorted_set_higher ((GeeSortedSet*) self->priv->set, item);
#line 2991 "treeset.c"
	_tmp0_ = NULL;
#line 953 "treeset.vala"
	if (h != NULL) {
#line 953 "treeset.vala"
		_tmp1_ = gee_tree_set_range_in_range (&self->priv->range, h);
#line 2997 "treeset.c"
	} else {
#line 953 "treeset.vala"
		_tmp1_ = FALSE;
#line 3001 "treeset.c"
	}
#line 953 "treeset.vala"
	if (_tmp1_) {
#line 953 "treeset.vala"
		_tmp0_ = h;
#line 3007 "treeset.c"
	} else {
#line 953 "treeset.vala"
		_tmp0_ = NULL;
#line 3011 "treeset.c"
	}
	result = (_tmp2_ = _tmp0_, ((_tmp2_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp2_) : self->priv->g_dup_func ((gpointer) _tmp2_));
	((h == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (h = (self->priv->g_destroy_func (h), NULL));
#line 953 "treeset.vala"
	return result;
#line 3017 "treeset.c"
	((h == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (h = (self->priv->g_destroy_func (h), NULL));
}


#line 956 "treeset.vala"
static gpointer gee_tree_set_sub_set_real_floor (GeeSortedSet* base, gconstpointer item) {
#line 3024 "treeset.c"
	GeeTreeSetSubSet * self;
	gpointer result = NULL;
	gint res;
	gpointer l;
	gconstpointer _tmp0_;
	gboolean _tmp1_ = FALSE;
	gconstpointer _tmp2_;
	self = (GeeTreeSetSubSet*) base;
#line 957 "treeset.vala"
	res = gee_tree_set_range_compare_range (&self->priv->range, item);
#line 958 "treeset.vala"
	if (res > 0) {
#line 3037 "treeset.c"
		result = gee_sorted_set_last ((GeeSortedSet*) self);
#line 959 "treeset.vala"
		return result;
#line 3041 "treeset.c"
	}
#line 960 "treeset.vala"
	l = gee_sorted_set_floor ((GeeSortedSet*) self->priv->set, item);
#line 3045 "treeset.c"
	_tmp0_ = NULL;
#line 961 "treeset.vala"
	if (l != NULL) {
#line 961 "treeset.vala"
		_tmp1_ = gee_tree_set_range_in_range (&self->priv->range, l);
#line 3051 "treeset.c"
	} else {
#line 961 "treeset.vala"
		_tmp1_ = FALSE;
#line 3055 "treeset.c"
	}
#line 961 "treeset.vala"
	if (_tmp1_) {
#line 961 "treeset.vala"
		_tmp0_ = l;
#line 3061 "treeset.c"
	} else {
#line 961 "treeset.vala"
		_tmp0_ = NULL;
#line 3065 "treeset.c"
	}
	result = (_tmp2_ = _tmp0_, ((_tmp2_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp2_) : self->priv->g_dup_func ((gpointer) _tmp2_));
	((l == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (l = (self->priv->g_destroy_func (l), NULL));
#line 961 "treeset.vala"
	return result;
#line 3071 "treeset.c"
	((l == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (l = (self->priv->g_destroy_func (l), NULL));
}


#line 964 "treeset.vala"
static gpointer gee_tree_set_sub_set_real_ceil (GeeSortedSet* base, gconstpointer item) {
#line 3078 "treeset.c"
	GeeTreeSetSubSet * self;
	gpointer result = NULL;
	gint res;
	gpointer h;
	gconstpointer _tmp0_;
	gboolean _tmp1_ = FALSE;
	gconstpointer _tmp2_;
	self = (GeeTreeSetSubSet*) base;
#line 965 "treeset.vala"
	res = gee_tree_set_range_compare_range (&self->priv->range, item);
#line 966 "treeset.vala"
	if (res < 0) {
#line 3091 "treeset.c"
		result = gee_sorted_set_first ((GeeSortedSet*) self);
#line 967 "treeset.vala"
		return result;
#line 3095 "treeset.c"
	}
#line 968 "treeset.vala"
	h = gee_sorted_set_ceil ((GeeSortedSet*) self->priv->set, item);
#line 3099 "treeset.c"
	_tmp0_ = NULL;
#line 969 "treeset.vala"
	if (h != NULL) {
#line 969 "treeset.vala"
		_tmp1_ = gee_tree_set_range_in_range (&self->priv->range, h);
#line 3105 "treeset.c"
	} else {
#line 969 "treeset.vala"
		_tmp1_ = FALSE;
#line 3109 "treeset.c"
	}
#line 969 "treeset.vala"
	if (_tmp1_) {
#line 969 "treeset.vala"
		_tmp0_ = h;
#line 3115 "treeset.c"
	} else {
#line 969 "treeset.vala"
		_tmp0_ = NULL;
#line 3119 "treeset.c"
	}
	result = (_tmp2_ = _tmp0_, ((_tmp2_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp2_) : self->priv->g_dup_func ((gpointer) _tmp2_));
	((h == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (h = (self->priv->g_destroy_func (h), NULL));
#line 969 "treeset.vala"
	return result;
#line 3125 "treeset.c"
	((h == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (h = (self->priv->g_destroy_func (h), NULL));
}


static gint gee_tree_set_sub_set_real_get_size (GeeAbstractCollection* base) {
	gint result;
	GeeTreeSetSubSet* self;
	gint i;
	GeeIterator* iterator;
	self = (GeeTreeSetSubSet*) base;
#line 866 "treeset.vala"
	i = 0;
#line 867 "treeset.vala"
	iterator = gee_abstract_collection_iterator ((GeeAbstractCollection*) self);
#line 868 "treeset.vala"
	while (TRUE) {
#line 868 "treeset.vala"
		if (!gee_iterator_next (iterator)) {
#line 868 "treeset.vala"
			break;
#line 3146 "treeset.c"
		}
#line 869 "treeset.vala"
		i++;
#line 3150 "treeset.c"
	}
	result = i;
	_g_object_unref0 (iterator);
#line 870 "treeset.vala"
	return result;
#line 3156 "treeset.c"
}


static gboolean gee_tree_set_sub_set_real_get_is_empty (GeeAbstractCollection* base) {
	gboolean result;
	GeeTreeSetSubSet* self;
	self = (GeeTreeSetSubSet*) base;
	result = gee_tree_set_range_empty_subset (&self->priv->range);
#line 876 "treeset.vala"
	return result;
#line 3167 "treeset.c"
}


static void gee_tree_set_sub_set_class_init (GeeTreeSetSubSetClass * klass) {
	gee_tree_set_sub_set_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeTreeSetSubSetPrivate));
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->contains = gee_tree_set_sub_set_real_contains;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->add = gee_tree_set_sub_set_real_add;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->remove = gee_tree_set_sub_set_real_remove;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->clear = gee_tree_set_sub_set_real_clear;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->iterator = gee_tree_set_sub_set_real_iterator;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_size = gee_tree_set_sub_set_real_get_size;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_is_empty = gee_tree_set_sub_set_real_get_is_empty;
	G_OBJECT_CLASS (klass)->get_property = gee_tree_set_sub_set_get_property;
	G_OBJECT_CLASS (klass)->set_property = gee_tree_set_sub_set_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_tree_set_sub_set_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_SUB_SET_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_SUB_SET_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_SUB_SET_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_SUB_SET_SIZE, "size");
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_SUB_SET_IS_EMPTY, "is-empty");
}


static void gee_tree_set_sub_set_gee_sorted_set_interface_init (GeeSortedSetIface * iface) {
	gee_tree_set_sub_set_gee_sorted_set_parent_iface = g_type_interface_peek_parent (iface);
	iface->bidir_iterator = gee_tree_set_sub_set_real_bidir_iterator;
	iface->first = gee_tree_set_sub_set_real_first;
	iface->last = gee_tree_set_sub_set_real_last;
	iface->head_set = gee_tree_set_sub_set_real_head_set;
	iface->tail_set = gee_tree_set_sub_set_real_tail_set;
	iface->sub_set = gee_tree_set_sub_set_real_sub_set;
	iface->iterator_at = gee_tree_set_sub_set_real_iterator_at;
	iface->lower = gee_tree_set_sub_set_real_lower;
	iface->higher = gee_tree_set_sub_set_real_higher;
	iface->floor = gee_tree_set_sub_set_real_floor;
	iface->ceil = gee_tree_set_sub_set_real_ceil;
}


static void gee_tree_set_sub_set_instance_init (GeeTreeSetSubSet * self) {
	self->priv = GEE_TREE_SET_SUB_SET_GET_PRIVATE (self);
}


static void gee_tree_set_sub_set_finalize (GObject* obj) {
	GeeTreeSetSubSet * self;
	self = GEE_TREE_SET_SUB_SET (obj);
	_g_object_unref0 (self->priv->set);
	gee_tree_set_range_destroy (&self->priv->range);
	G_OBJECT_CLASS (gee_tree_set_sub_set_parent_class)->finalize (obj);
}


static GType gee_tree_set_sub_set_get_type (void) {
	static volatile gsize gee_tree_set_sub_set_type_id__volatile = 0;
	if (g_once_init_enter (&gee_tree_set_sub_set_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeTreeSetSubSetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_tree_set_sub_set_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeTreeSetSubSet), 0, (GInstanceInitFunc) gee_tree_set_sub_set_instance_init, NULL };
		static const GInterfaceInfo gee_sorted_set_info = { (GInterfaceInitFunc) gee_tree_set_sub_set_gee_sorted_set_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_tree_set_sub_set_type_id;
		gee_tree_set_sub_set_type_id = g_type_register_static (GEE_TYPE_ABSTRACT_SET, "GeeTreeSetSubSet", &g_define_type_info, 0);
		g_type_add_interface_static (gee_tree_set_sub_set_type_id, GEE_TYPE_SORTED_SET, &gee_sorted_set_info);
		g_once_init_leave (&gee_tree_set_sub_set_type_id__volatile, gee_tree_set_sub_set_type_id);
	}
	return gee_tree_set_sub_set_type_id__volatile;
}


static void gee_tree_set_sub_set_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeTreeSetSubSet * self;
	self = GEE_TREE_SET_SUB_SET (object);
	switch (property_id) {
		case GEE_TREE_SET_SUB_SET_SIZE:
		g_value_set_int (value, gee_abstract_collection_get_size ((GeeAbstractCollection*) self));
		break;
		case GEE_TREE_SET_SUB_SET_IS_EMPTY:
		g_value_set_boolean (value, gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_tree_set_sub_set_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeTreeSetSubSet * self;
	self = GEE_TREE_SET_SUB_SET (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_TREE_SET_SUB_SET_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_TREE_SET_SUB_SET_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_TREE_SET_SUB_SET_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
	}
}


#line 977 "treeset.vala"
static GeeTreeSetSubIterator* gee_tree_set_sub_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetRange* range) {
#line 3275 "treeset.c"
	GeeTreeSetSubIterator * self;
	GeeTreeSet* _tmp0_;
	GeeTreeSetRange _tmp2_;
	GeeTreeSetRange _tmp1_ = {0};
#line 977 "treeset.vala"
	g_return_val_if_fail (set != NULL, NULL);
#line 977 "treeset.vala"
	self = (GeeTreeSetSubIterator*) g_object_new (object_type, NULL);
#line 977 "treeset.vala"
	self->priv->g_type = g_type;
#line 977 "treeset.vala"
	self->priv->g_dup_func = g_dup_func;
#line 977 "treeset.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 978 "treeset.vala"
	self->priv->set = (_tmp0_ = _g_object_ref0 (set), _g_object_unref0 (self->priv->set), _tmp0_);
#line 979 "treeset.vala"
	self->priv->range = (_tmp2_ = (gee_tree_set_range_copy (range, &_tmp1_), _tmp1_), gee_tree_set_range_destroy (&self->priv->range), _tmp2_);
#line 3294 "treeset.c"
	return self;
}


#line 977 "treeset.vala"
static GeeTreeSetSubIterator* gee_tree_set_sub_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetRange* range) {
#line 977 "treeset.vala"
	return gee_tree_set_sub_iterator_construct (GEE_TREE_SET_TYPE_SUB_ITERATOR, g_type, g_dup_func, g_destroy_func, set, range);
#line 3303 "treeset.c"
}


#line 982 "treeset.vala"
static GeeTreeSetSubIterator* gee_tree_set_sub_iterator_construct_pointing (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetRange* range, GeeTreeSetNode* node) {
#line 3309 "treeset.c"
	GeeTreeSetSubIterator * self;
	GeeTreeSet* _tmp0_;
	GeeTreeSetRange _tmp2_;
	GeeTreeSetRange _tmp1_ = {0};
	GeeTreeSetIterator* _tmp3_;
#line 982 "treeset.vala"
	g_return_val_if_fail (set != NULL, NULL);
#line 982 "treeset.vala"
	g_return_val_if_fail (node != NULL, NULL);
#line 982 "treeset.vala"
	self = (GeeTreeSetSubIterator*) g_object_new (object_type, NULL);
#line 982 "treeset.vala"
	self->priv->g_type = g_type;
#line 982 "treeset.vala"
	self->priv->g_dup_func = g_dup_func;
#line 982 "treeset.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 983 "treeset.vala"
	self->priv->set = (_tmp0_ = _g_object_ref0 (set), _g_object_unref0 (self->priv->set), _tmp0_);
#line 984 "treeset.vala"
	self->priv->range = (_tmp2_ = (gee_tree_set_range_copy (range, &_tmp1_), _tmp1_), gee_tree_set_range_destroy (&self->priv->range), _tmp2_);
#line 985 "treeset.vala"
	self->priv->iterator = (_tmp3_ = gee_tree_set_iterator_new_pointing (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, set, node), _g_object_unref0 (self->priv->iterator), _tmp3_);
#line 3333 "treeset.c"
	return self;
}


#line 982 "treeset.vala"
static GeeTreeSetSubIterator* gee_tree_set_sub_iterator_new_pointing (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetRange* range, GeeTreeSetNode* node) {
#line 982 "treeset.vala"
	return gee_tree_set_sub_iterator_construct_pointing (GEE_TREE_SET_TYPE_SUB_ITERATOR, g_type, g_dup_func, g_destroy_func, set, range, node);
#line 3342 "treeset.c"
}


#line 988 "treeset.vala"
static gboolean gee_tree_set_sub_iterator_real_next (GeeIterator* base) {
#line 3348 "treeset.c"
	GeeTreeSetSubIterator * self;
	gboolean result = FALSE;
	self = (GeeTreeSetSubIterator*) base;
#line 989 "treeset.vala"
	if (self->priv->iterator != NULL) {
#line 3354 "treeset.c"
		gpointer next;
		gboolean _tmp0_ = FALSE;
		gpointer _tmp3_;
		gboolean _tmp2_;
		gpointer _tmp1_ = NULL;
		next = NULL;
#line 991 "treeset.vala"
		if ((_tmp2_ = gee_tree_set_iterator_safe_next_get (self->priv->iterator, &_tmp1_), next = (_tmp3_ = _tmp1_, ((next == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (next = (self->priv->g_destroy_func (next), NULL)), _tmp3_), _tmp2_)) {
#line 991 "treeset.vala"
			_tmp0_ = gee_tree_set_range_in_range (&self->priv->range, next);
#line 3365 "treeset.c"
		} else {
#line 991 "treeset.vala"
			_tmp0_ = FALSE;
#line 3369 "treeset.c"
		}
#line 991 "treeset.vala"
		if (_tmp0_) {
#line 992 "treeset.vala"
			g_assert (gee_iterator_next ((GeeIterator*) self->priv->iterator));
#line 3375 "treeset.c"
			result = TRUE;
			((next == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (next = (self->priv->g_destroy_func (next), NULL));
#line 993 "treeset.vala"
			return result;
#line 3380 "treeset.c"
		} else {
			result = FALSE;
			((next == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (next = (self->priv->g_destroy_func (next), NULL));
#line 995 "treeset.vala"
			return result;
#line 3386 "treeset.c"
		}
		((next == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (next = (self->priv->g_destroy_func (next), NULL));
	} else {
		result = gee_iterator_first ((GeeIterator*) self);
#line 998 "treeset.vala"
		return result;
#line 3393 "treeset.c"
	}
}


#line 1002 "treeset.vala"
static gboolean gee_tree_set_sub_iterator_real_has_next (GeeIterator* base) {
#line 3400 "treeset.c"
	GeeTreeSetSubIterator * self;
	gboolean result = FALSE;
	self = (GeeTreeSetSubIterator*) base;
#line 1003 "treeset.vala"
	if (self->priv->iterator != NULL) {
#line 3406 "treeset.c"
		gpointer next;
		gboolean _tmp0_ = FALSE;
		gpointer _tmp3_;
		gboolean _tmp2_;
		gpointer _tmp1_ = NULL;
		next = NULL;
#line 1005 "treeset.vala"
		if ((_tmp2_ = gee_tree_set_iterator_safe_next_get (self->priv->iterator, &_tmp1_), next = (_tmp3_ = _tmp1_, ((next == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (next = (self->priv->g_destroy_func (next), NULL)), _tmp3_), _tmp2_)) {
#line 1005 "treeset.vala"
			_tmp0_ = gee_tree_set_range_in_range (&self->priv->range, next);
#line 3417 "treeset.c"
		} else {
#line 1005 "treeset.vala"
			_tmp0_ = FALSE;
#line 3421 "treeset.c"
		}
		result = _tmp0_;
		((next == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (next = (self->priv->g_destroy_func (next), NULL));
#line 1005 "treeset.vala"
		return result;
#line 3427 "treeset.c"
	} else {
		result = gee_tree_set_range_first (&self->priv->range) != NULL;
#line 1007 "treeset.vala"
		return result;
#line 3432 "treeset.c"
	}
}


#line 1011 "treeset.vala"
static gboolean gee_tree_set_sub_iterator_real_first (GeeIterator* base) {
#line 3439 "treeset.c"
	GeeTreeSetSubIterator * self;
	gboolean result = FALSE;
	GeeTreeSetNode* node;
	GeeTreeSetIterator* _tmp0_;
	self = (GeeTreeSetSubIterator*) base;
#line 1012 "treeset.vala"
	node = gee_tree_set_range_first (&self->priv->range);
#line 1013 "treeset.vala"
	if (node == NULL) {
#line 3449 "treeset.c"
		result = FALSE;
#line 1014 "treeset.vala"
		return result;
#line 3453 "treeset.c"
	}
#line 1015 "treeset.vala"
	self->priv->iterator = (_tmp0_ = gee_tree_set_iterator_new_pointing (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self->priv->set, node), _g_object_unref0 (self->priv->iterator), _tmp0_);
#line 3457 "treeset.c"
	result = TRUE;
#line 1016 "treeset.vala"
	return result;
#line 3461 "treeset.c"
}


#line 1019 "treeset.vala"
static gboolean gee_tree_set_sub_iterator_real_previous (GeeBidirIterator* base) {
#line 3467 "treeset.c"
	GeeTreeSetSubIterator * self;
	gboolean result = FALSE;
	gpointer prev;
	gboolean _tmp0_ = FALSE;
	gpointer _tmp3_;
	gboolean _tmp2_;
	gpointer _tmp1_ = NULL;
	self = (GeeTreeSetSubIterator*) base;
#line 1020 "treeset.vala"
	if (self->priv->iterator == NULL) {
#line 3478 "treeset.c"
		result = FALSE;
#line 1021 "treeset.vala"
		return result;
#line 3482 "treeset.c"
	}
	prev = NULL;
#line 1023 "treeset.vala"
	if ((_tmp2_ = gee_tree_set_iterator_safe_previous_get (self->priv->iterator, &_tmp1_), prev = (_tmp3_ = _tmp1_, ((prev == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (prev = (self->priv->g_destroy_func (prev), NULL)), _tmp3_), _tmp2_)) {
#line 1023 "treeset.vala"
		_tmp0_ = gee_tree_set_range_in_range (&self->priv->range, prev);
#line 3489 "treeset.c"
	} else {
#line 1023 "treeset.vala"
		_tmp0_ = FALSE;
#line 3493 "treeset.c"
	}
#line 1023 "treeset.vala"
	if (_tmp0_) {
#line 1024 "treeset.vala"
		g_assert (gee_bidir_iterator_previous ((GeeBidirIterator*) self->priv->iterator));
#line 3499 "treeset.c"
		result = TRUE;
		((prev == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (prev = (self->priv->g_destroy_func (prev), NULL));
#line 1025 "treeset.vala"
		return result;
#line 3504 "treeset.c"
	} else {
		result = FALSE;
		((prev == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (prev = (self->priv->g_destroy_func (prev), NULL));
#line 1027 "treeset.vala"
		return result;
#line 3510 "treeset.c"
	}
	((prev == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (prev = (self->priv->g_destroy_func (prev), NULL));
}


#line 1031 "treeset.vala"
static gboolean gee_tree_set_sub_iterator_real_has_previous (GeeBidirIterator* base) {
#line 3518 "treeset.c"
	GeeTreeSetSubIterator * self;
	gboolean result = FALSE;
	gpointer prev;
	gboolean _tmp0_ = FALSE;
	gpointer _tmp3_;
	gboolean _tmp2_;
	gpointer _tmp1_ = NULL;
	self = (GeeTreeSetSubIterator*) base;
#line 1032 "treeset.vala"
	if (self->priv->iterator == NULL) {
#line 3529 "treeset.c"
		result = FALSE;
#line 1033 "treeset.vala"
		return result;
#line 3533 "treeset.c"
	}
	prev = NULL;
#line 1035 "treeset.vala"
	if ((_tmp2_ = gee_tree_set_iterator_safe_previous_get (self->priv->iterator, &_tmp1_), prev = (_tmp3_ = _tmp1_, ((prev == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (prev = (self->priv->g_destroy_func (prev), NULL)), _tmp3_), _tmp2_)) {
#line 1035 "treeset.vala"
		_tmp0_ = gee_tree_set_range_in_range (&self->priv->range, prev);
#line 3540 "treeset.c"
	} else {
#line 1035 "treeset.vala"
		_tmp0_ = FALSE;
#line 3544 "treeset.c"
	}
	result = _tmp0_;
	((prev == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (prev = (self->priv->g_destroy_func (prev), NULL));
#line 1035 "treeset.vala"
	return result;
#line 3550 "treeset.c"
}


#line 1038 "treeset.vala"
static gboolean gee_tree_set_sub_iterator_real_last (GeeBidirIterator* base) {
#line 3556 "treeset.c"
	GeeTreeSetSubIterator * self;
	gboolean result = FALSE;
	GeeTreeSetNode* node;
	GeeTreeSetIterator* _tmp0_;
	self = (GeeTreeSetSubIterator*) base;
#line 1039 "treeset.vala"
	node = gee_tree_set_range_last (&self->priv->range);
#line 1040 "treeset.vala"
	if (node == NULL) {
#line 3566 "treeset.c"
		result = FALSE;
#line 1041 "treeset.vala"
		return result;
#line 3570 "treeset.c"
	}
#line 1042 "treeset.vala"
	self->priv->iterator = (_tmp0_ = gee_tree_set_iterator_new_pointing (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self->priv->set, node), _g_object_unref0 (self->priv->iterator), _tmp0_);
#line 3574 "treeset.c"
	result = TRUE;
#line 1043 "treeset.vala"
	return result;
#line 3578 "treeset.c"
}


#line 1046 "treeset.vala"
static gpointer gee_tree_set_sub_iterator_real_get (GeeIterator* base) {
#line 3584 "treeset.c"
	GeeTreeSetSubIterator * self;
	gpointer result = NULL;
	self = (GeeTreeSetSubIterator*) base;
#line 1047 "treeset.vala"
	g_assert (self->priv->iterator != NULL);
#line 3590 "treeset.c"
	result = gee_iterator_get ((GeeIterator*) self->priv->iterator);
#line 1048 "treeset.vala"
	return result;
#line 3594 "treeset.c"
}


#line 1051 "treeset.vala"
static void gee_tree_set_sub_iterator_real_remove (GeeIterator* base) {
#line 3600 "treeset.c"
	GeeTreeSetSubIterator * self;
	self = (GeeTreeSetSubIterator*) base;
#line 1052 "treeset.vala"
	g_assert (self->priv->iterator != NULL);
#line 1053 "treeset.vala"
	gee_iterator_remove ((GeeIterator*) self->priv->iterator);
#line 3607 "treeset.c"
}


static void gee_tree_set_sub_iterator_class_init (GeeTreeSetSubIteratorClass * klass) {
	gee_tree_set_sub_iterator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeTreeSetSubIteratorPrivate));
	G_OBJECT_CLASS (klass)->get_property = gee_tree_set_sub_iterator_get_property;
	G_OBJECT_CLASS (klass)->set_property = gee_tree_set_sub_iterator_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_tree_set_sub_iterator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_SUB_ITERATOR_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_SUB_ITERATOR_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_SUB_ITERATOR_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void gee_tree_set_sub_iterator_gee_iterator_interface_init (GeeIteratorIface * iface) {
	gee_tree_set_sub_iterator_gee_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = gee_tree_set_sub_iterator_real_next;
	iface->has_next = gee_tree_set_sub_iterator_real_has_next;
	iface->first = gee_tree_set_sub_iterator_real_first;
	iface->get = gee_tree_set_sub_iterator_real_get;
	iface->remove = gee_tree_set_sub_iterator_real_remove;
}


static void gee_tree_set_sub_iterator_gee_bidir_iterator_interface_init (GeeBidirIteratorIface * iface) {
	gee_tree_set_sub_iterator_gee_bidir_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->previous = gee_tree_set_sub_iterator_real_previous;
	iface->has_previous = gee_tree_set_sub_iterator_real_has_previous;
	iface->last = gee_tree_set_sub_iterator_real_last;
}


static void gee_tree_set_sub_iterator_instance_init (GeeTreeSetSubIterator * self) {
	self->priv = GEE_TREE_SET_SUB_ITERATOR_GET_PRIVATE (self);
	self->priv->iterator = NULL;
}


static void gee_tree_set_sub_iterator_finalize (GObject* obj) {
	GeeTreeSetSubIterator * self;
	self = GEE_TREE_SET_SUB_ITERATOR (obj);
	_g_object_unref0 (self->priv->set);
	gee_tree_set_range_destroy (&self->priv->range);
	_g_object_unref0 (self->priv->iterator);
	G_OBJECT_CLASS (gee_tree_set_sub_iterator_parent_class)->finalize (obj);
}


static GType gee_tree_set_sub_iterator_get_type (void) {
	static volatile gsize gee_tree_set_sub_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&gee_tree_set_sub_iterator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeTreeSetSubIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_tree_set_sub_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeTreeSetSubIterator), 0, (GInstanceInitFunc) gee_tree_set_sub_iterator_instance_init, NULL };
		static const GInterfaceInfo gee_iterator_info = { (GInterfaceInitFunc) gee_tree_set_sub_iterator_gee_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_bidir_iterator_info = { (GInterfaceInitFunc) gee_tree_set_sub_iterator_gee_bidir_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_tree_set_sub_iterator_type_id;
		gee_tree_set_sub_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeTreeSetSubIterator", &g_define_type_info, 0);
		g_type_add_interface_static (gee_tree_set_sub_iterator_type_id, GEE_TYPE_ITERATOR, &gee_iterator_info);
		g_type_add_interface_static (gee_tree_set_sub_iterator_type_id, GEE_TYPE_BIDIR_ITERATOR, &gee_bidir_iterator_info);
		g_once_init_leave (&gee_tree_set_sub_iterator_type_id__volatile, gee_tree_set_sub_iterator_type_id);
	}
	return gee_tree_set_sub_iterator_type_id__volatile;
}


static void gee_tree_set_sub_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeTreeSetSubIterator * self;
	self = GEE_TREE_SET_SUB_ITERATOR (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_tree_set_sub_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeTreeSetSubIterator * self;
	self = GEE_TREE_SET_SUB_ITERATOR (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_TREE_SET_SUB_ITERATOR_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_TREE_SET_SUB_ITERATOR_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_TREE_SET_SUB_ITERATOR_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
	}
}


#line 703 "treeset.vala"
static void gee_tree_set_range_init (GeeTreeSetRange *self, GeeTreeSet* set, gconstpointer after, gconstpointer before) {
#line 3706 "treeset.c"
	GeeTreeSet* _tmp0_;
#line 703 "treeset.vala"
	g_return_if_fail (set != NULL);
#line 3710 "treeset.c"
	memset (self, 0, sizeof (GeeTreeSetRange));
#line 704 "treeset.vala"
	(*self).set = (_tmp0_ = _g_object_ref0 (set), _g_object_unref0 ((*self).set), _tmp0_);
#line 705 "treeset.vala"
	if (gee_tree_set_get_compare_func (set) (after, before) < 0) {
#line 706 "treeset.vala"
		(*self).after = after;
#line 707 "treeset.vala"
		(*self).before = before;
#line 708 "treeset.vala"
		(*self).type = GEE_TREE_SET_RANGE_TYPE_BOUNDED;
#line 3722 "treeset.c"
	} else {
#line 710 "treeset.vala"
		(*self).type = GEE_TREE_SET_RANGE_TYPE_EMPTY;
#line 3726 "treeset.c"
	}
}


#line 714 "treeset.vala"
static void gee_tree_set_range_init_head (GeeTreeSetRange *self, GeeTreeSet* set, gconstpointer before) {
#line 3733 "treeset.c"
	GeeTreeSet* _tmp0_;
#line 714 "treeset.vala"
	g_return_if_fail (set != NULL);
#line 3737 "treeset.c"
	memset (self, 0, sizeof (GeeTreeSetRange));
#line 715 "treeset.vala"
	(*self).set = (_tmp0_ = _g_object_ref0 (set), _g_object_unref0 ((*self).set), _tmp0_);
#line 716 "treeset.vala"
	(*self).before = before;
#line 717 "treeset.vala"
	(*self).type = GEE_TREE_SET_RANGE_TYPE_HEAD;
#line 3745 "treeset.c"
}


#line 720 "treeset.vala"
static void gee_tree_set_range_init_tail (GeeTreeSetRange *self, GeeTreeSet* set, gconstpointer after) {
#line 3751 "treeset.c"
	GeeTreeSet* _tmp0_;
#line 720 "treeset.vala"
	g_return_if_fail (set != NULL);
#line 3755 "treeset.c"
	memset (self, 0, sizeof (GeeTreeSetRange));
#line 721 "treeset.vala"
	(*self).set = (_tmp0_ = _g_object_ref0 (set), _g_object_unref0 ((*self).set), _tmp0_);
#line 722 "treeset.vala"
	(*self).after = after;
#line 723 "treeset.vala"
	(*self).type = GEE_TREE_SET_RANGE_TYPE_TAIL;
#line 3763 "treeset.c"
}


#line 733 "treeset.vala"
static void gee_tree_set_range_cut_head (GeeTreeSetRange *self, gconstpointer after, GeeTreeSetRange* result) {
#line 734 "treeset.vala"
	switch ((*self).type) {
#line 3771 "treeset.c"
		case GEE_TREE_SET_RANGE_TYPE_HEAD:
		{
			GeeTreeSetRange _tmp0_ = {0};
			*result = (gee_tree_set_range_init (&_tmp0_, (*self).set, after, (*self).before), _tmp0_);
#line 736 "treeset.vala"
			return;
#line 3778 "treeset.c"
		}
		case GEE_TREE_SET_RANGE_TYPE_TAIL:
		{
			GeeTreeSetRange _tmp1_ = {0};
			*result = (gee_tree_set_range_init_tail (&_tmp1_, (*self).set, gee_tree_set_max ((*self).set, after, (*self).after)), _tmp1_);
#line 738 "treeset.vala"
			return;
#line 3786 "treeset.c"
		}
		case GEE_TREE_SET_RANGE_TYPE_EMPTY:
		{
			GeeTreeSetRange _tmp2_ = {0};
			*result = (gee_tree_set_range_copy (&(*self), &_tmp2_), _tmp2_);
#line 740 "treeset.vala"
			return;
#line 3794 "treeset.c"
		}
		case GEE_TREE_SET_RANGE_TYPE_BOUNDED:
		{
			gpointer _after;
			GeeTreeSetRange _tmp3_ = {0};
#line 742 "treeset.vala"
			_after = gee_tree_set_max ((*self).set, after, (*self).after);
#line 3802 "treeset.c"
			*result = (gee_tree_set_range_init (&_tmp3_, (*self).set, _after, (*self).before), _tmp3_);
#line 743 "treeset.vala"
			return;
#line 3806 "treeset.c"
		}
		default:
		{
#line 745 "treeset.vala"
			g_assert_not_reached ();
#line 3812 "treeset.c"
		}
	}
}


#line 749 "treeset.vala"
static void gee_tree_set_range_cut_tail (GeeTreeSetRange *self, gconstpointer before, GeeTreeSetRange* result) {
#line 750 "treeset.vala"
	switch ((*self).type) {
#line 3822 "treeset.c"
		case GEE_TREE_SET_RANGE_TYPE_HEAD:
		{
			GeeTreeSetRange _tmp0_ = {0};
			*result = (gee_tree_set_range_init_head (&_tmp0_, (*self).set, gee_tree_set_min ((*self).set, before, (*self).before)), _tmp0_);
#line 752 "treeset.vala"
			return;
#line 3829 "treeset.c"
		}
		case GEE_TREE_SET_RANGE_TYPE_TAIL:
		{
			GeeTreeSetRange _tmp1_ = {0};
			*result = (gee_tree_set_range_init (&_tmp1_, (*self).set, (*self).after, before), _tmp1_);
#line 754 "treeset.vala"
			return;
#line 3837 "treeset.c"
		}
		case GEE_TREE_SET_RANGE_TYPE_EMPTY:
		{
			GeeTreeSetRange _tmp2_ = {0};
			*result = (gee_tree_set_range_copy (&(*self), &_tmp2_), _tmp2_);
#line 756 "treeset.vala"
			return;
#line 3845 "treeset.c"
		}
		case GEE_TREE_SET_RANGE_TYPE_BOUNDED:
		{
			gpointer _before;
			GeeTreeSetRange _tmp3_ = {0};
#line 758 "treeset.vala"
			_before = gee_tree_set_min ((*self).set, before, (*self).before);
#line 3853 "treeset.c"
			*result = (gee_tree_set_range_init (&_tmp3_, (*self).set, (*self).after, _before), _tmp3_);
#line 759 "treeset.vala"
			return;
#line 3857 "treeset.c"
		}
		default:
		{
#line 761 "treeset.vala"
			g_assert_not_reached ();
#line 3863 "treeset.c"
		}
	}
}


#line 765 "treeset.vala"
static void gee_tree_set_range_cut (GeeTreeSetRange *self, gconstpointer after, gconstpointer before, GeeTreeSetRange* result) {
#line 3871 "treeset.c"
	gpointer _tmp1_;
	gpointer _before;
	gpointer _tmp2_;
	gpointer _after;
	GeeTreeSetRange _tmp3_ = {0};
#line 766 "treeset.vala"
	if ((*self).type == GEE_TREE_SET_RANGE_TYPE_EMPTY) {
#line 3879 "treeset.c"
		GeeTreeSetRange _tmp0_ = {0};
		*result = (gee_tree_set_range_copy (&(*self), &_tmp0_), _tmp0_);
#line 767 "treeset.vala"
		return;
#line 3884 "treeset.c"
	}
	_tmp1_ = NULL;
#line 768 "treeset.vala"
	if ((*self).type != GEE_TREE_SET_RANGE_TYPE_TAIL) {
#line 768 "treeset.vala"
		_tmp1_ = gee_tree_set_min ((*self).set, before, (*self).before);
#line 3891 "treeset.c"
	} else {
#line 768 "treeset.vala"
		_tmp1_ = before;
#line 3895 "treeset.c"
	}
#line 768 "treeset.vala"
	_before = _tmp1_;
#line 3899 "treeset.c"
	_tmp2_ = NULL;
#line 769 "treeset.vala"
	if ((*self).type != GEE_TREE_SET_RANGE_TYPE_HEAD) {
#line 769 "treeset.vala"
		_tmp2_ = gee_tree_set_max ((*self).set, after, (*self).after);
#line 3905 "treeset.c"
	} else {
#line 769 "treeset.vala"
		_tmp2_ = after;
#line 3909 "treeset.c"
	}
#line 769 "treeset.vala"
	_after = _tmp2_;
#line 3913 "treeset.c"
	*result = (gee_tree_set_range_init (&_tmp3_, (*self).set, _after, _before), _tmp3_);
#line 770 "treeset.vala"
	return;
#line 3917 "treeset.c"
}


#line 773 "treeset.vala"
static gboolean gee_tree_set_range_in_range (GeeTreeSetRange *self, gconstpointer item) {
#line 3923 "treeset.c"
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 774 "treeset.vala"
	if ((*self).type == GEE_TREE_SET_RANGE_TYPE_EMPTY) {
#line 774 "treeset.vala"
		_tmp0_ = FALSE;
#line 3930 "treeset.c"
	} else {
#line 774 "treeset.vala"
		_tmp0_ = gee_tree_set_range_compare_range (&(*self), item) == 0;
#line 3934 "treeset.c"
	}
	result = _tmp0_;
#line 774 "treeset.vala"
	return result;
#line 3939 "treeset.c"
}


#line 777 "treeset.vala"
static gint gee_tree_set_range_compare_range (GeeTreeSetRange *self, gconstpointer item) {
#line 3945 "treeset.c"
	gint result = 0;
#line 778 "treeset.vala"
	switch ((*self).type) {
#line 3949 "treeset.c"
		case GEE_TREE_SET_RANGE_TYPE_HEAD:
		{
			gint _tmp0_ = 0;
#line 780 "treeset.vala"
			if (gee_tree_set_get_compare_func ((*self).set) (item, (*self).before) < 0) {
#line 780 "treeset.vala"
				_tmp0_ = 0;
#line 3957 "treeset.c"
			} else {
#line 780 "treeset.vala"
				_tmp0_ = 1;
#line 3961 "treeset.c"
			}
			result = _tmp0_;
#line 780 "treeset.vala"
			return result;
#line 3966 "treeset.c"
		}
		case GEE_TREE_SET_RANGE_TYPE_TAIL:
		{
			gint _tmp1_ = 0;
#line 782 "treeset.vala"
			if (gee_tree_set_get_compare_func ((*self).set) (item, (*self).after) >= 0) {
#line 782 "treeset.vala"
				_tmp1_ = 0;
#line 3975 "treeset.c"
			} else {
#line 782 "treeset.vala"
				_tmp1_ = -1;
#line 3979 "treeset.c"
			}
			result = _tmp1_;
#line 782 "treeset.vala"
			return result;
#line 3984 "treeset.c"
		}
		case GEE_TREE_SET_RANGE_TYPE_EMPTY:
		{
			result = 0;
#line 784 "treeset.vala"
			return result;
#line 3991 "treeset.c"
		}
		case GEE_TREE_SET_RANGE_TYPE_BOUNDED:
		{
			gint _tmp2_ = 0;
#line 786 "treeset.vala"
			if (gee_tree_set_get_compare_func ((*self).set) (item, (*self).after) >= 0) {
#line 3998 "treeset.c"
				gint _tmp3_ = 0;
#line 787 "treeset.vala"
				if (gee_tree_set_get_compare_func ((*self).set) (item, (*self).before) < 0) {
#line 787 "treeset.vala"
					_tmp3_ = 0;
#line 4004 "treeset.c"
				} else {
#line 787 "treeset.vala"
					_tmp3_ = 1;
#line 4008 "treeset.c"
				}
#line 787 "treeset.vala"
				_tmp2_ = _tmp3_;
#line 4012 "treeset.c"
			} else {
#line 787 "treeset.vala"
				_tmp2_ = -1;
#line 4016 "treeset.c"
			}
			result = _tmp2_;
#line 786 "treeset.vala"
			return result;
#line 4021 "treeset.c"
		}
		default:
		{
#line 789 "treeset.vala"
			g_assert_not_reached ();
#line 4027 "treeset.c"
		}
	}
}


#line 793 "treeset.vala"
static gboolean gee_tree_set_range_empty_subset (GeeTreeSetRange *self) {
#line 4035 "treeset.c"
	gboolean result = FALSE;
#line 794 "treeset.vala"
	switch ((*self).type) {
#line 4039 "treeset.c"
		case GEE_TREE_SET_RANGE_TYPE_HEAD:
		{
			gboolean _tmp0_ = FALSE;
#line 796 "treeset.vala"
			if ((*self).set->priv->_first == NULL) {
#line 796 "treeset.vala"
				_tmp0_ = TRUE;
#line 4047 "treeset.c"
			} else {
#line 796 "treeset.vala"
				_tmp0_ = !gee_tree_set_range_in_range (&(*self), (*self).set->priv->_first->key);
#line 4051 "treeset.c"
			}
			result = _tmp0_;
#line 796 "treeset.vala"
			return result;
#line 4056 "treeset.c"
		}
		case GEE_TREE_SET_RANGE_TYPE_TAIL:
		{
			gboolean _tmp1_ = FALSE;
#line 798 "treeset.vala"
			if ((*self).set->priv->_last == NULL) {
#line 798 "treeset.vala"
				_tmp1_ = TRUE;
#line 4065 "treeset.c"
			} else {
#line 798 "treeset.vala"
				_tmp1_ = !gee_tree_set_range_in_range (&(*self), (*self).set->priv->_last->key);
#line 4069 "treeset.c"
			}
			result = _tmp1_;
#line 798 "treeset.vala"
			return result;
#line 4074 "treeset.c"
		}
		case GEE_TREE_SET_RANGE_TYPE_EMPTY:
		{
			result = TRUE;
#line 800 "treeset.vala"
			return result;
#line 4081 "treeset.c"
		}
		case GEE_TREE_SET_RANGE_TYPE_BOUNDED:
		{
			result = gee_tree_set_range_first (&(*self)) == NULL;
#line 802 "treeset.vala"
			return result;
#line 4088 "treeset.c"
		}
		default:
		{
#line 804 "treeset.vala"
			g_assert_not_reached ();
#line 4094 "treeset.c"
		}
	}
}


#line 808 "treeset.vala"
static GeeTreeSetNode* gee_tree_set_range_first (GeeTreeSetRange *self) {
#line 4102 "treeset.c"
	GeeTreeSetNode* result = NULL;
#line 809 "treeset.vala"
	switch ((*self).type) {
#line 4106 "treeset.c"
		case GEE_TREE_SET_RANGE_TYPE_EMPTY:
		{
			result = NULL;
#line 811 "treeset.vala"
			return result;
#line 4112 "treeset.c"
		}
		case GEE_TREE_SET_RANGE_TYPE_HEAD:
		{
			result = (*self).set->priv->_first;
#line 813 "treeset.vala"
			return result;
#line 4119 "treeset.c"
		}
		default:
		{
			result = gee_tree_set_find_floor ((*self).set, (*self).after);
#line 815 "treeset.vala"
			return result;
#line 4126 "treeset.c"
		}
	}
}


#line 819 "treeset.vala"
static GeeTreeSetNode* gee_tree_set_range_last (GeeTreeSetRange *self) {
#line 4134 "treeset.c"
	GeeTreeSetNode* result = NULL;
#line 820 "treeset.vala"
	switch ((*self).type) {
#line 4138 "treeset.c"
		case GEE_TREE_SET_RANGE_TYPE_EMPTY:
		{
			result = NULL;
#line 822 "treeset.vala"
			return result;
#line 4144 "treeset.c"
		}
		case GEE_TREE_SET_RANGE_TYPE_TAIL:
		{
			result = (*self).set->priv->_last;
#line 824 "treeset.vala"
			return result;
#line 4151 "treeset.c"
		}
		default:
		{
			result = gee_tree_set_find_lower ((*self).set, (*self).before);
#line 826 "treeset.vala"
			return result;
#line 4158 "treeset.c"
		}
	}
}


static void gee_tree_set_range_copy (const GeeTreeSetRange* self, GeeTreeSetRange* dest) {
	dest->set = _g_object_ref0 (self->set);
	dest->after = self->after;
	dest->before = self->before;
	dest->type = self->type;
}


static void gee_tree_set_range_destroy (GeeTreeSetRange* self) {
	_g_object_unref0 (self->set);
}


static GeeTreeSetRange* gee_tree_set_range_dup (const GeeTreeSetRange* self) {
	GeeTreeSetRange* dup;
	dup = g_new0 (GeeTreeSetRange, 1);
	gee_tree_set_range_copy (self, dup);
	return dup;
}


static void gee_tree_set_range_free (GeeTreeSetRange* self) {
	gee_tree_set_range_destroy (self);
	g_free (self);
}


static GType gee_tree_set_range_get_type (void) {
	static volatile gsize gee_tree_set_range_type_id__volatile = 0;
	if (g_once_init_enter (&gee_tree_set_range_type_id__volatile)) {
		GType gee_tree_set_range_type_id;
		gee_tree_set_range_type_id = g_boxed_type_register_static ("GeeTreeSetRange", (GBoxedCopyFunc) gee_tree_set_range_dup, (GBoxedFreeFunc) gee_tree_set_range_free);
		g_once_init_leave (&gee_tree_set_range_type_id__volatile, gee_tree_set_range_type_id);
	}
	return gee_tree_set_range_type_id__volatile;
}


static void gee_tree_set_class_init (GeeTreeSetClass * klass) {
	gee_tree_set_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeTreeSetPrivate));
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->contains = gee_tree_set_real_contains;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->add = gee_tree_set_real_add;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->remove = gee_tree_set_real_remove;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->clear = gee_tree_set_real_clear;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->iterator = gee_tree_set_real_iterator;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_size = gee_tree_set_real_get_size;
	G_OBJECT_CLASS (klass)->get_property = gee_tree_set_get_property;
	G_OBJECT_CLASS (klass)->set_property = gee_tree_set_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_tree_set_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_SIZE, "size");
	/**
	 * The elements' comparator function.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_COMPARE_FUNC, g_param_spec_pointer ("compare-func", "compare-func", "compare-func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void gee_tree_set_gee_sorted_set_interface_init (GeeSortedSetIface * iface) {
	gee_tree_set_gee_sorted_set_parent_iface = g_type_interface_peek_parent (iface);
	iface->bidir_iterator = gee_tree_set_real_bidir_iterator;
	iface->first = gee_tree_set_real_first;
	iface->last = gee_tree_set_real_last;
	iface->head_set = gee_tree_set_real_head_set;
	iface->tail_set = gee_tree_set_real_tail_set;
	iface->sub_set = gee_tree_set_real_sub_set;
	iface->iterator_at = gee_tree_set_real_iterator_at;
	iface->lower = gee_tree_set_real_lower;
	iface->higher = gee_tree_set_real_higher;
	iface->floor = gee_tree_set_real_floor;
	iface->ceil = gee_tree_set_real_ceil;
}


static void gee_tree_set_instance_init (GeeTreeSet * self) {
	self->priv = GEE_TREE_SET_GET_PRIVATE (self);
	self->priv->_size = 0;
	self->priv->root = NULL;
	self->priv->_first = NULL;
	self->priv->_last = NULL;
	self->priv->stamp = 0;
}


static void gee_tree_set_finalize (GObject* obj) {
	GeeTreeSet * self;
	self = GEE_TREE_SET (obj);
	_gee_tree_set_node_free0 (self->priv->root);
	G_OBJECT_CLASS (gee_tree_set_parent_class)->finalize (obj);
}


/**
 * Left-leaning red-black tree implementation of the {@link Set} interface.
 *
 * This implementation is especially well designed for large quantity of
 * data. The (balanced) tree implementation insure that the set and get
 * methods are in logarithmic complexity. For a linear implementation see
 * {@link HashSet}.
 *
 * @see HashSet
 */
GType gee_tree_set_get_type (void) {
	static volatile gsize gee_tree_set_type_id__volatile = 0;
	if (g_once_init_enter (&gee_tree_set_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeTreeSetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_tree_set_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeTreeSet), 0, (GInstanceInitFunc) gee_tree_set_instance_init, NULL };
		static const GInterfaceInfo gee_sorted_set_info = { (GInterfaceInitFunc) gee_tree_set_gee_sorted_set_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_tree_set_type_id;
		gee_tree_set_type_id = g_type_register_static (GEE_TYPE_ABSTRACT_SET, "GeeTreeSet", &g_define_type_info, 0);
		g_type_add_interface_static (gee_tree_set_type_id, GEE_TYPE_SORTED_SET, &gee_sorted_set_info);
		g_once_init_leave (&gee_tree_set_type_id__volatile, gee_tree_set_type_id);
	}
	return gee_tree_set_type_id__volatile;
}


static void gee_tree_set_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeTreeSet * self;
	self = GEE_TREE_SET (object);
	switch (property_id) {
		case GEE_TREE_SET_SIZE:
		g_value_set_int (value, gee_abstract_collection_get_size ((GeeAbstractCollection*) self));
		break;
		case GEE_TREE_SET_COMPARE_FUNC:
		g_value_set_pointer (value, gee_tree_set_get_compare_func (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_tree_set_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeTreeSet * self;
	self = GEE_TREE_SET (object);
	switch (property_id) {
		case GEE_TREE_SET_COMPARE_FUNC:
		gee_tree_set_set_compare_func (self, g_value_get_pointer (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_TREE_SET_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_TREE_SET_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_TREE_SET_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
	}
}




