/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.exml;


/**
 * This class is for unit testing the Document class.
 *
 * @see Document
 * @author Elias Ross
 * @version 1.0
 */
public class DocumentTest
	extends junit.framework.TestCase
{
	public DocumentTest(String name) {
		super(name);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(DocumentTest.class);
	}

	public void testInit() {
		Document d = new Document();
		assertEquals("type is DOCUMENT_NODE", Node.DOCUMENT_NODE, d.getNodeType());
		assertEquals("children default ", null, d.getChildNodes());
		Element e = new Element("blah");
		d.appendChild(e);
		try {
			d.appendChild(new Element("blah2"));
			fail("must check adding");
		} catch (ElementException ee) {
		}
		assertEquals("root ", e, d.getRootElement());
		d.appendChild(new PI("php"));
		assertEquals("size of children", 2, d.getChildNodes().size());
	}

}
