/* liblivejournal - a client library for LiveJournal.
 * Copyright (C) 2003 Evan Martin <evan@livejournal.com>
 *
 * vim: tabstop=4 shiftwidth=4 noexpandtab :
 */

#ifndef __LIVEJOURNAL_SYNCITEMS_H__
#define __LIVEJOURNAL_SYNCITEMS_H__

#include <livejournal/verb.h>
#include <time.h>

typedef enum {
	LJ_SYNCITEM_TYPE_ENTRY,
	LJ_SYNCITEM_TYPE_OTHER
} LJSyncItemType;

typedef struct _LJSyncItem {
	LJSyncItemType type;
	time_t time;
	int id;
} LJSyncItem;

typedef struct _LJSyncItems {
	LJVerb verb;

	GSList *items;
	int count, total;
	char *lastsync;
} LJSyncItems;

LJSyncItems* lj_syncitems_new(LJUser *user, const char *usejournal, const char *lastsync);
void         lj_syncitems_free(LJSyncItems *syncitems, gboolean free_items);

#endif /* __LIVEJOURNAL_SYNCITEMS_H__ */

