/* LogJam, a GTK LiveJournal client.
 * Copyright (C) 2000,2001 Evan Martin <evan@livejournal.com>
 * vim:ts=4:sw=4:
 *
 * $Id: util.h,v 1.4 2001/11/07 02:03:37 martine Exp $
 */

#ifndef util_h
#define util_h

#include <gtk/gtk.h>
#include <time.h>
#include "dotconf.h" /* for the "geometry" struct */

/* converting to/from ljdate ("yyyy-mm-dd hh:mm:ss") and time_t unix time */
extern void ljdate_to_tm(char *ljdate, struct tm *ljtm);
extern char* timet_to_ljdate (time_t unixtime);

/* hash table helpers. */
extern void hash_destroy(GHashTable* hash);
extern void hash_print(GHashTable* hash);

/* gtk helpers */
extern void default_column_clicked(GtkCList *list, gint col, gpointer d);

extern GtkWidget* lj_table_new(int rows, int cols);
extern void lj_table_label(GtkTable *table, int row, char *text);
extern void lj_table_content(GtkTable *table, int row, GtkWidget *content);
extern void lj_table_fillrow(GtkTable *table, int row, GtkWidget *content);

extern void lj_dialog_init(GtkWidget *dlg, GtkWidget *parent, gchar *title, int width, int height);
extern GtkWidget* lj_dialog_new(GtkWidget *parent, gchar *title, int width, int height);
extern void lj_dialog_set_contents(GtkWidget *dlg, GtkWidget *vbox);
void lj_dialog_add_button(GtkWidget *dlg, GtkWidget *button);
extern GtkWidget* lj_dialog_buttonbox_new();
extern void lj_dialog_buttonbox_add(GtkWidget *box, GtkWidget *button);
extern void lj_dialog_set_contents_buttonbox(GtkWidget *dlg, GtkWidget *contents, GtkWidget *buttonbox);
extern void lj_dialog_add_close(GtkWidget *dlg);
extern GtkWidget* lj_dialog_add_okcancel(GtkWidget *dlg, char *okcaption, GtkSignalFunc okfunc, gpointer data);

extern int lj_confirm(GtkWidget *parent, char *title, char *msg);

/* field_strdup_printf("a %2 c %1", "d", "b") -> "a b c d" */
char* field_strdup_printf(char *fmt, char* fields[]);

extern void lj_win_set_icon(GtkWidget *win);

void string_replace(char **dest, char *src);

void web_pixmap(GtkWidget *w, GdkPixmap **p, GdkBitmap **b);
GtkWidget* web_button(GtkWidget *w, char *caption);

void hex_to_color(char *buf, gdouble color[4]);
void hex_to_gdkcolor(char *buf, GdkColor *c);
void color_to_hex(gdouble color[4], char* buf);

/* return the data from the current selection, or NULL */
extern gpointer clist_data_from_selection(GtkCList *l);
/* wrap this widget in a scrollarea */
extern GtkWidget* scroll_wrap(GtkWidget *w);
/* load/save this window's geometry */
extern void geometry_save(GtkWidget *win, geometry *geom);
extern void geometry_load(GtkWidget *win, geometry *geom);
/* tie a geometry struct to a window */
extern void geometry_tie(GtkWidget *win, geometry *geom);

unsigned char* urldecode(char *string);
char* urlencode(unsigned char *string);

char* util_skipline(char *text);
char* util_getline(char *text);

void lj_messagebox(GtkWidget *parent, char *title, char *message);

#endif /* util_h */
