#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>

struct ELM{
	int num;
	char str[100];
};

static int compare_split (const char *s, ELM tb[10])
{
	memset (tb,0,10*sizeof(ELM));
	int ret = 0;
	while (*s != '\0' && ret < 10){
		tb[ret].num = atoi(s);
		while (isdigit(*s)) s++;
		char *start = tb[ret].str;
		char *dst = start;
		while (*s != '\0'
			&& *s != '.'
			&& *s != '-'
			&& (int)(dst-start) < 99){
			*dst++ = *s++;
		}
		*dst = '\0';
		ret++;
		if (*s != '\0') s++;
	}
	return ret;
}

int main (int argc, char *argv[])
{
	int ret = -1;
	if (argc != 3){
		fprintf (stderr
			,"compare-version ver1 ver2\n"
			 "Compare two strings representing software version\n"
			 "return 0 if the first is larger or equal to the second.\n"
			 "\n"
			 "A version is defined by elements splits by dots.\n"
			 "An element starts with a number and is followed by a string."
			 "The number is interpreted as a number and the rest as a string\n"
			 "So 1.23.2 is larger than 1.4.\n");
	}else{
		ELM tb1[10],tb2[10];
		int nb1 = compare_split (argv[1],tb1);
		int nb2 = compare_split (argv[2],tb2);
		int cmp = 0;
		for (int i=0; i<nb1 && i<nb2; i++){
			cmp = tb1[i].num - tb2[i].num;
			if (cmp != 0) break;
			cmp = strcmp(tb1[i].str,tb2[i].str);
			if (cmp != 0) break;
		}
		if (cmp == 0) cmp = nb1 - nb2;
		ret = cmp >= 0 ? 0 : 1;
	}
	return ret;
}
		
		

