#include <unistd.h>
#include "netconf.h"
#include "netconf.m"
#include <translat.h>
#include <dialog.h>
#include <userconf.h>

static HELP_FILE help_shutdown ("netconf","shutdown");

static PRIVILEGE p_shutdown ("shutdown"
	,P_MSG_U(T_PRIVSHUTDOWN,"May shutdown")
	,P_MSG_R(T_PSYSCONTROL));


/*
	Interactive control of a shutdown or reboot
*/
EXPORT void shutdown_control()
{
	if (perm_access (&p_shutdown,MSG_U(P_SHUTDOWN
		,"shutdown the computer"))){
		DIALOG dia;
		dia.settype (DIATYPE_POPUP);
		char oper=0;
		dia.newf_radio ("",oper,0,MSG_U(F_REBOOT,"Reboot"));
		dia.newf_radio ("",oper,1,MSG_U(F_HALT,"Shutdown & halt"));
		int grace = 0;
		dia.newf_num   (MSG_U(F_DELAI,"Delay before shutdown(minutes)"),grace);
		SSTRING message;
		dia.newf_str   (MSG_U(F_MESSAGE,"Message"),message);
		if (dia.edit (MSG_U(T_SHUTDOWN,"Shutdown control panel")
			,MSG_U(I_SHUTDOWN,"You can force a reboot or a final shutdown\n"
				"of this computer")
			,help_shutdown)==MENU_ACCEPT){
			setuid (0);
			chdir ("/");
			char timestr[10];
			sprintf (timestr,"+%d",grace);
			execl ("/sbin/shutdown","/sbin/shutdown"
				,oper == 0 ? "-r" : "-h"
				,timestr,message.get(),NULL);	
		}
	}
}

