#pragma interface
#ifndef NETCONF_H
#define NETCONF_H

#include "../paths.h"

#include <stdio.h>

#ifndef MISC_H
	#include <misc.h>
#endif

#ifndef NETCONF_DEF_H
	#include "netconf_def.h"
#endif

class SSTREAM;
/*
	A HOST simply contain a single line of /etc/hosts.
	It will remember comments. Line containing only a comment will
	be store with name1 and others == NULL.
*/
class HOST: public ARRAY_OBJ{
protected:
	SSTRING name1;
	SSTRING others;		// Other name (alias)
	SSTRING ip_num;		// Even the IP number is stored as a string
						// It allows "editing" completly broken
						// /etc/hosts file.
	SSTRING comment;
	char is_valid;		// Tells if the record is valid
						// If not, it is managed as a comment
	/*~PROTOBEG~ HOST */
public:
	HOST (const char *_ip_num,
		 const char *_name1,
		 const char *_others,
		 const char *_comment);
	HOST (const char *buf);
	HOST (void);
	virtual int edit (HELP_FILE&helpfile);
private:
	void freeall (void);
public:
	const char *getcomment (void)const;
	const char *getipnum (void)const;
	const char *getname1 (void)const;
	const char *getothers (void)const;
	virtual int is_special (void)const;
	bool is_stationid (void);
	int iscomment (void)const;
	virtual void print (SSTREAM&ss)const;
	void set (const char *buf);
	void setcomment (const char *_comment);
	void setipnum (const char *_ipnum);
	void setname1 (const char *_name1);
	void setothers (const char *_others);
	virtual ~HOST (void);
	/*~PROTOEND~ HOST */
};
class NETWORK: public HOST{
	/*~PROTOBEG~ NETWORK */
public:
	NETWORK (const char *_ip_num,
		 const char *_name1,
		 const char *_others,
		 const char *_comment);
	NETWORK (const char *buf);
	NETWORK (void);
	int is_special (void)const;
	void print (SSTREAM&ss)const;
	/*~PROTOEND~ NETWORK */
};

class HOSTS: public ARRAY{
protected:
	CONFIG_FILE *cfgf;
	/*~PROTOBEG~ HOSTS */
public:
	HOSTS (void);
	void add (HOST *pt);
	virtual void add (const char *_ip_num,
		 const char *_name1,
		 const char *_others,
		 const char *_comment);
	virtual void add (const char *buf);
	int edit (const char *title, HELP_FILE&helpfile);
	HOST *getbyip (const char *ip)const;
	HOST *getitem (const char *name)const;
	HOST *getitem (int no)const;
	virtual HOST *newhost (const char *_ip_num,
		 const char *_name1,
		 const char *_others,
		 const char *_comment);
	virtual HOST *newhost (const char *buf);
	int read (void);
	int setlocalhost (void);
	int write (void)const;
	/*~PROTOEND~ HOSTS */
};
class NETWORKS: public HOSTS{
	/*~PROTOBEG~ NETWORKS */
public:
	NETWORKS (void);
	virtual HOST *newhost (const char *_ip_num,
		 const char *_name1,
		 const char *_others,
		 const char *_comment);
	virtual HOST *newhost (const char *buf);
	/*~PROTOEND~ NETWORKS */
};

class THISHOST{
	char *name1;		// Principal name of this host
	char is_config;		// Is it currently configured
	/*~PROTOBEG~ THISHOST */
public:
	THISHOST (void);
	int configok (void);
	const char *getdomain (void);
	const char *getname1 (void);
	void setname1 (const char *newname1);
	~THISHOST (void);
	/*~PROTOEND~ THISHOST */
};

enum RTTYPE{
	RTTYPE_NETWORK,
	RTTYPE_HOST,
	RTTYPE_ALTNET,
	RTTYPE_DEFAULT
};

class ROUTE: public ARRAY_OBJ{
	SSTRING ip_dst;
	SSTRING ip_gateway;
	SSTRING netmask;
	SSTRING flags;
	int tag;		// Application placeholder
	SSTRING invalid_line;	// Contain an unparsable line from ETC_CONF_ROUTE
	SSTRING iface;
	/*~PROTOBEG~ ROUTE */
public:
	ROUTE (const char *buf, int noline);
	ROUTE (const char *dst,
		 const char *gate,
		 const char *mask,
		 const char *_flags,
		 const char *_iface);
	ROUTE (void);
	int compare (const ROUTE *r);
	int dst_is_host (void)const;
	int edit (RTTYPE route_type);
	void formatcmd (char *buf)const;
	const char *getdst (void)const;
	const char *getgateway (void)const;
	const char *getiface (void)const;
	const char *getmask (void)const;
	int gettag (void)const;
	RTTYPE gettype (void)const;
	int is_default (void)const;
	int is_loopback (void);
	int isdevice (void)const;
	int kill (void)const;
	int match (const SSTRING&dst)const;
	void settag (int _tag);
	void write (FILE_CFG *fout);
	~ROUTE (void);
	/*~PROTOEND~ ROUTE */
};

class ROUTES: public ARRAY{
	/*~PROTOBEG~ ROUTES */
public:
	ROUTE *find (const SSTRING&ip_dst);
	ROUTE *finddefault (void);
	ROUTE *getitem (int no)const;
	int readactive (void);
	void readbyme (void);
	void readconf (void);
	void write (FILE_CFG *fout);
	void writebyme (void);
	/*~PROTOEND~ ROUTES */
};

struct IFCONFIG_INFO {
	int flags;
	char ip_addr[LEN_IP_ASC];
	char dst_addr[LEN_IP_ASC];
	char netmask[LEN_IP_ASC];
	char bcast[LEN_IP_ASC];
};

enum SERVICE_OWNER {
	OWNER_INTERNAL,		// Managed by linuxconf
	OWNER_DROPIN,		// Managed by the dropins
	OWNER_DISTRIB		// Managed by the distribution
};

enum SERVICE_OPER {
	SERVICE_START,
	SERVICE_STOP,
	SERVICE_RESTART,
};

class SERVICE: public ARRAY_OBJ{
public:
	SSTRING name;
	SSTRING desc;
	char state;		// 0 enable, 1 temp-disable, 2 disabled
	char previous;	// Value of state prior to editing
					// this may be used by distribution to decide
					// easily if the state of a service was affected
	SERVICE_OWNER owner;
	virtual int control (SERVICE_OPER oper)=0;
	virtual int edit ()=0;
	virtual const char *getconfstatus()=0;
	virtual const char *getrunstatus()=0;

	/*~PROTOBEG~ SERVICE */
public:
	SERVICE (const char *_name,
		 const char *_desc,
		 int _state,
		 SERVICE_OWNER _owner);
	/*~PROTOEND~ SERVICE */
};

class SERVICES: public ARRAY{
	/*~PROTOBEG~ SERVICES */
public:
	SERVICE *getitem (int no)const;
	void sort (void);
	/*~PROTOEND~ SERVICES */
};

#include "dialog_def.h"
#include <stdio.h>

struct hostent;
struct HOSTINFO;
class DAEMON_INTERNAL;
class DAEMON;
class PROC;
class PPPONE;
class PRIVILEGE;
class BOOTRCS;
class FIELD_COMBO;
struct INTER_INFO;
struct DEVICE_NAME_INFO;
struct IPX_INTER_INFO;

#include "netconf.p"

#endif

