/* #Specification: shellmod / principles
	The shellmod module is an interface between scripting language
	and linuxconf. By using a simple textual protocol, simple shell scripts
	(or any language that can read and print, any language in fact)
	can interact with Linuxconf. They can do many things a normal
	module can do:

	<sgml>
	<itemize>
	<item>insert into menus
	<item>build dialog
	</itemize>
	</sgml>
*/
#pragma implementation
#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "shellmod.h"
#include "shellmod.m"
#include <userconf.h>

extern HELP_FILE help_shellmod;

MODULE_DEFINE_VERSION(shellmod);

PUBLIC MODULE_shellmod::MODULE_shellmod()
	: LINUXCONF_MODULE("shellmod")
{
	linuxconf_loadmsg ("shellmod",PACKAGE_REV);
	shellmod_setdebug ();
}

static const char *keymenu;


PUBLIC void MODULE_shellmod::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
	if (context == MENU_CTRL_FILE){
		keymenu = MSG_U(M_SHELLMOD,"Shell module management");
		dia.new_menuitem ("",keymenu);
	}
	modules_setmenu (dia,context);
}
PUBLIC void MODULE_shellmod::setmenu (
	DIALOG &dia,
	const char *menuid)
{
	modules_setmenu (dia,menuid);
}

static bool privi_changed = false;

static void shellmod_mainmenu()
{
	const char *config = MSG_U(M_CONFIG,"Shellmod configuration");
	const char *editmod = MSG_U(M_EDITMODULES,"Edit modules");
	const char *buildmod = MSG_U(M_BUILDMOD,"Build a new module");
	static const char *menuopt[]={
		"", config,
		"", editmod,
		"", buildmod,
		NULL
	};
	DIALOG_MENU dia;
	dia.new_menuitems(menuopt);
	int nof = 0;
	while (1){
		MENU_STATUS code = dia.editmenu (MSG_U(T_SHELLMOD,"shellmod management")
			,MSG_U(I_SHELLMOD,"You register and unregister shell module\n"
				"using this menu")
			,help_shellmod
			,nof,0);
		if (code == MENU_QUIT || code == MENU_ESCAPE){
			break;
		}else if (perm_rootaccess(MSG_R(P_MNGMOD))){
			const char *key = dia.getmenustr(nof);
			if (key == editmod){
				shellmod_edit();
				privi_changed = true;
			}else if (key == buildmod){
				shellmod_build();
			}else if (key == config){
				shellmod_config();
			}
		}
	}
}



PUBLIC int MODULE_shellmod::domenu (
	MENU_CONTEXT context,
	const char *key)
{
	if (key == keymenu){
		shellmod_mainmenu();
	}else{
		modules_domenu (context,key);
	}
	return 0;
}
PUBLIC int MODULE_shellmod::domenu (
	const char *menuid,
	const char *key)
{
	return modules_domenu (menuid,key);
}


PUBLIC int MODULE_shellmod::dohtml (const char *key)
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(key,"shellmod")==0){
		// ### Insert any menu and dialog here
		ret = 0;
	}
	return ret;
}

PUBLIC int MODULE_shellmod::message (const char *msg, int argc, const char *argv[])
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(msg,"treemenu-depend")==0 && argc >= 1){
		SSTRINGS *ss = (SSTRINGS*)argv[0];
		modules_getmenudepend (*ss);
		ret = 0;
	}
	return ret;
}


static void usage()
{
	xconf_notice (MSG_U(T_USAGE
		,"Module shellmod\n"
		 "linuxconf --modulemain shellmod [ specific options ]\n"
		 "\n"
		 "    --build\n"
		 "    --exec script_path [--debug] [--perl] script options\n"
		 "    --setmod module_path\n"
		 "    --unsetmod module_path\n"
		 "    Without argument, start the module main menu\n"
		 "\n")
		);
}

PUBLIC void MODULE_shellmod::usage (SSTRINGS &tb)
{
	tb.add (new SSTRING(MSG_R(T_USAGE)));
}


PUBLIC int MODULE_shellmod::execmain (int argc , char *argv[], bool)
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"shellmod")==0){
		ret = -1;
		if (perm_rootaccess (MSG_U(P_MNGMOD,"Manage modules"))){
			if (argc == 1){
				modules_loadcur();
				shellmod_mainmenu();
			}else if (argc == 3 && strcmp(argv[1],"--setmod")==0){
				ret = modules_setmod (argv[2],false);
			}else if (argc == 3 && strcmp(argv[1],"--unsetmod")==0){
				ret = modules_unsetmod (argv[2]);
			}else if (argc == 3 && strcmp(argv[1],"--build")==0){
				shellmod_build();
				ret = 0;
			}else if (argc >= 3 && strcmp(argv[1],"--exec")==0){
				shellprg_exec(argc-2,argv+2);
				ret = 0;
			}else{
				::usage();
			}
		}
	}
	return ret;
}


static MODULE_shellmod shellmod;


static HELP_FILE help_privi ("shellmod","modprivi");
static REGISTER_PRIVI_HELP p (help_privi
	,P_MSG_U(T_MODPRIVI,"Privileges: Shellmod modules"));

static PRIVILEGES tb;

static void modules_setprivi()
{
	if (tb.getnb()==0 || privi_changed){
		privi_changed = false;
		tb.remove_all();
		SSTRINGS mods;
		modules_getlist (mods);
		int n = mods.getnb();
		for (int i=0; i<n; i++){
			const char *mod = mods.getitem(i)->get();
			char id[PATH_MAX];
			sprintf (id,"shellmod_%s",mod);
			tb.add (new PRIVILEGE (id,mod
				,MSG_U(T_MODPRIV,"Shellmod modules")));
		}
	}
}

static PRIVILEGE_DECLARATOR modules_decl(modules_setprivi);


bool shellmod_haspriv (const char *path)
{
	modules_setprivi();
	char id[PATH_MAX];
	sprintf (id,"shellmod_%s",path);
	PRIVILEGE *priv = privilege_lookup (id);
	return perm_access(priv,MSG_U(P_ANYSHELLMOD
						,"to access any shell module"));
}

