#pragma implementation
#include <stdio.h>
#include <string.h>
#include <translat.h>
#include <netconf.h>
#include <userconf.h>
#include "redhat.h"
#include "redhat.m"
#include "../module_apis/package_api.h"
#include "../module_apis/servicectl_api.h"

MODULE_DEFINE_VERSION(redhat);

static HELP_FILE help_installpkg ("redhat","installpkg");

PUBLIC MODULE_redhat::MODULE_redhat()
	: LINUXCONF_MODULE ("redhat")
{
	linuxconf_loadmsg ("redhat",PACKAGE_REV);
	linuxconf_sethook (filter_fctnew);
	int release = redhat_release();
	if (release>=501){
		hostinfo_sethook (devinfo_load,devinfo_save);
		groutes_sethook (routes_load,routes_save);
		ipalias_sethook (devinfo_ipalias_load,devinfo_ipalias_save);
	}
	if (release>=500){
		#if defined(__GLIBC__) && defined(HAS_PAM)
			users_sethook (reduser_del,reduser_add,reduser_change);
			passwd_sethook (pam_check_pass,pam_change_pass,pam_check_pair);
		#else
			xconf_notice (MSG_U(N_WRONGVERSION
				,"You have installed a Linuxconf version suited for\n"
				 "RedHat 4.x on a RedHat 5.x system.\n"
				 "Things will operate normally, except for the following\n"
				 "shortcomings:\n"
				 "    -PAM won't be used for user authentication and passwords\n"
				 "     updates.\n"
				 "    -Linuxconf will update the password database itself\n"
				 "     instead of relying on the useradd, userdel and usermod\n"
				 "     utilities.\n"
				 "We suggest you install the proper version. You can \"upgrade\"\n"
				 "by using the -U and --force rpm command line options."));
		#endif
	}
	module_register_api (SERVICECTL_API_KEY,SERVICECTL_API_REV
		,sysv_api_get,sysv_api_release);
}


PUBLIC int MODULE_redhat::dohtml (const char *key)
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(key,"redhat")==0){
		// ### Insert any menu and dialog here
		ret = 0;
	}
	return ret;
}


static void usage()
{
	xconf_error (MSG_U(T_USAGE
		,"Module redhat\n"
		 "linuxconf --modulemain redhat [ specific options ]\n"
		 "\n")
		);
}

PUBLIC int MODULE_redhat::execmain (int argc , char *argv[], bool)
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"redhat")==0){
		ret = -1;
		if (argc == 1){
			// ### Place call to main menu of the module
		}else{
			// ### Add some option parsing for the module
			::usage();
		}
	}
	return ret;
}

static const char K_CHECK_PACKAGE[]="check_package";

enum RHPKG_CMD {
	RHPKG_INSTALL,	// The package must be installed
	RHPKG_CHECK,	// Check if the package is installed
	RHPKG_REQUEST,	// CHeck if the package is installed and
					// ask the user if he want to proceed
					// This test is done only once so the admin
					// is allowed to say "no" forever
};

static int redhat_checkpkg (RHPKG_CMD cmd, int argc, const char *argv[])
{
	int ret = -1;
	struct LOGPACKAGE{
		const char *logical;
		const char *realpkg;
		const char *title;
		int release;		// For which redhat release this line applies
							// 0 means anyone.
							// release == 6, means it applies to rh6 and up
							// including rh7, unless there is a line
							// in tblk with release == 7.
							// This explains why 0 match every release
		int cdnumber;		// On which CD is it located
	};
	// This table is order from higher release to lower
	static const LOGPACKAGE tblk[]={
		{"dnsserver",	"bind",	MSG_U(I_BINDDESC,"Domain name server (DNS)"),0,1},
		{"popserver",	"imap",	MSG_U(I_IMAPDESC,"POP-3 and IMAP mail servers"),700,2},
		{"popserver",	"imap",	MSG_R(I_IMAPDESC),0,1},
		{"dhcpserver",	"dhcp",	MSG_U(I_DHCPDESC,"Dynamic host configuration protocol server (DHCP)"),700,2},
		{"dhcpserver",	"dhcp",	MSG_R(I_DHCPDESC),0,1},
		{"nfsserver",	"nfs-utils",MSG_U(I_NFSDESC,"Network file system server (NFS)"),0,1},
		{"xfsserver",	"XFree86-xfs",MSG_U(I_XFSDESC,"X font server (XFS)"),0,1},
		{"portmap",		"portmap",MSG_U(I_PORTMAPDESC,"RPC port mapper"),0,1},
		{"nisserver",	"ypserv",MSG_U(I_YPSERVDESC,"NIS server"),0,1},
		{"nisclient",	"ypbind",MSG_U(I_YPCLIENTDESC,"NIS client"),0,1},
		{NULL,NULL,NULL,0,0},
	};
	int release = redhat_release();
	// Try to locate the information about the package. If the information
	// is missing, we assume the name of the package is the logical name
	// and it is on CD 1
	const char *logical_name = argv[0];
	LOGPACKAGE dummy = {logical_name,logical_name,logical_name,0,1};
	const LOGPACKAGE *log = &dummy;
	for (int i=0; tblk[i].logical != NULL; i++){
		if (strcmp(tblk[i].logical,logical_name)==0
			&& tblk[i].release <= release){
			log = tblk+i;
			break;
		}
	}
	const char *rhpkg = log->realpkg;
	PACKAGE_API *pkg_api = package_api_init ("redhat/redhat.cc");
	if (pkg_api != NULL){
		if (cmd == RHPKG_REQUEST){
			// Check if a given logical package is installed and trigger
			// the installation if not.
			ret = 0;
			if (linuxconf_getvalnum (K_CHECK_PACKAGE,logical_name,0)==0){
				PACKAGE_VERSION res;
				if (pkg_api->getver (pkg_api, rhpkg, res)==-1){
					// Ok time to install
					SSTRING q;
					q.setfromf (MSG_U(Q_INSTALLPKG
						,"The following package is not currently installed\n"
						 "\n"
						 "\t%s: %s\n"
						 "\n"
						 "would you like to install it now ?")
						,rhpkg,log->title);
					if (xconf_yesno (MSG_U(T_INSTALLPKG,"Suggested package")
						,q.get(),help_installpkg)==MENU_YES
						&& perm_rootaccess (MSG_U(P_INSTALLPKG,"install packages"))){	
						redhat_checkpkg (RHPKG_INSTALL,argc,argv);
					}
				}
			}
			// Make sure we do not ask this twice to the user
			linuxconf_replace (K_CHECK_PACKAGE,logical_name,1);
			perm_setbypass (true);
			linuxconf_save();
			perm_setbypass (false);
		}else if (cmd == RHPKG_CHECK){
			// Check if a given logical package is installed
			// Check if it is a package we know
			PACKAGE_VERSION res;
			if (pkg_api->getver (pkg_api, rhpkg, res)!=-1){
				ret = 0;
			}
		}else if (cmd == RHPKG_INSTALL){
			SSTRINGS tb;
			tb.add (new SSTRING(rhpkg));
			const char *cdpath;
			SSTRING cdtitle;
			if (redhat_ismdk()){
				cdpath = "/mnt/cdrom/Mandrake/RPMS";
				int mdkrel = redhat_mdkrelease();
				cdtitle.setfromf (MSG_U(I_MDKCD,"Mandrake release %d.%d CDROM %d")
					,mdkrel/100,mdkrel%100,log->cdnumber);
			}else{
				cdpath = "/mnt/cdrom/RedHat/RPMS";
				cdtitle.setfromf (MSG_U(I_RHCD,"RedHat release %d.%d CDROM %d")
					,release/100,release%100,log->cdnumber);
			}
			ret = pkg_api->installpkgs (pkg_api,tb,cdpath,cdtitle.get());
		}
		package_api_end (pkg_api);
	}
	return ret;
}




PUBLIC int MODULE_redhat::message (const char *msg, int argc , const char *argv[])
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(msg,"request_package")==0){
		ret = redhat_checkpkg (RHPKG_REQUEST,argc,argv);
	}else if (strcmp(msg,"check_package")==0){
		ret = redhat_checkpkg (RHPKG_CHECK,argc,argv);
	}else if (strcmp(msg,"install_package")==0){
		ret = redhat_checkpkg (RHPKG_INSTALL,argc,argv);
	}else if (strcmp(msg,"servicectl")==0 && argc >= 2){
		const char *service = argv[0];
		if (strcmp(service,"nameserver")==0) service = "named";
		SSTRING tmp;
		tmp.setfromf ("/etc/rc.d/init.d/%s %s",service,argv[1]);
		ret = netconf_system (10,tmp.get());
		
	}
	return ret;
}
		
	


static MODULE_redhat redhat;

const char *vendor_getid()
{
	return "Red Hat Software";
}

const char *vendor_getdistid()
{
	int release = redhat_release();
	const char *ret = "";
	if (release == 601){
		ret = "BlueSky";
	}else if (release == 600){
		ret = "BlueSky";
	}else if (release == 502){
		ret = "Manhattan";
	}else if (release == 501){
		ret = "Manhattan";
	}else if (release == 500){
		ret = "Hurricane";
	}else if (release == 402){
		ret = "Biltmore";
	}
	return ret;
}

