#ifndef PACKAGE_API_H
#define PACKAGE_API_H

#include <module_apis/package_apidef.h>
static const char PACKAGE_API_KEY[]="package";
static const int  PACKAGE_API_REV=4;

inline PACKAGE_API *package_api_init(const char *client)
{
	return (PACKAGE_API*)module_get_api (PACKAGE_API_KEY,PACKAGE_API_REV
		,client);
}

inline void package_api_end(PACKAGE_API *api)
{
	module_release_api (PACKAGE_API_KEY,(void*)api);
}

inline bool package_api_available(const char *client)
{
	return module_api_available (PACKAGE_API_KEY,PACKAGE_API_REV,client);
}


#endif

