#include <string.h>
#include "modemconf.h"
#include "modemconf.m"
#include <unistd.h>
#include "wv/wvmodemscan.h"
#include <module_apis/devconf_apidef.h>

#define UNKNOWN_DEV 4
#define STR_MAX     256

class MODEM {
	int  dev;	/* device: /dev/ttyS{0,1,2,3} */
	int  irq;	/* not yet ;) */
public:
	MODEM (void);
	int  get_device (void);
	void set_device (int dev);
	int  detect_device (void);
};

MODEM::MODEM (void)
{
	dev = irq = 0;
}

int MODEM::get_device (void)
{
	char buf[STR_MAX];
	int ret, get_dev;

	dev = UNKNOWN_DEV;

	ret = readlink ("/dev/modem", buf, sizeof buf);
	if (ret != -1) {
		buf[ret] = '\0';
		if (sscanf (buf, "/dev/ttyS%d", &get_dev) ||
		    sscanf (buf, "ttyS%d", &get_dev)      ||
		    sscanf (buf, "/dev/cua%d", &get_dev)  ||
		    sscanf (buf, "cua%d", &get_dev))
			if (get_dev >= 0 && get_dev <= 3)
				dev = get_dev;
	}

	return dev;
}

void MODEM::set_device (int new_dev)
{
	static char new_link[STR_MAX];
	
	dev = new_dev;

	if (dev != UNKNOWN_DEV) {
		unlink ("/dev/modem");
		snprintf (new_link, sizeof(new_link)-1, "/dev/ttyS%d", dev);
		symlink (new_link, "/dev/modem");
	}
}

int MODEM::detect_device (void)
{
	DIALOG *dia = new DIALOG();
	dia->settype (DIATYPE_POPUP);
	int gauge = 0;
	WvModemScanList l;
	int nbiter = l.iterations_left();
	dia->newf_gauge ("",gauge,nbiter);
	while (!l.isdone()){
		int nof = 0;
		dia->show (MSG_U(T_WAIT,"Wait")
			,MSG_U(I_PROGRESS,"Detection in progress...")
			,help_nil, nof, 0);
		diagui_flush();
		l.execute();
		gauge = nbiter - l.iterations_left();
		dia->reload();
	}
	if (l.count() < 1){
		delete dia;
		xconf_notice (MSG_U(N_NOMODEM,"No modem detected!"));
		return UNKNOWN_DEV;
	}
	WvModemScanList::Iter i(l);
	i.rewind();
	i.next();
	WvModemScan &m = i;
	const char *dev_filename = m.filename();
	delete dia;
	xconf_notice (MSG_U(N_MODEM,"Modem detected in %s!"),dev_filename);
	int dev;
	sscanf (dev_filename,"/dev/ttyS%d",&dev);
	return dev;
}

void modemconf_edit (void)
{
	DIALOG dia;
	MODEM  modem;
	char   dev = modem.get_device ();
	int nof = 0;

	for (int i=0; i < UNKNOWN_DEV+1; i++) {
		char msg[STR_MAX];
		snprintf (msg, sizeof(msg)-1, MSG_U(F_DEVICE, "/dev/ttyS%d (COM%d under DOS)"), i, i+1);
		dia.newf_radio ("", dev, i, i == UNKNOWN_DEV ? MSG_U(F_UNKNOWN, "Unknown") : msg);
	}
	dia.setbutinfo(MENU_USR1,"Detect","Detect");
	while (1){
		MENU_STATUS code = dia.edit (
			MSG_U(T_MODEMCONF, "Modem Configurator")
			,MSG_U(I_MODEMCONF,"Select the port to which your modem is connected.\n"
				"If you have no modem, select <Unknown>")
			,help_nil
			,nof
			,MENUBUT_ACCEPT|MENUBUT_CANCEL|MENUBUT_USR1);
		if (code == MENU_QUIT || code == MENU_ESCAPE || code == MENU_CANCEL){
			break;
		}else if (code == MENU_ACCEPT
			&& perm_rootaccess (MSG_U(P_SELDEV,"Select the modem device"))){
			modem.set_device (dev);
			break;
		}else if (code == MENU_USR1
			&& perm_rootaccess (MSG_U(P_QRYDEV,"Query serial devices"))){
			dev = modem.detect_device();
			dia.reload();
		}
	}
}

static int modem_probe(DEVCONF_TYPE type, SSTRINGS &tb)
{
	int ret = -1;
	if (type == DEVCONF_MODEM){
		MODEM modem;
		int dev = modem.detect_device();
		if (dev != UNKNOWN_DEV){
			SSTRING *s = new SSTRING;
			s->setfromf ("/dev/ttyS%d",dev);
			tb.add (s);
			ret = 1;
		}else{
			ret = 0;
		}
	}
	return ret;
}

void *modem_devconf_api_get()
{
	DEVCONF_API *api = new DEVCONF_API;
	api->probe = modem_probe;
	return api;
}

void modem_devconf_api_release(void *api)
{
	delete (DEVCONF_API*)api;
}

