
#include <stdio.h>
#include <string.h>
#include <translat.h>

#include <stdlib.h>

#include "marsconf.h"
#include "marsconf.m"
#include "mc_definitions.h"
#include "mc_parser.h"
#include "mc_macros.h"
#include "mc_tools.h"

#include "fviews.h"

int askuser_for_deletion(void);
void warnuser_duplicated_entry(void);
void warnuser_invalid_data_entered(void);
void warnuser_with_this(const char *my_title, const char *my_text);

#include "mc_dialog_drives.cc"
#include "mc_dialog_ipxdevs.cc"
#include "mc_dialog_users.cc"
#include "mc_dialog_queues.cc"
#include "mc_dialog_prtserv.cc"
#include "mc_dialog_options.cc"

/* return !=0 if user accepted */
int askuser_for_deletion(void)
{
    if(dialog_yesno(MSG_U(T_DELETINGITEM, "Deleting item"), MSG_U(Q_DELETINGITEM, "Confirm this item's deletion?"), help_nil)==MENU_YES){
        return(1);
    } else {
        return(0);
    }
    return(1);
}

void warnuser_duplicated_entry(void)
{
    xconf_error(MSG_U(E_ENTRYEXISTSALREADY, "This entry already exists!\n\nName it differently.\n"));
}

void warnuser_invalid_data_entered(void)
{
    xconf_error(MSG_U(E_UNACCENTRYTYPED, "Invalid data was typed in one or more fields.\n\nMost fields can't have space characters or be empty.\nCertain fields accept only digits or capital letters.\n\nRead the help section for more information.\n"));
}

void menu_ipx(void)
{
    MENU_STATUS my_button=MENU_STATUS(0);
    int    my_selection=0;
    DIALOG_MENU dia_mymenu;

    dia_mymenu.new_menuitem("", MSG_U(M_IPXDEVS, "IPX devices"));
    dia_mymenu.new_menuitem("", MSG_U(M_NETWOPTS, "Network options"));

    while(1){
        my_button=dia_mymenu.editmenu(MSG_U(T_NETWDEVS, "Network devices (IPX)"), "", help_nil, my_selection, MENUBUT_QUIT);

        if((my_button==MENU_QUIT)||(my_button==MENU_ESCAPE))
            return;

        switch(my_selection){
        case 0:
            section_edit_ipxdevs();
            break;
        case 1:
            section_edit_network_opts();
            break;
        default:
            break;
        }
    }
}

void menu_accounting(void)
{
    MENU_STATUS my_button=MENU_STATUS(0);
    int    my_selection=0;
    DIALOG_MENU dia_mymenu;

    dia_mymenu.new_menuitem("", MSG_U(M_USERSLIST, "Users' list"));
    dia_mymenu.new_menuitem("", MSG_U(M_ACCOUNTINGOPTS, "Accounting options"));
    dia_mymenu.new_menuitem("", MSG_U(M_SUPRVSROPTS, "Supervisor options"));

    while(1){
        my_button=dia_mymenu.editmenu(MSG_U(T_ACCOUNTINGUSERACC, "Accounting and user access"), "", help_nil, my_selection, MENUBUT_QUIT);

        if((my_button==MENU_QUIT)||(my_button==MENU_ESCAPE))
            return;

        switch(my_selection){
        case 0:
            section_edit_users();
            break;
        case 1:
            section_edit_accounting_opts();
            break;
        case 2:
            section_edit_supervisor_opts();
            break;
        default:
            break;
        }
    }
}

void menu_print(void)
{
    MENU_STATUS my_button=MENU_STATUS(0);
    int    my_selection=0;
    DIALOG_MENU dia_mymenu;

    dia_mymenu.new_menuitem("", MSG_U(M_PRTQUEUES, "Print queues"));
    dia_mymenu.new_menuitem("", MSG_U(M_PRTSERVERS, "Print servers"));
    dia_mymenu.new_menuitem("", MSG_U(M_PRTSERVICESOPTS, "Print services' options"));

    while(1){
        my_button=dia_mymenu.editmenu(MSG_U(T_PRTSERVICES, "Print services"), "", help_nil, my_selection, MENUBUT_QUIT);

        if((my_button==MENU_QUIT)||(my_button==MENU_ESCAPE))
            return;

        switch(my_selection){
        case 0:
            section_edit_queues();
            break;
        case 1:
            section_edit_prtserv();
            break;
        case 2:
            section_edit_print_opts();
            break;
        default:
            break;
        }
    }
}


void menu_volumes(void)
{
    MENU_STATUS my_button=MENU_STATUS(0);
    int    my_selection=0;
    DIALOG_MENU dia_mymenu;

    dia_mymenu.new_menuitem("", MSG_U(M_VOLUMES, "Volumes"));
    dia_mymenu.new_menuitem("", MSG_U(M_FILESERVOPTS, "File server options"));

    while(1){
        my_button=dia_mymenu.editmenu(MSG_U(T_VOLUMESANDFILESERV, "Volumes and file server"), "", help_nil, my_selection, MENUBUT_QUIT);

        if((my_button==MENU_QUIT)||(my_button==MENU_ESCAPE))
            return;

        switch(my_selection){
        case 0:
            section_edit_drives();
            break;
        case 1:
            section_edit_fileserv_opts();
            break;
        default:
            break;
        }
    }
}

void main_window(void)
{
    MENU_STATUS my_button=MENU_STATUS(0);
    int    my_selection=0;
    DIALOG_MENU dia_mymenu;

    dia_mymenu.new_menuitem("", MSG_U(M_ACCOUNTINGUSERACC, "Accounting and user access"));
    dia_mymenu.new_menuitem("", MSG_U(M_VOLUMESANDFILESERV, "Volumes and file server"));
    dia_mymenu.new_menuitem("", MSG_U(M_PRTSERVICES, "Print services"));
    dia_mymenu.new_menuitem("", MSG_U(M_NETWORKDEVS, "Network devices (IPX)"));
    dia_mymenu.new_menuitem("", MSG_U(M_MISC, "Misc options"));

    while(1){
        my_button=dia_mymenu.editmenu(MSG_U(T_MARSCONFIGURATOR, "Mars configurator"), "", help_nil, my_selection, MENUBUT_QUIT);

        if((my_button==MENU_QUIT)||(my_button==MENU_ESCAPE))
            return;

        switch(my_selection){
        case 1:
            menu_volumes();
            break;
        case 3:
            menu_ipx();
            break;
        case 0:
            menu_accounting();
            break;
        case 2:
            menu_print();
            break;
        case 4:
            section_edit_misc_opts();
        default:
            break;
        }
    }
}

