//
// This module was implemented by Gustavo Niemeyer <niemeyer@conectiva.com>
//

#pragma implementation
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <translat.h>
#include "kernelconf.h"
#include "kernelconf.m"
#include "sysctl.h"

MODULE_DEFINE_VERSION(kernelconf);

PUBLIC MODULE_kernelconf::MODULE_kernelconf()
	: LINUXCONF_MODULE("kernelconf")
{
	linuxconf_loadmsg ("kernelconf",PACKAGE_REV);
}


static const char *keymenu=NULL;

PUBLIC void MODULE_kernelconf::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
	if (context == MENU_MISCSERV){
		keymenu = MSG_U(M_kernelconf,"Kernel Configuration");
		dia.new_menuitem ("kernelconf","",keymenu);
	}
}

PUBLIC int MODULE_kernelconf::domenu (
	MENU_CONTEXT context,
	const char *key)
{
	if (context == MENU_MISCSERV){
		if (key == keymenu){
			kernelconf_edit();
		}
	}
	return 0;
}


PUBLIC int MODULE_kernelconf::dohtml (const char *key)
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(key,"kernelconf")==0){
		// ### Insert any menu and dialog here
		ret = 0;
	}
	return ret;
}

PUBLIC int MODULE_kernelconf::probe (int level, int runlevel, bool sim)
{
	if (level == 2){
		kernelconf_probe(sim);
	}
	return LNCF_NOT_APPLICABLE;
}

static void usage()
{
	xconf_error (MSG_U(T_USAGE,"Module kernelconf\n"
		"linuxconf --modulemain kernelconf [ specific options ]\n"
		"\n"
		"    --set <option> <value>\n"
		"    --settofile <option> <value>\n"
		"    --settosys <option> <value>\n"
		"    --setdefault <option>\n"
		"    --getfromfile <option>\n"
		"    --getfromsys <option>\n"
		"\n"
		));
}

PUBLIC int MODULE_kernelconf::message (
	const char *msg,
	int argc,
	const char *argv[])
{
        int ret = LNCF_NOT_APPLICABLE;
        if (strcmp(msg,"about")==0){
                ret = 0;
                SSTRINGS *tb = (SSTRINGS*)argv[0];
                tb->add (new SSTRING(MSG_U(A_ABOUT1,"Module kernelconf was written by Gustavo Niemeyer (niemeyer@conectiva.com)")));
	}
        return ret;
}

PUBLIC void MODULE_kernelconf::usage (SSTRINGS &tb)
{
	tb.add (new SSTRING (MSG_R(T_USAGE)));
}

PUBLIC int MODULE_kernelconf::execmain (int argc , char *argv[], bool)
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"kernelconf")==0){
		ret = -1;
		if (argc == 1){
			while (1){
				if (kernelconf_edit() == -1) break;
				if (netconf_checkupdate(true)!=2) break;
			}
		}else{
			for (int i = 1; i < argc; i++){
				if (i+2 < argc && strcmp(argv[i],"--set") == 0){
					SYSCTL sysctl;
					sysctl.set(argv[i+1],argv[i+2]);
					i+=2;
				}else if (i+2 < argc && strcmp(argv[i],"--settofile") == 0){
					SYSCTL sysctl;
					sysctl.set_to_file(argv[i+1],argv[i+2]);
					i+=2;
				}else if (i+2 < argc && strcmp(argv[i],"--settosys") == 0){
					SYSCTL sysctl;
					sysctl.set_to_sys(argv[i+1],argv[i+2]);
					i+=2;
				}else if (i+1 < argc && strcmp(argv[i],"--setdefault") == 0){
					SYSCTL sysctl;
					sysctl.erase(argv[i+1]);
					i++;
				}else if (i+1 < argc && strcmp(argv[i],"--getfromfile") == 0){
					SYSCTL sysctl;
					const char *val = sysctl.get_from_file(argv[i+1]);
					if (val == NULL){
						fprintf(stderr,MSG_U(E_NOTDEFINED,"Variable not defined!\n"));
					}else{
						printf("%s\n",val);
					}
					i++;
				}else if (i+1 < argc && strcmp(argv[i],"--getfromsys") == 0){
					SYSCTL sysctl;
					const char *val = sysctl.get_from_sys(argv[i+1]);
					if (val == NULL){
						fprintf(stderr,MSG_U(E_NOTFOUND,"Option not found!\n"));
					}else{
						printf("%s\n",val);
					}
					i++;
				}else{
					::usage();
				}
			}
		}
	}
	return ret;
}


static MODULE_kernelconf kernelconf;

