#ifndef isapnpconf_h
#define isapnpconf_h
#pragma interface
#ifndef MISC_H
    #include <misc.h>
#endif
#ifndef MODULE_H
    #include <module.h>
#endif

#include <modapi_def.h>
#include <modapi.h>
#include "struct.h"
#include "header.h"
#include "define.h"
#include "isapnpconf.m"

class MODULE_isapnpconf: public LINUXCONF_MODULE{
    /*~PROTOBEG~ MODULE_isapnpconf */
public:
	MODULE_isapnpconf (void);
	int add (SSTRINGS&isapnp);
	struct pcard *add_card (void);
	struct configure *add_configure (void);
	struct s_dma *add_dma (void);
	struct s_io *add_io (void);
	struct s_irq *add_irq (void);
	struct settings *add_setting (void);
	int backup_file (void);
	void clean_struct (void);
	int create_struct (SSTRINGS&isapnp);
	int detec (SSTRINGS&isapnp, SSTRINGS&log);
	int dohtml (const char *key);
	int domenu (MENU_CONTEXT context,
		 const char *key);
	int execmain (int argc,
		 char *argv[],
		 bool);
	struct pcard *get_card (int n);
	struct configure *get_configure (struct pcard *c,
		 int n);
	struct s_dma *get_dma (struct settings *s,
		 int n);
	struct s_io *get_io (struct settings *s,
		 int n);
	struct s_irq *get_irq (struct settings *s,
		 int n);
	int get_n_card (void);
	int get_n_configure (struct pcard *c);
	int get_n_dma (struct settings *s);
	int get_n_io (struct settings *s);
	int get_n_irq (struct settings *s);
	int get_n_settings (struct configure *c);
	struct settings *get_setting (struct configure *c,
		 int n);
	int isapnpconf_edit (void);
	void isapnpconf_start (void);
	SSTRINGS *populate_settings (struct configure *cfg,
		 int nSet,
		 int &set_in_use);
	void print_all_struct (void);
	void print_struct (void);
	int read_a_setting (int &line,
		 settings *tset,
		 SSTRINGS&ss);
	void read_card_header (int &line,
		 struct pcard *tcard,
		 SSTRINGS&ss);
	void read_configure (struct pcard *tcard,
		 struct configure *dat,
		 int &line,
		 SSTRINGS&ss);
	void read_end_configure (struct configure *dat,
		 int &line,
		 SSTRINGS&ss);
	int read_file (SSTRINGS&ss);
	void read_file_header (const char *cont);
	int rewrite_isapnp (void);
	int save_file (SSTRINGS&ss);
	void setmenu (DIALOG&dia,
		 MENU_CONTEXT context);
	void usage (SSTRINGS&tb);
    /*~PROTOEND~ MODULE_isapnpconf */
};

#include "isapnpconf.p"

#endif
