
#ifndef GRUBCONFFILE_H
#define GRUBCONFFILE_H

#include <fviews.h>
#include "grubconf.h"

enum GRUBVAR {
	GRUBVAR_GLOBAL,
	GRUBVAR_TITLE,
	GRUBVAR_SCRIPT
};

extern const char *command_order[];
extern int total_commands;

class GRUB_VI_PARSER : public VIEWITEMS_PARSER
{
	/*~PROTOBEG~ GRUB_VI_PARSER */
public:
	GRUB_VI_PARSER (void);
	void addline (const char *line);
	/*~PROTOEND~ GRUB_VI_PARSER */
};

class GRUBCONFFILE
{
private:
	GRUB_VI_PARSER gvip;
	VIEWITEMS vi;

	char *ind_globals;
	char *ind_titles;
	char *ind_scripts;
	char *sep_globals;
	char *sep_titles;
	char *sep_scripts;

	int haschanged;

	/*~PROTOBEG~ GRUBCONFFILE */
public:
	GRUBCONFFILE (void);
	bool check_script (int pos);
	int count_titles (void);
private:
	void detect_ind_sep (void);
public:
	void erase (int title, const char *var);
private:
	char *extract_indent (VIEWITEM *it);
	char *extract_separator (VIEWITEM *it);
	int find_insert_position (int title,
		 const char *var);
public:
	const char *locate (int title, const char *var);
private:
	VIEWITEM *locate_it (int title, const char *var);
public:
	void update (int title,
		 const char *var,
		 const char *value);
	~GRUBCONFFILE (void);
	/*~PROTOEND~ GRUBCONFFILE */
};

#endif /* GRUBCONFFILE_H */
