#include "dnsconf.h"
#include <string.h>

PUBLIC void UNKNOWN::add (const char *token, const char *comment)
{
	CSSTRING *c = new CSSTRING;
	c->setfrom (token);
	c->setcomment (comment);
	tb.add (c);
}


PUBLIC void UNKNOWN::write (FILE_CFG *fout, int level)
{
	if (tb.getnb() > 0){
		for (int j=0; j<level; j++) fputc ('\t',fout);
		const char *prefix = "";
		for (int i=0; i<tb.getnb(); i++){
			CSSTRING *c = (CSSTRING*)tb.getitem(i);
			const char *token = c->get();
			const char *comment = c->comment.get();
			if (comment[0] != '\0'){
				fprintf (fout,"%s",comment);
				for (int j=1; j<level; j++) fputc ('\t',fout);
				prefix = "\t";
			}
			if (strcmp(token,"{")==0){
				fprintf (fout,"{\n");
				level++;
				for (int j=1; j<level; j++) fputc ('\t',fout);
				prefix = "\t";
			}else if (strcmp(token,"}")==0){
				fprintf (fout,"}");
				level--;
			}else if (strcmp(token,";")==0){
				fprintf (fout,";\n");
				if (i < tb.getnb()-1){
					for (int j=1; j<level; j++) fputc ('\t',fout);
					prefix = "\t";
				}
			}else{
				fputs (prefix,fout);
				prefix = " ";
				fputs (token,fout);
			}
		}
		fprintf (fout,";\n");
	}
}

PUBLIC UNKNOWN *UNKNOWNS::getitem (int no) const
{
	return (UNKNOWN*)ARRAY::getitem (no);
}

PUBLIC void UNKNOWNS::write (FILE_CFG *fout, int level)
{
	for (int i=0; i<getnb(); i++){
		getitem(i)->write(fout,level);
	}
}

