#pragma interface
#ifndef DNSCONF_H
#define DNSCONF_H

#include <limits.h>

class TBFILE;
class RECORD_IN_SOA;
class RECORD_TTL;
class RECORD_IN_NS;
class FQHOST;
class DNS;
class POPEN;
class IP_ADDRS;

#ifndef MISC_H
	#include <misc.h>
#endif

class IN_NAME: public SSTRING{
	/*~PROTOBEG~ IN_NAME */
	/*~PROTOEND~ IN_NAME */
};

#ifndef IPSTUFF_H
	#include <ipstuff.h>
#endif

#define NOTIFY_DEFAULT 2
#define FORWARD_FIRST 0
#define FORWARD_ONLY 1

enum ZONE_TYPE{
	ZONE_UNKNOWN,ZONE_PRIMARY, ZONE_SECONDARY, ZONE_HINT, ZONE_FORWARD, ZONE_STUB
};
/* also defined in dns.cc */

enum RECORD_TYPE{
	RTYPE_COMMENT,
	RTYPE_SOA,
	RTYPE_A,
	RTYPE_PTR,
	RTYPE_NS,
	RTYPE_MX,
	RTYPE_CNAME,
	RTYPE_INCLUDE,
	RTYPE_END_INCLUDE,
	RTYPE_ORIGIN,
	RTYPE_HINFO,
	RTYPE_RP,
	RTYPE_TXT,
	RTYPE_TTL,
};

enum ZONE_DATA_TYPE{
	ZONE_DATA_NONE, ZONE_DATA_IN, ZONE_DATA_CHAOS,
	ZONE_DATA_HS, ZONE_DATA_HESIOD
};

class RECORD: public ARRAY_OBJ{
public:
	RECORD_TYPE id;		// Used by the function is() to identify
				// the type of a record
	SSTRING comment;
	//virtual IP_ADDR *getip()const =0;
	//virtual IN_NAME *getname() const =0;
	virtual void print (FILE_CFG *fout) const =0;
	/*~PROTOBEG~ RECORD */
public:
	RECORD (RECORD_TYPE _id);
	int cmp (RECORD *other);
	virtual int cmp_left (const char *);
	virtual int cmp_right (const char *);
protected:
	virtual int cmpsame (const RECORD *);
public:
	virtual const char *get_left (void);
	bool is (RECORD_TYPE _id);
	virtual int set (const RECORD *);
	void setcomment (const char *str);
	virtual void sethostpart (const char *);
	/*~PROTOEND~ RECORD */
};

class RECORD_COMMENT: public RECORD{
	/*~PROTOBEG~ RECORD_COMMENT */
public:
	RECORD_COMMENT (const char *str);
	void print (FILE_CFG *fout)const;
	/*~PROTOEND~ RECORD_COMMENT */
};

class RECORD_PARSE;

class RECORD_IN: public RECORD{
protected:
	char ttlstr[20];
	/*~PROTOBEG~ RECORD_IN */
public:
	RECORD_IN (RECORD_TYPE _id);
	RECORD_IN (const RECORD_PARSE&p, RECORD_TYPE _id);
	const char *getttl (void);
	void setttl (const SSTRING *s);
	void setttl (const char *s);
	/*~PROTOEND~ RECORD_IN */
};

class RECORD_IN_A: public RECORD_IN{
public:
	IN_NAME name;
	IP_ADDR addr;
	/*~PROTOBEG~ RECORD_IN_A */
public:
	RECORD_IN_A (const RECORD_PARSE&p);
	RECORD_IN_A (const char *_name, const char *_addr);
protected:
	int cmp_left (const char *str);
	int cmp_right (const char *str);
public:
	int cmphost (const char *host);
protected:
	int cmpsame (const RECORD *other);
public:
	virtual const char *get_left (void);
	void print (FILE_CFG *fout)const;
	int set (const RECORD *other);
	void sethostpart (const char *hostpart);
	void setip (const char *ip);
	/*~PROTOEND~ RECORD_IN_A */
};
class RECORD_IN_PTR: public RECORD_IN{
public:
	IN_NAME name;
	IN_NAME addr;
	/*~PROTOBEG~ RECORD_IN_PTR */
public:
	RECORD_IN_PTR (const RECORD_PARSE&p);
	RECORD_IN_PTR (const char *iprev,
		 const char *host);
protected:
	int cmp_left (const char *str);
	int cmp_right (const char *str);
public:
	int cmpip (const char *ip);
protected:
	int cmpsame (const RECORD *other);
public:
	void print (FILE_CFG *fout)const;
	int set (const RECORD *other);
	void sethostpart (const char *hostpart);
	/*~PROTOEND~ RECORD_IN_PTR */
};

class RECORD_IN_HINFO: public RECORD_IN{
public:
	IN_NAME name;
	SSTRING info;
	/*~PROTOBEG~ RECORD_IN_HINFO */
public:
	RECORD_IN_HINFO (const char *_name,
		 const char *_info);
protected:
	int cmpsame (const RECORD *other);
public:
	void print (FILE_CFG *fout)const;
	/*~PROTOEND~ RECORD_IN_HINFO */
};

class RECORD_IN_RP: public RECORD_IN{
public:
	IN_NAME name;
	SSTRING rp;
	/*~PROTOBEG~ RECORD_IN_RP */
public:
	RECORD_IN_RP (const char *_name, const char *_rp);
protected:
	int cmpsame (const RECORD *other);
public:
	void print (FILE_CFG *fout)const;
	/*~PROTOEND~ RECORD_IN_RP */
};

class RECORD_IN_TXT: public RECORD_IN{
public:
	IN_NAME name;
	SSTRING txt;
	/*~PROTOBEG~ RECORD_IN_TXT */
public:
	RECORD_IN_TXT (const char *_name,
		 const char *_txt);
protected:
	int cmpsame (const RECORD *other);
public:
	void print (FILE_CFG *fout)const;
	/*~PROTOEND~ RECORD_IN_TXT */
};


class RECORDS: public ARRAY{
	/*~PROTOBEG~ RECORDS */
public:
	RECORD *getitem (int no)const;
	int save (TBFILE&tbf)const;
	/*~PROTOEND~ RECORDS */
};

class ORIGIN: public ARRAY_OBJ{
public:
	SSTRING origin;
	RECORDS tbrec;
	/*~PROTOBEG~ ORIGIN */
public:
	ORIGIN (const char *_origin);
	int getalladr (IP_ADDRS&adrs);
	void print (bool save_ori, TBFILE&tbf)const;
	int was_modified (void);
	/*~PROTOEND~ ORIGIN */
};

class ORIGINS: public ARRAY{
	/*~PROTOBEG~ ORIGINS */
public:
	ORIGIN *getitem (int no)const;
private:
	int parseend (char *pt,
		 RECORD_PARSE&p,
		 ORIGIN *ori);
	int parsespecial (const char *key,
		 const char *pt,
		 const char *first_origin,
		 TBFILE&tbf,
		 ORIGIN *&ori);
public:
	int read (const char *named_dir,
		 const char *fname,
		 const char *first_origin,
		 bool extract);
	int save (const char *named_dir,
		 const char *fname)const;
	/*~PROTOEND~ ORIGINS */
};

class PRIMARY_EDITINFO;

class ZONE: public ARRAY_OBJ{
public:
	SSTRING domain;
	SSTRING domainv;	// Use to present the domain
				// to the user, differ from domain
				// only for reverse mapping .. so far
	SSTRING file;
	ORIGINS origins;	// origins->getitem(0) is set by default
				// to the domain.
	char isrev;		// Tell if it is a domain or reverse
				// mapping primary.
	SSTRINGS allowquery;
	SSTRINGS allowrecursion;
	SSTRINGS allowtrans;
	SSTRINGS allowupdate;
	SSTRINGS alsonotify;
	char notify;
	char option_forward_only;
	ZONE_TYPE zonetype;	// ZONE_PRIMARY ,ZONE_SECONDARY, ZONE_STUB, ZONE_FORWARD
	ZONE_DATA_TYPE datatype; // ZONE_DATA_NONE, ZONE_DATA_IN, ZONE_DATA_CHAOS
	bool transfered;  	// Is secondary already transfered
	IP_ADDRS addrs; 	//for secondary
	/*~PROTOBEG~ ZONE */
public:
	ZONE (void);
	void addrec (RECORD *rec);
protected:
	void del_extrainfo (void);
public:
	void edithosts (DNS&dns);
	int editshow (DNS&dns, bool readonly, SSTRING *range);
	void format_revision (char *buf);
	int geta (SSTRING&dom, IP_ADDRS&adrs, SSTRINGS&ttls);
	int geta (SSTRING&dom, RECORDS&recs);
	int getalladr (IP_ADDRS&adrs);
	int getcname (SSTRING&dom, SSTRING&cname);
	RECORD_TTL *getdefaultttl (void);
	virtual const char *getdomain_norange (void);
private:
	RECORD *getfirst (RECORD_TYPE rtype)const;
public:
	int getmx (SSTRING&dom,
		 SSTRINGS&strs,
		 SSTRINGS&ttls);
	int getmx (SSTRING&dom, RECORDS&recs);
	int getns (SSTRING&dom,
		 SSTRINGS&strs,
		 SSTRINGS&ttls);
	int getns (SSTRING&dom, RECORDS&recs);
	RECORD_IN_SOA *getsoa (void)const;
	void insrec (RECORD *rec);
	virtual bool is_reverse (void);
protected:
	void load_extrainfo (PRIMARY_EDITINFO&info);
public:
	int locate_left (FQHOST&fq,
		 RECORD_TYPE rtype,
		 RECORDS&recs);
	int locate_rev (const char *fullname, IP_ADDRS&tba);
	int locate_right (const char *value,
		 RECORD_TYPE rtype,
		 SSTRINGS&recs);
protected:
	void remove_empty (void);
	void save_extrainfo (PRIMARY_EDITINFO&info);
public:
	int set (FQHOST&fq, RECORD *new_rec);
	virtual void setfromv (void);
	void setupdia (DIALOG&dia,
		 DNS&dns,
		 int level,
		 PRIMARY_EDITINFO&info);
protected:
	void setupzoneaccess (DIALOG&dia, int level);
public:
	void show (DNS&dns);
	int unset (RECORD *new_rec);
	int unset_left (const char *left);
	void updatesoa (void);
	int was_modified (void);
protected:
	void writeaccess (FILE_CFG *fout)const;
public:
	/*~PROTOEND~ ZONE */
};

class PRIMARY: public ZONE{

	/*~PROTOBEG~ PRIMARY */
public:
	PRIMARY (const char *_domain,
		 const char *_file,
		 const char *named_dir,
		 bool extract);
protected:
	PRIMARY (const char *_domain, const char *_file);
public:
	PRIMARY (void);
	virtual int edit (DNS&dns);
	virtual const char *getrange (void)const;
private:
	void init (const char *_domain, const char *_file);
public:
	virtual bool matchrange (const char *);
	void setonemx (FQHOST&fq,
		 const char *mx,
		 int priority,
		 const char *ttl);
	int write (bool bind8,
		 FILE_CFG *fout,
		 const char *named_dir,
		 const DNS *dns)const;
	/*~PROTOEND~ PRIMARY */
};

class PRIMARY_REV: public PRIMARY{
	SSTRING range;		// String identifying the range delegation
						// This is generally x-y (0-64)
	/*~PROTOBEG~ PRIMARY_REV */
public:
	PRIMARY_REV (const char *_domain,
		 const char *_file,
		 const char *named_dir,
		 bool extract);
	PRIMARY_REV (void);
	int edit (DNS&dns);
	const char *getdomain_norange (void);
	const char *getrange (void)const;
	bool is_reverse (void);
	bool matchrange (const char *host);
	void setfromv (void);
	/*~PROTOEND~ PRIMARY_REV */
};


class PRIMARYS: public ARRAY{
	/*~PROTOBEG~ PRIMARYS */
public:
	int adddomain (const char *domain,
		 const char *example,
		 DNS&dns);
	void edit (DNS&dns);
	void editbydom (DNS&dns);
	int getalladr (IP_ADDRS&adrs);
	PRIMARY *getitem (FQHOST&fq,
		 char *hostpart,
		 bool dontitself);
	PRIMARY *getitem (FQHOST&fq, char *hostpart);
	PRIMARY *getitem (const char *name)const;
	PRIMARY *getitem (int no)const;
	int initfrom (DNS&dns,
		 PRIMARY *p,
		 const char *example);
	virtual bool is_reverse (void);
	int locate_right (const char *value,
		 RECORD_TYPE rtype,
		 SSTRINGS&recs);
	virtual PRIMARY *new_PRIMARY (void);
private:
	void setselect (DIALOG&dia, PRIMARYS&sorted);
public:
	int write (bool bind8,
		 FILE_CFG *fout,
		 const char *named_dir,
		 const DNS *dns)const;
	/*~PROTOEND~ PRIMARYS */
};
class PRIMARYS_REV: public PRIMARYS{
	/*~PROTOBEG~ PRIMARYS_REV */
public:
	bool is_reverse (void);
	PRIMARY *new_PRIMARY (void);
	/*~PROTOEND~ PRIMARYS_REV */
};
class SECONDARYS;
class SECONDARY: public ZONE{
	/*~PROTOBEG~ SECONDARY */
public:
	SECONDARY (const char *_domain,
		 const char *_file,
		 const char *named_dir,
		 bool extract,
		 const char **_ip_addr,
		 int nb_ip);
	SECONDARY (void);
	int edit (SECONDARYS&secs, DNS&dns, bool isnew);
private:
	int readzone (const char *named_dir, bool extract);
	void setzonefile (SSTRING&file2,
		 const char *named_dir)const;
public:
	void write (bool bind8,
		 FILE_CFG *fout,
		 const char *named_dir)const;
	/*~PROTOEND~ SECONDARY */
};

class SECONDARYS: public ARRAY{
	/*~PROTOBEG~ SECONDARYS */
public:
	void edit (DNS&dns);
	SECONDARY *getitem (const char *name)const;
	SECONDARY *getitem (int no)const;
	void write (bool bind8,
		 FILE_CFG *fout,
		 const char *named_dir)const;
	/*~PROTOEND~ SECONDARYS */
};

class FORWARD: public ZONE{
	/*~PROTOBEG~ FORWARD */
public:
	FORWARD (const char *_domain,
		 const char **_ip_addr,
		 int nb_ip);
	FORWARD (void);
	int edit (DNS&dns);
	void write (bool bind8, FILE_CFG *fout)const;
	/*~PROTOEND~ FORWARD */
};

class FORWARDS: public ARRAY{
	/*~PROTOBEG~ FORWARDS */
public:
	void edit (DNS&dns);
	FORWARD *getitem (const char *name)const;
	FORWARD *getitem (int no)const;
	void write (bool bind8, FILE_CFG *fout)const;
	/*~PROTOEND~ FORWARDS */
};

class CACHEFILE: public ARRAY_OBJ{
public:
	SSTRING domain;
	SSTRING path;
	/*~PROTOBEG~ CACHEFILE */
public:
	CACHEFILE (const char *_domain, const char *_path);
	void abspath (const char *basepath, char *abspath);
	const char *getname (void);
	/*~PROTOEND~ CACHEFILE */
};
class CACHEFILES: public ARRAY{
public:
	/*~PROTOBEG~ CACHEFILES */
public:
	CACHEFILE *getitem (int no);
	/*~PROTOEND~ CACHEFILES */
};

/* #Specification: dnsconf / forwarders / number of
	dnsconf arbitrarily limit the number of forwarders to 5.
*/
#define MAX_FORWARDERS	5
class BIND8_LEXPARSE;

// Directive unknown to dnsconf
class UNKNOWN: public ARRAY_OBJ{
	SSTRINGS tb;
	/*~PROTOBEG~ UNKNOWN */
public:
	void add (const char *token, const char *comment);
	void write (FILE_CFG *fout, int level);
	/*~PROTOEND~ UNKNOWN */
};

class UNKNOWNS: public ARRAY{
	/*~PROTOBEG~ UNKNOWNS */
public:
	UNKNOWN *getitem (int no)const;
	void write (FILE_CFG *fout, int level);
	/*~PROTOEND~ UNKNOWNS */
};

struct DNS_OPTIONS{
	char forward_only;
	char no_recursion;
	char no_fetch_glue;
	char query_log;
	char fake_iquery;
	char notify;
	SSTRINGS listenon;
	SSTRING listenonport;
	SSTRINGS allowtrans;
	SSTRINGS allowquery;
	SSTRINGS allowrecursion;
	UNKNOWNS unknowns;
};

class ACLS;

class ADDRESS_MATCH: public ARRAY_OBJ {
public:
	CSSTRING name;
	SSTRING netsize; // 32=host 24=C class...
	/*~PROTOBEG~ ADDRESS_MATCH */
public:
	ADDRESS_MATCH (const char *_ip,
		 const char *_netsize,
		 const char *comment);
	ADDRESS_MATCH (const char *_ip,
		 const char *comment);
	ADDRESS_MATCH (void);
	int edit (const ACLS&acls);
	bool is_any (void);
	bool is_empty (void);
	bool is_localnet (void);
	bool is_none (void);
	void write (FILE_CFG *fout);
	/*~PROTOEND~ ADDRESS_MATCH */
};

class ACL: public ARRAY{
public: 
	SSTRING name; // name of address match list
	/*~PROTOBEG~ ACL */
public:
	ACL (const char *_name);
	int edit (DNS&dns, const ACLS&acls);
	int editname (void);
	ADDRESS_MATCH *getitem (int no)const;
	bool is_empty (int val)const;
	void write (FILE_CFG *fout);
	/*~PROTOEND~ ACL */
};

class ACLS: public ARRAY{
	/*~PROTOBEG~ ACLS */
public:
	int edit (DNS&dns);
	bool exist (const char *name)const;
	ACL *getitem (int no)const;
	int locate (const char *name)const;
	void write (FILE_CFG *fout);
	/*~PROTOEND~ ACLS */
};

// Currently, we do not edit that information, so we store it
// a tb to be able to rewrite it back.
class LOGGING: public UNKNOWN{
	/*~PROTOBEG~ LOGGING */
	/*~PROTOEND~ LOGGING */
};

class DNS: public ARRAY_OBJ{
	SSTRING pathcfg;		// Effective directory + chroot
	SSTRING pathcfg_conf;	// Configured directory setting
	CACHEFILES cachefiles;
	PRIMARYS primarys;
	PRIMARYS_REV primarys_rev;
	SECONDARYS secondarys;
	FORWARDS zones_forward;
	SSTRINGS forwarders;
	SSTRING xfernets;
	SSTRING bogusns;
	SSTRING searchlist;
	DNS_OPTIONS options;
	ACLS acls;
	LOGGING logging;
	UNKNOWNS unknowns;
public:
	bool bind8;		// Is it a bind8 or bind4 configuration
	/*~PROTOBEG~ DNS */
public:
	DNS (bool extract);
private:
	DNS (const DNS&);
public:
	DNS (void);
	void basiccheck (void);
	void check (void);
private:
	int check_dup (SSTRING&full,
		 IP_ADDRS&tba,
		 char doreverse[]);
public:
	bool condset (const char *hostname,
		 const char *tbip[],
		 int nbip,
		 bool test);
	int deldomain (const char *domain);
	int delsecondary (const char *domain);
	int edit (void);
	void editaccess (void);
	void editfeatures (void);
	void editforwarders (void);
	void editmxs (void);
	void editone (const char *name);
private:
	void editone_rev (SSTRING&full);
public:
	void editrecs (const char *preset);
	int empty (void);
	PRIMARY *finddomain (const char *name)const;
	FORWARD *findforward (const char *name)const;
	PRIMARY *findprimary (const char *host);
	SECONDARY *findsecond (const char *name)const;
	int geta (const char *host, IP_ADDRS&tbip);
	void getalladr (IP_ADDRS&adrs);
	const char *getcfgdir (void)const;
	bool getnotify (void)const;
	long getrevdate (void);
private:
	void init (bool extract);
public:
	void listconfigs (void);
	PRIMARY *locate_domain (const char *domain);
	int locate_ip (const char *ip, SSTRINGS&recs);
	SECONDARY *locate_secondary (const char *domain);
private:
	void mkzonedir (void);
public:
	int newdomain (const char *domain, const char *example);
	int newsecondary (const char *domain,
		 const char *primaries[],
		 int nbprim);
private:
	DNS&operator = (const DNS&);
	void parse4 (char *buf,
		 const char *fpath,
		 int noline,
		 bool extract);
	void parse8 (BIND8_LEXPARSE&lex, bool extract);
	void parseacl (BIND8_LEXPARSE&lex);
	void parselist (BIND8_LEXPARSE&lex, SSTRINGS&tb);
	void parselist_end (BIND8_LEXPARSE&lex, SSTRINGS&tb);
	void parselistenon (BIND8_LEXPARSE&lex);
	void parseoptions (BIND8_LEXPARSE&lex);
	void parseunknown (UNKNOWN *un, BIND8_LEXPARSE&lex);
	void parsezone (BIND8_LEXPARSE&lex, bool extract);
public:
	void preload_rev (PRIMARY *pri);
	int set (const char *fqhost,
		 const char *tbip[],
		 int nbip);
	int set (const char *fqhost,
		 const char *tbip[],
		 int nbip,
		 const SSTRINGS&ttls);
	int set (const char *fqhost,
		 const char *tbip[],
		 int nbip,
		 const SSTRINGS&ttls,
		 char doreverse[],
		 int &matchrev);
	int setcname (const SSTRING&fqhost, const SSTRING&cname);
private:
	void setconfig (SSTRING&p);
public:
	int setfromip (const char *host, const char *ip);
	void setip_in_dia (DIALOG&dia,
		 IP_ADDRS&tba,
		 SSTRINGS&ttls);
	void setip_in_dia (DIALOG&dia,
		 int level,
		 IP_ADDRS&tba,
		 SSTRINGS&ttls,
		 const char *title);
	void setlocalhost (void);
	int setmx (const SSTRING&fqhost,
		 const SSTRINGS&tbmx,
		 const SSTRINGS&ttls);
	int setns (const SSTRING&fqhost,
		 const SSTRINGS&tbns,
		 const SSTRINGS&ttls);
	int unset (const char *fqhost);
	int unsetcname (const SSTRING&fqhost);
	int unsetmx (const SSTRING&fqhost);
	int unsetns (const SSTRING&fqhost);
private:
	int update_one (SSTRING&full,
		 IP_ADDRS&tba,
		 SSTRINGS&tbattls,
		 SSTRINGS&tbns,
		 SSTRINGS&tbnsttls,
		 SSTRINGS&tbmx,
		 SSTRINGS&tbmxttls,
		 SSTRING&cname);
	int update_one (SSTRING&full,
		 IP_ADDRS&tba,
		 SSTRINGS&tbattls,
		 SSTRINGS&tbns,
		 SSTRINGS&tbnsttls,
		 SSTRINGS&tbmx,
		 SSTRINGS&tbmxttls,
		 SSTRING&cname,
		 char doreverse[4]);
public:
	int was_modified (void);
	int write (void);
	/*~PROTOEND~ DNS */
};
	
class DICTIONARY;
class USERACCT_COMNG;

#include "dnsconf.p"

// Keywords for parser
extern const char K_ZONE[],K_TYPE[],K_FILE[],K_NOTIFY[],K_MASTER[];
extern const char K_ALLOW_TRANSFER[],K_ALLOW_QUERY[];
extern const char K_ALLOW_RECURSION[];
extern const char K_ALLOW_UPDATE[],K_ALSO_NOTIFY[];
extern const char K_LOGGING[];


#endif

