#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <misc.h>
#include "dhcpd.h"
#include <ipstuff.h>
/* hubert@id-pro.de:
   some classes to controle if an ip is controlled by dhcp
 */

PUBLIC UWE_RANGE::UWE_RANGE (const SSTRING& _lo, const SSTRING& _hi){
  lo.setfrom(_lo.get());
  hi.setfrom(_hi.get());
}

/* check if a ip is inside a range
*/
PUBLIC int UWE_RANGE::inrange (IP_ADDR* ipa){
  if (lo.cmp(ipa) < 0 && hi.cmp(ipa) > 0)
    return 1;
  return 0;
}

PUBLIC UWE_RANGES::UWE_RANGES(DHCP& dh){
  DHCP_SUBNETS& subnets = dh.subnets;
  for (int nsub = 0; nsub < subnets.getnb(); nsub++){
    DHCP_RANGES& ranges = subnets.getitem(nsub)->ranges;
    for (int nrng = 0; nrng < ranges.getnb(); nrng++)
      add (new UWE_RANGE (ranges.getitem(nrng)->alloc_start,
			  ranges.getitem(nrng)->alloc_stop));
  }
}

PUBLIC UWE_RANGE* UWE_RANGES::getitem(int no){
  return (UWE_RANGE*) ARRAY::getitem(no);
}

/* check if a list of ips is inside of the ranges of the dhcp server
*/
PUBLIC int UWE_RANGES::inrange ( IP_ADDRS& ips){
  for (int nip = 0; nip < ips.getnb(); nip++){
    int found = 0;
    for (int nrng = 0; nrng < getnb(); nrng++)
      if(getitem(nrng)->inrange(ips.getitem(nip)) != 0){
	found = 1;
	break;
      }
    if (found == 0)
      return 0;
  }
  return 1;
}
