#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <misc.h>
#include "internal.h"
#include "../paths.h"
#include "apache.m"
#include <userconf.h>
#include <subsys.h>
#include <translat.h>
#include "keyword.h"


static APACHE_HELP_FILE help_httpd ("httpd");

const char subsys_httpd[]="httpd";
static LINUXCONF_SUBSYS subb (subsys_httpd,P_MSG_R(M_APACHE));


CONFIG_FILE_HTTPD httpd_conf ("/etc/httpd/conf/httpd.conf");

static PRIVILEGE p_apache ("apache"
	,P_MSG_U(T_PRIVIAPACHE,"Apache administration")
	,P_MSG_U(T_SERVICES,"1-Services"));

/* #Specification: httpd config / principle
	Linuxconf supports the apache httpd server. While the apache server
	share most of its configuration file format with ncsa httpd, I have not
	made any attempt at "virtualizing" linuxconf. Linuxconf hope to really
	support Apache closer and closer.

	It is expect that linuxconf will grow into something more modular one
	day and modules will be available to manage other things than apache
	if this is needed.
*/

#

PUBLIC void HTTPD_FEATURES::setallopt(int val)
{
	char cval = (val != 0) ? 1 : 0;
	symlinksifownermatch = cval;
	execcgi = cval;
	multiviews = cval;
	includes = cval;
	includesnoexec = cval;
	indexes=cval;
	followsymlinks=cval;
}

PUBLIC HTTPD_FEATURES::HTTPD_FEATURES(VIEWITEMS_SUB &sub)
{
	setallopt (0);
	it = sub.locate (K_OPTIONS);
	if (it != NULL){
		const char *arg = viewsub_getval (it);
		while (1){
			char word[200];
			arg=str_copyword(word,arg,sizeof(word));
			if (word[0] == '\0'){
				break;
			}else if (stricmp(word,K_ALL)==0){
				setallopt (1);
			}else if (stricmp(word,K_NONE)==0){
				setallopt (0);
			}else if (stricmp(word,K_INDEXES)==0){
				indexes = 1;
			}else if (stricmp(word,K_MULTIVIEWS)==0){
				multiviews = 1;
			}else if (stricmp(word,K_FOLLOWSYMLINKS)==0){
				followsymlinks = 1;
			}else if (stricmp(word,K_SYMLINKSIFOWNERMATCH)==0){
				symlinksifownermatch = 1;
			}else if (stricmp(word,K_INCLUDES)==0){
				includes = 1;
			}else if (stricmp(word,K_INCLUDESNOEXEC)==0){
				includesnoexec = 1;
			}else if (stricmp(word,K_EXECCGI)==0){
				execcgi = 1;
			}
		}
	}
}

PUBLIC void HTTPD_FEATURES::update (const char *prefix, VIEWITEMS_SUB &sub)
{
	char buf[1000];
	int len = sprintf (buf,"%s%s",prefix,K_OPTIONS);
	int startlen = len;
	if (execcgi) len += sprintf (buf+len," %s",K_EXECCGI);
	if (includes) len += sprintf (buf+len," %s",K_INCLUDES);
	if (includesnoexec) len += sprintf (buf+len," %s",K_INCLUDESNOEXEC);
	if (multiviews) len += sprintf (buf+len," %s",K_MULTIVIEWS);
	if (indexes) len += sprintf (buf+len," %s",K_INDEXES);
	if (followsymlinks) len += sprintf (buf+len," %s",K_FOLLOWSYMLINKS);
	if (symlinksifownermatch) len += sprintf (buf+len," %s",K_SYMLINKSIFOWNERMATCH);
	if (startlen != len){
		if (it == NULL){
			it = new VIEWITEM ("");
			sub.add (it);
		}
		it->line.setfrom (buf);
	}else if (it != NULL){
		it->line.setfromf ("%s none",K_OPTIONS);
	}
}


PUBLIC void HTTPD_OVERRIDE::update (const char *prefix, VIEWITEMS_SUB &sub)
{
	char buf[1000];
	int len = sprintf (buf,"%s%s",prefix,K_ALLOWOVERRIDE);
	int startlen = len;
	if (authconfig) len += sprintf (buf+len," %s",K_AUTHCONFIG);
	if (fileinfo) len += sprintf (buf+len," %s",K_FILEINFO);
	if (indexes) len += sprintf (buf+len," %s",K_INDEXES);
	if (limit) len += sprintf (buf+len," %s",K_LIMIT);
	if (options) len += sprintf (buf+len," %s",K_OPTIONS);
	if (startlen != len){
		if (it == NULL){
			it = new VIEWITEM ("");
			sub.add (it);
		}
		it->line.setfrom (buf);
	}else if (it != NULL){
		sub.remove_del (it);
	}
}

PUBLIC HTTPD_USER *HTTPD_USERS::getitem(int no)
{
   return (HTTPD_USER *)ARRAY::getitem(no);
}
PUBLIC HTTPD_USERS::HTTPD_USERS (void) {

}
PUBLIC HTTPD_USERS *HTTPD_AUTHS::getitem(int no)
{
   return (HTTPD_USERS *)ARRAY::getitem(no);
}

PUBLIC HTTPD_CONFIG::HTTPD_CONFIG()
{
	itemss.read (httpd_conf,false);
}
PUBLIC HTTPD_CONFIG::HTTPD_CONFIG(bool extract)
{
	itemss.read (httpd_conf,extract);
}

PUBLIC int HTTPD_CONFIG::write()
{
	return itemss.write (httpd_conf);
}

PUBLIC CONFIG_FILE_HTTPD::CONFIG_FILE_HTTPD(const char *_path)
	: CONFIG_FILE(_path,help_httpd
		,CONFIGF_OPTIONNAL|CONFIGF_MANAGED,subsys_httpd)
{
}

PUBLIC int CONFIG_FILE_HTTPD::extract(SSTREAM &ss)
{
	int ret = CONFIG_FILE::extract (ss);
	HTTPD_CONFIG httpd (true);
	return ret;
}

PUBLIC void HTTPD_CONFIG::listconfigs()
{
	for (int i=0; i<itemss.includes.getnb(); i++){
		const char *path = itemss.includes.getitem(i)->get();
		new CONFIG_FILE (path,help_httpd,CONFIGF_OPTIONAL|CONFIGF_MANAGED
			,subsys_httpd);
	}
}

static void httpd_lister_fct()
{
	HTTPD_CONFIG httpd;
	httpd.listconfigs();
}

static CONFIG_FILE_LISTER httpd_lister(httpd_lister_fct);

