
/* general options window */

#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "amandaconf.h"
#include "amandaconf.m"

#include "am_tools.h"
#include "lame_parser.h"

void manage_general_opts_window(const char *given_groupname, CONFIG_FILE &cf_amandaconf, t_parser_control *parser_control)
{
    struct {
        SSTRING org,
            mailto;
        complexint dumpcycle,
            runspercycle,
            tapecycle;
        SSTRING dumpuser;

        SSTRING tapedev,
            rawtapedev,
            tpchanger,
            changerdev,
            changerfile;
        complexint runtapes;
        SSTRING labelstr,
            tapetype;

        complexint etimeout,
            netusage,
            inparallel,
            maxdumps,
            bumpsize;
        SSTRING bumpmult;  // float
        complexint bumpdays;

        SSTRING diskfile,
            infofile,
            logdir,
            indexdir,
            tapelist;
        complexint reserve;
    } my_intvars;

    char *groupname=NULL;
    DIALOG my_dialog;
    MENU_STATUS my_button=(MENU_STATUS)0;
    int         my_selection=0;

    /* loads vars.. */
    bload_str(org, "org");
    bload_str(mailto, "mailto");
    bload_cint(dumpcycle, "dumpcycle");
    bload_cint(runspercycle, "runspercycle");
    bload_cint(tapecycle, "tapecycle");
    bload_str(dumpuser, "dumpuser");
    bload_str(tapedev, "tapedev");
    bload_str(rawtapedev, "rawtapedev");
    bload_str(tpchanger, "tpchanger");
    bload_str(changerdev, "changerdev");
    bload_str(changerfile, "changerfile");
    bload_cint(runtapes, "runtapes");
    bload_str(labelstr, "labelstr");
    bload_str(tapetype, "tapetype");
    bload_cint(etimeout, "etimeout");
    bload_cint(netusage, "netusage");
    bload_cint(inparallel, "inparallel");
    bload_cint(maxdumps, "maxdumps");
    bload_cint(bumpsize, "bumpsize");
    bload_str(bumpmult, "bumpmult");
    bload_cint(bumpdays, "bumpdays");
    bload_str(diskfile, "diskfile");
    bload_str(infofile, "infofile");
    bload_str(logdir, "logdir");
    bload_str(indexdir, "indexdir");
    bload_str(tapelist, "tapelist");
    bload_cint(reserve, "reserve");

    /* builds gui.. */
    // other
    my_dialog.newf_title(MSG_U(T_OTHER,"Other"), 1, "", MSG_R(T_OTHER));
    bgui_str(org,MSG_U(F_CONFIGDESC, "Config. description:"));
    bgui_str(mailto,MSG_U(F_MAILREPORTSTO,"Mail reports to:"));
    bgui_cint(dumpcycle,MSG_U(F_GENERALDUMPCYCLE,"Dump cycle:"));
    bgui_cint(runspercycle,MSG_U(F_RUNSPERCYCLE,"Runs per cycle:"));
    bgui_cint(tapecycle,MSG_U(F_TAPECYCLE,"Tape cycle:"));
    bgui_str(dumpuser,MSG_U(F_DUMPUSER,"Dump user:"));
    bgui_cint(runtapes,MSG_U(F_RUNTAPES,"Run tapes:"));
    bgui_cint(etimeout,MSG_U(F_ETIMEOUT,"Estimation timeout:"));
    bgui_cint(netusage,MSG_U(F_NETUSAGE,"Net usage:"));
    bgui_cint(inparallel,MSG_U(F_MAXPARALLELBKPS,"Max. parallel backups:"));
    bgui_cint(maxdumps,MSG_U(F_MASPARALLELBKPSHOST,"Max. parallel backups per host:"));
    bgui_cint(bumpsize,MSG_U(F_BUMPSIZE,"Bump size:"));
    bgui_str(bumpmult,MSG_U(F_BUMPMULTIPLIER,"Bump multiplier (float):"));
    bgui_cint(bumpdays,MSG_U(F_BUMPDAYS,"Bump days:"));
    bgui_cint(reserve,MSG_U(F_RESERVEDHDSPACE,"Reserved HD space (\%):"));
    // tape device
    my_dialog.newf_title(MSG_U(T_TAPEDEVICE,"Tape device"), 1, "", MSG_R(T_TAPEDEVICE));
    bgui_str(labelstr,MSG_U(F_TAPELABELS,"Tape labels (reg exp):"));
    bgui_fl_groupitems(tapetype,"define tapetype ",MSG_U(F_TAPETYPE,"Tape type:"),stapetype);
    bgui_str(tapedev,MSG_U(F_TAPEDEVICE,"Tape device:"));
    bgui_str(rawtapedev,MSG_U(F_RAWTAPEDEVICE,"Raw tape device:"));
    bgui_str(tpchanger,MSG_U(F_TAPECHANGERNAME,"Tape changer name:"));
    bgui_str(changerdev,MSG_U(F_TAPECHANGERDEVICE,"Tape changer device:"));
    bgui_str(changerfile,MSG_U(F_TAPECHANGERCONFIG,"Tape changer status file:"));
    // paths
    my_dialog.newf_title(MSG_U(T_PATHSFILES,"Paths/Files"), 1, "", MSG_R(T_PATHSFILES));
    bgui_str(diskfile,MSG_U(F_DISKLISTFILE,"Disklist file:"));
    bgui_str(infofile,MSG_U(F_INFOFILE,"Info file:"));
    bgui_str(logdir,MSG_U(F_DIRECTORYFORLOGS,"Directory for logs:"));
    bgui_str(indexdir,MSG_U(F_DIRECTORYFORINDEXFILES,"Directory for index files:"));
    bgui_str(tapelist,MSG_U(F_ACTIVETAPELISTFILE,"Active tape list file:"));

    /* opens dialog.. */
    my_selection=0;
    my_button=my_dialog.edit(MSG_U(T_GENERALSETTINGS,"General settings"), "", general_helpfile, my_selection, MENUBUT_QUIT|MENUBUT_ACCEPT);

    switch(my_button){
    case MENU_QUIT:
    case MENU_ESCAPE:
        return;
    case MENU_ACCEPT:
        /* save vars if requested so.. */
        bsave_str(org, "org");
        bsave_str(mailto, "mailto");
        bsave_cint(dumpcycle, "dumpcycle");
        bsave_cint(runspercycle, "runspercycle");
        bsave_cint(tapecycle, "tapecycle");
        bsave_str(dumpuser, "dumpuser");
        bsave_str(tapedev, "tapedev");
        bsave_str(rawtapedev, "rawtapedev");
        bsave_str(tpchanger, "tpchanger");
        bsave_str(changerdev, "changerdev");
        bsave_str(changerfile, "changerfile");
        bsave_cint(runtapes, "runtapes");
        bsave_str(labelstr, "labelstr");
        bsave_str(tapetype, "tapetype");
        bsave_cint(etimeout, "etimeout");
        bsave_cint(netusage, "netusage");
        bsave_cint(inparallel, "inparallel");
        bsave_cint(maxdumps, "maxdumps");
        bsave_cint(bumpsize, "bumpsize");
        bsave_str(bumpmult, "bumpmult");
        bsave_cint(bumpdays, "bumpdays");
        bsave_str(diskfile, "diskfile");
        bsave_str(infofile, "infofile");
        bsave_str(logdir, "logdir");
        bsave_str(indexdir, "indexdir");
        bsave_str(tapelist, "tapelist");
        bsave_cint(reserve, "reserve");

        update_file(parser_control);
    default:
        break;
    }
}

